/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapGenerator;

public final class MapEditorController {
    private static final Logger logger = Logger.getLogger(MapEditorController.class.getName());
    private final FreeColClient freeColClient;
    private MapEditorTransformPanel.MapTransform currentMapTransform = null;
    private GUI gui;

    public MapEditorController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    public void startMapEditor() {
        String tc = "freecol";
        try {
            FreeColTcFile tcData = new FreeColTcFile("freecol");
            Specification specification = tcData.getSpecification();
            this.freeColClient.setMapEditor(true);
            FreeColServer freeColServer = new FreeColServer(specification, false, false, 0, null);
            this.freeColClient.setFreeColServer(freeColServer);
            this.freeColClient.setGame(freeColServer.getGame());
            this.freeColClient.setMyPlayer(null);
            this.gui.playSound(null);
            this.gui.closeMainPanel();
            this.gui.closeMenus();
            this.freeColClient.setInGame(true);
            this.gui.startMapEditorGUI();
        }
        catch (NoRouteToServerException e) {
            this.gui.errorMessage("server.noRouteToServer");
            return;
        }
        catch (IOException e) {
            this.gui.errorMessage("server.couldNotStart");
            return;
        }
    }

    public void setMapTransform(MapEditorTransformPanel.MapTransform mt) {
        this.currentMapTransform = mt;
        MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
        if (mca.getMapControls() != null) {
            mca.getMapControls().update(mt);
        }
    }

    public MapEditorTransformPanel.MapTransform getMapTransform() {
        return this.currentMapTransform;
    }

    public void transform(Tile t) {
        if (this.currentMapTransform != null) {
            this.currentMapTransform.transform(t);
        }
    }

    public void newMap() {
        Game game = this.freeColClient.getGame();
        MapGenerator mapGenerator = this.freeColClient.getFreeColServer().getMapGenerator();
        OptionGroup group = this.freeColClient.getGame().getMapGeneratorOptions();
        if ((group = this.gui.showMapGeneratorOptionsDialog(group, true, true)) == null) {
            return;
        }
        try {
            if (game.getSpecification().getDifficultyLevel() == null) {
                game.getSpecification().applyDifficultyLevel("model.difficulty.medium");
            }
            mapGenerator.createMap(game);
            this.gui.setFocus(game.getMap().getTile(1, 1));
            this.freeColClient.getActionManager().update();
            this.gui.refresh();
        }
        catch (FreeColException e) {
            this.gui.closeMenus();
            this.gui.errorMessage(e.getMessage());
        }
    }

    public void saveGame() {
        String fileName = "my_map.fsg";
        File file = this.gui.showSaveDialog(FreeCol.getSaveDirectory(), fileName);
        if (file != null) {
            this.saveGame(file);
        }
    }

    public void saveGame(final File file) {
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        Thread t = new Thread("FreeColClient:Saving Map"){

            public void run() {
                try {
                    MiniMap miniMap = new MiniMap(MapEditorController.this.freeColClient, MapEditorController.this.gui);
                    miniMap.setTileSize(24);
                    int width = MapEditorController.this.freeColClient.getGame().getMap().getWidth() * 24 + 12;
                    int height = MapEditorController.this.freeColClient.getGame().getMap().getHeight() * 24 / 4;
                    BufferedImage image = new BufferedImage(width, height, 2);
                    Graphics2D g2d = image.createGraphics();
                    miniMap.paintMap(g2d, width, height);
                    double scaledWidth = Math.min(64 * width / height, 128);
                    BufferedImage scaledImage = new BufferedImage((int)scaledWidth, 64, 2);
                    scaledImage.createGraphics().drawImage(image, 0, 0, (int)scaledWidth, 64, null);
                    MapEditorController.this.freeColClient.getFreeColServer().saveGame(file, "mapEditor", null, scaledImage);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.gui.closeStatusPanel();
                            MapEditorController.this.gui.requestFocusInWindow();
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.gui.errorMessage("couldNotSaveGame");
                        }
                    });
                }
            }
        };
        t.start();
    }

    public void loadGame() {
        File file = this.gui.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            this.gui.errorMessage("fileNotFound");
            return;
        }
        this.loadGame(file);
    }

    public void loadGame(File file) {
        final File theFile = file;
        this.freeColClient.setMapEditor(true);
        this.gui.showStatusPanel(Messages.message("status.loadingGame"));
        Runnable loadGameJob = new Runnable(){

            public void run() {
                class ErrorJob
                implements Runnable {
                    private final String message;
                    final /* synthetic */ MapEditorController this$0;

                    ErrorJob(MapEditorController mapEditorController, String message) {
                        this.this$0 = mapEditorController;
                        this.message = message;
                    }

                    public void run() {
                        MapEditorController.access$100(this.this$0).closeMenus();
                        MapEditorController.access$100(this.this$0).errorMessage(this.message);
                    }
                }
                FreeColServer freeColServer = null;
                try {
                    freeColServer = new FreeColServer(new FreeColSavegameFile(theFile), 0, "MapEditor");
                    MapEditorController.this.freeColClient.setFreeColServer(freeColServer);
                    MapEditorController.this.freeColClient.setGame(freeColServer.getGame());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.gui.closeStatusPanel();
                            MapEditorController.this.gui.setFocus(MapEditorController.this.freeColClient.getGame().getMap().getTile(1, 1));
                            MapEditorController.this.freeColClient.getActionManager().update();
                            MapEditorController.this.gui.refresh();
                        }
                    });
                }
                catch (NoRouteToServerException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.noRouteToServer"));
                }
                catch (FileNotFoundException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "fileNotFound"));
                }
                catch (IOException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.couldNotStart"));
                }
                catch (FreeColException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, e.getMessage()));
                }
            }
        };
        this.freeColClient.worker.schedule(loadGameJob);
    }

    private void reloadMainPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MapEditorController.this.gui.closeMainPanel();
                MapEditorController.this.gui.showMainPanel();
                MapEditorController.this.gui.playSound("sound.intro.general");
            }
        });
    }
}

