/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ChipResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import org.w3c.dom.Element;

public final class PreGameController {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());
    private FreeColClient freeColClient;
    private GUI gui;

    public PreGameController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    public void setReady(boolean ready) {
        this.freeColClient.getMyPlayer().setReady(ready);
        Element readyElement = DOMMessage.createNewRootElement("ready");
        readyElement.setAttribute("value", Boolean.toString(ready));
        this.freeColClient.getClient().send(readyElement);
    }

    public void setNation(Nation nation) {
        this.freeColClient.getMyPlayer().setNation(nation);
        Element nationElement = DOMMessage.createNewRootElement("setNation");
        nationElement.setAttribute("value", nation.getId());
        this.freeColClient.getClient().sendAndWait(nationElement);
    }

    public void setNationType(NationType nationType) {
        this.freeColClient.getMyPlayer().setNationType(nationType);
        Element nationTypeElement = DOMMessage.createNewRootElement("setNationType");
        nationTypeElement.setAttribute("value", nationType.getId());
        this.freeColClient.getClient().sendAndWait(nationTypeElement);
    }

    public void setAvailable(Nation nation, NationOptions.NationState state) {
        this.freeColClient.getGame().getNationOptions().getNations().put(nation, state);
        Element availableElement = DOMMessage.createNewRootElement("setAvailable");
        availableElement.setAttribute("nation", nation.getId());
        availableElement.setAttribute("state", state.toString());
        this.freeColClient.getClient().sendAndWait(availableElement);
    }

    public void requestLaunch() {
        if (!this.freeColClient.getGame().isAllPlayersReadyToLaunch()) {
            this.gui.errorMessage("server.notAllReady");
            return;
        }
        Element requestLaunchElement = DOMMessage.createNewRootElement("requestLaunch");
        this.freeColClient.getClient().send(requestLaunchElement);
        this.gui.showStatusPanel(Messages.message("status.startingGame"));
    }

    public void chat(String message) {
        ChatMessage chatMessage = new ChatMessage(this.freeColClient.getMyPlayer(), message, Boolean.FALSE);
        this.freeColClient.getClient().send(chatMessage.toXMLElement());
    }

    public void sendGameOptions() {
        Element updateGameOptionsElement = DOMMessage.createNewRootElement("updateGameOptions");
        OptionGroup gameOptions = this.freeColClient.getGame().getSpecification().getOptionGroup("gameOptions");
        updateGameOptionsElement.appendChild(gameOptions.toXMLElement(updateGameOptionsElement.getOwnerDocument()));
        this.freeColClient.getClient().send(updateGameOptionsElement);
    }

    public void sendMapGeneratorOptions() {
        OptionGroup mapGeneratorOptions = this.freeColClient.getGame().getMapGeneratorOptions();
        Element updateMapGeneratorOptionsElement = DOMMessage.createNewRootElement("updateMapGeneratorOptions");
        updateMapGeneratorOptionsElement.appendChild(mapGeneratorOptions.toXMLElement(updateMapGeneratorOptionsElement.getOwnerDocument()));
        this.freeColClient.getClient().send(updateMapGeneratorOptionsElement);
    }

    private void addPlayerResources(String nationId) {
        Color color = ResourceManager.getColor(nationId + ".color");
        ResourceMapping gameMapping = new ResourceMapping();
        gameMapping.add(nationId + ".chip", ChipResource.colorChip(color));
        gameMapping.add(nationId + ".mission.chip", ChipResource.missionChip(color, false));
        gameMapping.add(nationId + ".mission.expert.chip", ChipResource.missionChip(color, true));
        ResourceManager.addGameMapping(gameMapping);
    }

    public void startGame() {
        for (Player player : this.freeColClient.getGame().getPlayers()) {
            this.addPlayerResources(player.getNationID());
        }
        this.addPlayerResources(Nation.UNKNOWN_NATION_ID);
        Player myPlayer = this.freeColClient.getMyPlayer();
        if (!this.freeColClient.isHeadless()) {
            this.gui.closeMainPanel();
            this.gui.closeMenus();
            this.gui.closeStatusPanel();
            this.gui.playSound(null);
            this.gui.playSound("sound.intro." + myPlayer.getNationID());
        }
        this.freeColClient.getClient().setMessageHandler(this.freeColClient.getInGameInputHandler());
        if (!this.freeColClient.isHeadless()) {
            this.freeColClient.setInGame(true);
            this.gui.setupInGameMenuBar();
        }
        InGameController igc = this.freeColClient.getInGameController();
        this.gui.setSelectedTile((Tile)myPlayer.getEntryLocation(), false);
        if (this.freeColClient.currentPlayerIsMyPlayer()) {
            igc.nextActiveUnit();
        }
        this.gui.setUpMouseListenersForCanvas();
        if (FreeCol.isInDebugMode() && FreeCol.getDebugRunTurns() > 0) {
            this.freeColClient.skipTurns(FreeCol.getDebugRunTurns());
        } else if (this.freeColClient.getGame().getTurn().getNumber() == 1) {
            ModelMessage message = new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.startGame", myPlayer);
            String direction = myPlayer.getNation().startsOnEastCoast() ? "west" : "east";
            message.add("%direction%", direction);
            myPlayer.addModelMessage(message);
            igc.nextModelMessage();
        }
    }
}

