/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public class LoadAction
extends MapboardAction {
    public static final String id = "loadAction";

    public LoadAction(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, id);
    }

    protected boolean shouldBeEnabled() {
        if (super.shouldBeEnabled()) {
            Unit unit = this.gui.getActiveUnit();
            return unit != null && unit.isCarrier() && unit.getGoodsCount() > 0 && unit.getColony() != null;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Colony colony;
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && (colony = unit.getColony()) != null) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (goods.getAmount() >= 100 || colony.getGoodsCount(goods.getType()) <= 0) continue;
                int amount = Math.min(100 - goods.getAmount(), colony.getGoodsCount(goods.getType()));
                Goods newGoods = new Goods(goods.getGame(), colony, goods.getType(), amount);
                this.getFreeColClient().getInGameController().loadCargo(newGoods, unit);
            }
        }
    }
}

