/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.option.FileOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileOptionUI
extends OptionUI<FileOption> {
    private JPanel panel = new JPanel();
    private final JTextField fileField;

    public FileOptionUI(final GUI gui, FileOption option, boolean editable) {
        super(gui, option, editable);
        this.panel.add(this.getLabel());
        File file = option.getValue();
        this.fileField = new JTextField(file == null ? null : file.getAbsolutePath(), 10);
        this.panel.add(this.fileField);
        JButton browse = new JButton(Messages.message("file.browse"));
        if (editable) {
            browse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File file = gui.showLoadDialog(FreeCol.getSaveDirectory());
                    if (file == null) {
                        return;
                    }
                    if (!file.isFile()) {
                        gui.errorMessage("fileNotFound");
                        return;
                    }
                    FileOptionUI.this.fileField.setText(file.getAbsolutePath());
                }
            });
        }
        this.panel.add(browse);
        JButton remove = new JButton(Messages.message("option.remove"));
        if (editable) {
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileOptionUI.this.fileField.setText("");
                }
            });
        }
        this.panel.add(remove);
        browse.setEnabled(editable);
        remove.setEnabled(editable);
        this.fileField.setEnabled(false);
        this.getLabel().setLabelFor(this.fileField);
    }

    public void setValue(File f) {
        if (f == null) {
            this.fileField.setText("");
        } else {
            this.fileField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        if (this.fileField.getText().equals("")) {
            ((FileOption)this.getOption()).setValue(null);
        } else {
            ((FileOption)this.getOption()).setValue(new File(this.fileField.getText()));
        }
    }

    @Override
    public void reset() {
        File file = ((FileOption)this.getOption()).getValue();
        this.fileField.setText(file == null ? null : file.getAbsolutePath());
    }
}

