/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;

public class RebelToolTip
extends JToolTip {
    public RebelToolTip(FreeColClient freeColClient, GUI gui, Colony colony) {
        this.setLayout((LayoutManager)new MigLayout("fillx, wrap 3", "[][right][right]", ""));
        int members = colony.getMembers();
        int rebels = colony.getSoL();
        this.add(new JLabel(Messages.message(StringTemplate.template("colonyPanel.rebelLabel").addName("%number%", ""))));
        this.add(new JLabel(Integer.toString(members)));
        this.add(new JLabel(Integer.toString(rebels) + "%"));
        this.add(new JLabel(Messages.message(StringTemplate.template("colonyPanel.royalistLabel").addName("%number%", ""))));
        this.add(new JLabel(Integer.toString(colony.getUnitCount() - members)));
        this.add(new JLabel(Integer.toString(colony.getTory()) + "%"));
        int libertyProduction = 0;
        for (GoodsType goodsType : colony.getSpecification().getLibertyGoodsTypeList()) {
            this.add(new JLabel(Messages.message(goodsType.getNameKey())));
            int production = colony.getNetProductionOf(goodsType);
            libertyProduction += production;
            this.add((Component)new ProductionLabel(freeColClient, gui, goodsType, production), "span 2");
        }
        int liberty = colony.getLiberty();
        int modulo = liberty % 200;
        FreeColProgressBar progress = new FreeColProgressBar(gui, null, 0, 200, modulo, libertyProduction);
        progress.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth() - 32, 20));
        this.add((Component)progress, "span 3");
        float turns100 = 0.0f;
        float turns50 = 0.0f;
        float turnsNext = 0.0f;
        if (libertyProduction > 0) {
            int requiredLiberty = 200 * colony.getUnitCount();
            if (liberty < requiredLiberty) {
                turns100 = (float)(requiredLiberty - liberty) / (float)libertyProduction;
            }
            if (liberty < (requiredLiberty /= 2)) {
                turns50 = (float)(requiredLiberty - liberty) / (float)libertyProduction;
            }
            if (members < colony.getUnitCount() && liberty < (requiredLiberty = 200 * (members + 1))) {
                turnsNext = (float)(requiredLiberty - liberty) / (float)libertyProduction;
            }
        }
        String na = Messages.message("notApplicable.short");
        this.add(new JLabel(Messages.message("report.nextMember")));
        this.add((Component)new JLabel(turnsNext == 0.0f ? na : Integer.toString((int)Math.ceil(turnsNext))), "skip");
        this.add(new JLabel(Messages.message("report.50percent")));
        this.add((Component)new JLabel(turns50 == 0.0f ? na : Integer.toString((int)Math.ceil(turns50))), "skip");
        this.add(new JLabel(Messages.message("report.100percent")));
        this.add((Component)new JLabel(turns100 == 0.0f ? na : Integer.toString((int)Math.ceil(turns100))), "skip");
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }
}

