/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;

public final class ReportTradePanel
extends ReportPanel {
    private List<GoodsType> storableGoods = new ArrayList<GoodsType>();
    private List<Colony> colonies;
    private final JPanel goodsHeader = new JPanel(){

        public String getUIClassID() {
            return "ReportPanelUI";
        }
    };

    public ReportTradePanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportTradeAction.name"));
        this.setSize(this.getMinimumSize());
        Player player = this.getMyPlayer();
        this.colonies = this.getSortedColonies();
        this.goodsHeader.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.scrollPane.setColumnHeaderView(this.goodsHeader);
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.storableGoods.add(goodsType);
        }
        Market market = player.getMarket();
        this.reportPanel.removeAll();
        this.goodsHeader.removeAll();
        String layoutConstraints = "insets 0, gap 0 0";
        String columnConstraints = "[170!, fill][42!, fill]";
        String rowConstraints = "[fill]";
        this.reportPanel.setLayout((LayoutManager)new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.goodsHeader.setLayout((LayoutManager)new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.goodsHeader.setOpaque(true);
        JLabel emptyLabel = new JLabel();
        emptyLabel.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
        this.goodsHeader.add((Component)emptyLabel, "cell 0 0");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.unitsSold"), "cell 0 0");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.beforeTaxes"), "cell 0 1");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.afterTaxes"), "cell 0 2");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.cargoUnits"), "cell 0 3");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.totalUnits"), "cell 0 4");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.totalDelta"), "cell 0 5");
        TypeCountMap<GoodsType> totalUnits = new TypeCountMap<GoodsType>();
        TypeCountMap<GoodsType> deltaUnits = new TypeCountMap<GoodsType>();
        TypeCountMap<GoodsType> cargoUnits = new TypeCountMap<GoodsType>();
        Iterator<Unit> iterator = player.getUnitIterator();
        while (iterator.hasNext()) {
            Unit unit = iterator.next();
            if (!unit.isCarrier()) continue;
            for (Goods goods : unit.getGoodsContainer().getCompactGoods()) {
                cargoUnits.incrementCount(goods.getType(), goods.getAmount());
                totalUnits.incrementCount(goods.getType(), goods.getAmount());
            }
        }
        int column = 0;
        for (GoodsType goodsType : this.storableGoods) {
            ++column;
            int sales = player.getSales(goodsType);
            int beforeTaxes = player.getIncomeBeforeTaxes(goodsType);
            int afterTaxes = player.getIncomeAfterTaxes(goodsType);
            MarketLabel marketLabel = new MarketLabel(goodsType, market, this.getGUI());
            marketLabel.setBorder(FreeColPanel.TOPCELLBORDER);
            marketLabel.setVerticalTextPosition(3);
            marketLabel.setHorizontalTextPosition(0);
            this.goodsHeader.add(marketLabel);
            this.reportPanel.add((Component)this.createNumberLabel(sales), "cell " + column + " 0");
            this.reportPanel.add((Component)this.createNumberLabel(beforeTaxes), "cell " + column + " 1");
            this.reportPanel.add((Component)this.createNumberLabel(afterTaxes), "cell " + column + " 2");
            this.reportPanel.add((Component)this.createNumberLabel(cargoUnits.getCount(goodsType)), "cell " + column + " 3");
        }
        int row = 6;
        for (int colonyIndex = 0; colonyIndex < this.colonies.size(); ++colonyIndex) {
            Colony colony = this.colonies.get(colonyIndex);
            for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
                deltaUnits.incrementCount(goodsType, colony.getNetProductionOf(goodsType));
            }
            for (Goods goods : colony.getGoodsContainer().getCompactGoods()) {
                totalUnits.incrementCount(goods.getType(), goods.getAmount());
            }
            JButton colonyButton = this.createColonyButton(colony, colonyIndex);
            this.reportPanel.add((Component)colonyButton, "cell 0 " + row + " 1 2");
            column = 0;
            for (GoodsType goodsType : this.storableGoods) {
                ++column;
                int amount = colony.getGoodsCount(goodsType);
                JLabel goodsLabel = new JLabel(String.valueOf(amount), 11);
                goodsLabel.setBorder(colonyIndex == 0 ? FreeColPanel.TOPCELLBORDER : FreeColPanel.CELLBORDER);
                if (colony.getExportData(goodsType).isExported()) {
                    goodsLabel.setText("*" + String.valueOf(amount));
                }
                this.reportPanel.add((Component)goodsLabel, "cell " + column + " " + row);
                int production = colony.getNetProductionOf(goodsType);
                JLabel productionLabel = this.createNumberLabel(production, true);
                StringBuffer toolTip = new StringBuffer();
                for (StringTemplate warning : colony.getWarnings(goodsType, amount, production)) {
                    if (toolTip.length() > 0) {
                        toolTip.append(" - ");
                    }
                    toolTip.append(Messages.message(warning));
                    productionLabel.setForeground(Color.MAGENTA);
                    productionLabel.setToolTipText(toolTip.toString());
                }
                this.reportPanel.add((Component)productionLabel, "cell " + column + " " + (row + 1));
            }
            row += 2;
        }
        this.reportPanel.add((Component)new JLabel(Messages.message("report.trade.hasCustomHouse")), "cell 0 " + ++row + ", span");
        column = 0;
        for (GoodsType goodsType : this.storableGoods) {
            this.reportPanel.add((Component)this.createNumberLabel(totalUnits.getCount(goodsType)), "cell " + ++column + " 4");
            this.reportPanel.add((Component)this.createNumberLabel(deltaUnits.getCount(goodsType), true), "cell " + column + " 5, wrap 20");
        }
    }

    private JLabel createLeftLabel(String key) {
        JLabel result = new JLabel(Messages.message(key), 11);
        result.setBorder(FreeColPanel.LEFTCELLBORDER);
        return result;
    }

    private JLabel createNumberLabel(int value) {
        return this.createNumberLabel(value, false);
    }

    private JLabel createNumberLabel(int value, boolean alwaysAddSign) {
        JLabel result = new JLabel(String.valueOf(value), 11);
        result.setBorder(FreeColPanel.CELLBORDER);
        if (value < 0) {
            result.setForeground(Color.RED);
        } else if (alwaysAddSign && value > 0) {
            result.setText("+" + value);
        }
        return result;
    }

    private JButton createColonyButton(Colony colony, int index) {
        JButton button = new JButton();
        String name = colony.getName();
        if (this.colonies.get(index).hasAbility("model.ability.export")) {
            name = name + "*";
        }
        button.setText(name);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setHorizontalAlignment(10);
        button.setAlignmentY(0.8f);
        if (index == 0) {
            button.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
        } else {
            button.setBorder(FreeColPanel.LEFTCELLBORDER);
        }
        button.setActionCommand(colony.getId());
        button.addActionListener(this);
        return button;
    }

    public Dimension getMinimumSize() {
        return new Dimension(900, 750);
    }

    protected Border createBorder() {
        return new EmptyBorder(0, 20, 20, 20);
    }
}

