/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.PlayersTable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;

public final class StartGamePanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(StartGamePanel.class.getName());
    private static final int START = 0;
    private static final int CANCEL = 1;
    private static final int READY = 3;
    private static final int CHAT = 4;
    private static final int GAME_OPTIONS = 5;
    private static final int MAP_GENERATOR_OPTIONS = 6;
    private boolean singlePlayerGame;
    private JCheckBox readyBox;
    private JTextField chat;
    private JTextArea chatArea;
    private JButton start;
    private JButton gameOptions;
    private JButton mapGeneratorOptions;
    private PlayersTable table;

    public StartGamePanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
    }

    public void initialize(boolean singlePlayer) {
        this.removeAll();
        this.singlePlayerGame = singlePlayer;
        NationOptions nationOptions = this.getGame().getNationOptions();
        JButton cancel = new JButton(Messages.message("cancel"));
        JScrollPane chatScroll = null;
        this.setCancelComponent(cancel);
        this.table = new PlayersTable(this.getFreeColClient(), this.getGUI(), nationOptions, this.getMyPlayer());
        this.start = new JButton(Messages.message("startGame"));
        this.gameOptions = new JButton(Messages.message("gameOptions"));
        this.mapGeneratorOptions = new JButton(Messages.message("mapGeneratorOptions"));
        this.readyBox = new JCheckBox(Messages.message("iAmReady"));
        if (this.singlePlayerGame) {
            this.getMyPlayer().setReady(false);
            this.readyBox.setSelected(true);
        } else {
            this.readyBox.setSelected(this.getMyPlayer().isReady());
            this.chat = new JTextField();
            this.chatArea = new JTextArea();
            chatScroll = new JScrollPane(this.chatArea, 22, 31);
        }
        this.refreshPlayersTable();
        JScrollPane tableScroll = new JScrollPane(this.table, 20, 31);
        tableScroll.getViewport().setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout("fill, wrap 2"));
        this.add((Component)tableScroll, "width 600:, grow");
        if (!this.singlePlayerGame) {
            this.add((Component)chatScroll, "width 250:, grow");
        }
        this.add((Component)this.mapGeneratorOptions, "newline, split 2, growx, top, sg");
        this.add((Component)this.gameOptions, "growx, top, sg");
        if (!this.singlePlayerGame) {
            this.add((Component)this.chat, "grow, top");
        }
        this.add((Component)this.readyBox, "newline");
        this.add((Component)this.start, "newline, span, split 2, tag ok");
        this.add((Component)cancel, "tag cancel");
        this.start.setActionCommand(String.valueOf(0));
        cancel.setActionCommand(String.valueOf(1));
        this.readyBox.setActionCommand(String.valueOf(3));
        this.gameOptions.setActionCommand(String.valueOf(5));
        this.mapGeneratorOptions.setActionCommand(String.valueOf(6));
        if (!this.singlePlayerGame) {
            this.chat.setActionCommand(String.valueOf(4));
            this.chat.addActionListener(this);
            this.chatArea.setEditable(false);
            this.chatArea.setLineWrap(true);
            this.chatArea.setWrapStyleWord(true);
            this.chatArea.setText("");
        }
        StartGamePanel.enterPressesWhenFocused(this.start);
        StartGamePanel.enterPressesWhenFocused(cancel);
        this.start.addActionListener(this);
        cancel.addActionListener(this);
        this.readyBox.addActionListener(this);
        this.gameOptions.addActionListener(this);
        this.mapGeneratorOptions.addActionListener(this);
        this.setSize(this.getPreferredSize());
        this.setEnabled(true);
    }

    public void requestFocus() {
        this.start.requestFocus();
    }

    public void updateMapGeneratorOptions() {
        this.getFreeColClient().getGame().getMapGeneratorOptions().getOption("model.option.mapWidth");
        this.getFreeColClient().getGame().getMapGeneratorOptions().getOption("model.option.mapHeight");
    }

    public void updateGameOptions() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
        if (this.singlePlayerGame && enabled) {
            this.readyBox.setEnabled(false);
        }
        if (enabled) {
            this.start.setEnabled(this.getFreeColClient().isAdmin());
        }
        this.gameOptions.setEnabled(enabled);
    }

    private boolean checkVictoryConditions() {
        Specification spec = this.getSpecification();
        if (this.singlePlayerGame && spec.getBoolean("model.option.victoryDefeatEuropeans") && !spec.getBoolean("model.option.victoryDefeatREF")) {
            int n = 0;
            for (Map.Entry<Nation, NationOptions.NationState> e : this.getGame().getNationOptions().getNations().entrySet()) {
                if (!e.getKey().getType().isEuropean() || e.getValue() == NationOptions.NationState.NOT_AVAILABLE) continue;
                ++n;
            }
            if (n == 0) {
                this.getGUI().errorMessage("victory.noEuropeans");
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    int row = this.table.getSelectedRow();
                    int col = this.table.getSelectedColumn();
                    if (row > -1 && col > -1) {
                        this.table.getCellEditor(row, col).stopCellEditing();
                    }
                    if (!this.checkVictoryConditions()) break;
                    if (this.singlePlayerGame) {
                        this.getMyPlayer().setReady(true);
                    }
                    this.getFreeColClient().getPreGameController().requestLaunch();
                    break;
                }
                case 1: {
                    this.getFreeColClient().getConnectController().quitGame(true);
                    this.getGUI().removeFromCanvas(this);
                    this.getGUI().showNewPanel();
                    break;
                }
                case 3: {
                    this.getFreeColClient().getPreGameController().setReady(this.readyBox.isSelected());
                    this.refreshPlayersTable();
                    break;
                }
                case 4: {
                    if (this.chat.getText().trim().length() > 0) {
                        this.getFreeColClient().getPreGameController().chat(this.chat.getText());
                        this.displayChat(this.getMyPlayer().getName(), this.chat.getText(), false);
                        this.chat.setText("");
                    }
                    break;
                }
                case 5: {
                    this.getGUI().showGameOptionsDialog(this.getFreeColClient().isAdmin(), true);
                    break;
                }
                case 6: {
                    OptionGroup mgo = this.getFreeColClient().getGame().getMapGeneratorOptions();
                    FileOption importFile = (FileOption)mgo.getOption("model.option.importFile");
                    boolean loadCustomOptions = importFile.getValue() == null;
                    this.getGUI().showMapGeneratorOptionsDialog(mgo, this.getFreeColClient().isAdmin(), loadCustomOptions);
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public void displayChat(String senderName, String message, boolean privateChat) {
        if (privateChat) {
            this.chatArea.append(senderName + " (private): " + message + '\n');
        } else {
            this.chatArea.append(senderName + ": " + message + '\n');
        }
    }

    public void refreshPlayersTable() {
        this.table.update();
    }
}

