/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import net.sf.freecol.client.gui.ImageLibrary;

public class FreeColToolTipUI
extends BasicToolTipUI {
    private static FreeColToolTipUI sharedInstance = new FreeColToolTipUI();
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    private static int margin = 5;
    private static int maximumWidth = 300;

    private FreeColToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public static void setMaximumWidth(int width) {
        maximumWidth = width;
    }

    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            ImageLibrary.drawTiledImage("background.FreeColToolTip", g, c, null);
        }
        g.setColor(Color.BLACK);
        Graphics2D graphics = (Graphics2D)g;
        AttributedCharacterIterator styledText = new AttributedString(((JToolTip)c).getTipText()).getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
        float x = margin;
        float y = margin;
        while (measurer.getPosition() < styledText.getEndIndex()) {
            TextLayout layout = measurer.nextLayout(maximumWidth);
            float dx = layout.isLeftToRight() ? 0.0f : (float)maximumWidth - layout.getAdvance();
            layout.draw(graphics, x + dx, y += layout.getAscent());
            y += layout.getDescent() + layout.getLeading();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        AttributedCharacterIterator styledText = new AttributedString(((JToolTip)c).getTipText()).getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
        float x = 0.0f;
        float y = 0.0f;
        while (measurer.getPosition() < styledText.getEndIndex()) {
            TextLayout layout = measurer.nextLayout(maximumWidth);
            x = Math.max(x, layout.getVisibleAdvance());
            y += layout.getAscent() + layout.getDescent() + layout.getLeading();
        }
        return new Dimension((int)(x + (float)(2 * margin)), (int)(y + (float)(2 * margin)));
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

