/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
extends WorkLocation
implements Named,
Comparable<Building>,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected BuildingType buildingType;

    protected Building() {
    }

    protected Building(Game game, Colony colony, BuildingType type) {
        super(game);
        this.setColony(colony);
        this.buildingType = type;
    }

    public Building(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getNameKey() {
        return this.buildingType.getNameKey();
    }

    public int getLevel() {
        return this.buildingType.getLevel();
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("inLocation").add("%location%", this.getNameKey());
    }

    public String getNextNameKey() {
        BuildingType next = this.buildingType.getUpgradesTo();
        return next == null ? null : next.getNameKey();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.buildingType.getUpgradesTo());
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    @Override
    public boolean hasAbility(String id) {
        return this.getType().hasAbility(id);
    }

    public boolean canBeDamaged() {
        return !this.buildingType.isAutomaticBuild() && !this.getColony().isAutomaticBuild(this.buildingType);
    }

    public boolean damage() {
        if (this.canBeDamaged()) {
            this.setType(this.buildingType.getUpgradesFrom());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    public boolean upgrade() {
        if (this.canBuildNext()) {
            this.setType(this.buildingType.getUpgradesTo());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    private void setType(BuildingType newBuildingType) {
        Colony colony = this.getColony();
        colony.getFeatureContainer().remove(this.buildingType.getFeatureContainer());
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            colony.getFeatureContainer().add(this.buildingType.getFeatureContainer());
            for (Unit unit : this.getUnitList()) {
                if (this.canAdd(unit.getType())) continue;
                unit.setLocation(colony.getTile());
            }
        }
        if (this.getUnitCount() > this.getUnitCapacity()) {
            for (Unit unit : this.getUnitList().subList(this.getUnitCapacity(), this.getUnitCount())) {
                unit.setLocation(colony.getTile());
            }
        }
    }

    @Override
    public int getUnitCapacity() {
        return this.buildingType.getWorkPlaces();
    }

    public UnitType getExpertUnitType() {
        return this.getSpecification().getExpertForProducing(this.getGoodsOutputType());
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        return UnitLocation.NoAddReason.NONE;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            return UnitLocation.NoAddReason.WRONG_TYPE;
        }
        UnitLocation.NoAddReason reason = this.getNoWorkReason();
        Unit unit = (Unit)locatable;
        BuildingType type = this.getType();
        return reason != UnitLocation.NoAddReason.NONE ? reason : (!type.canAdd(unit.getType()) ? UnitLocation.NoAddReason.MISSING_SKILL : super.getNoAddReason(locatable));
    }

    public boolean canAdd(UnitType unitType) {
        return this.canBeWorked() && this.buildingType.canAdd(unitType);
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        if (reason != UnitLocation.NoAddReason.NONE) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString() + " because " + (Object)((Object)reason));
        }
        Unit unit = (Unit)locatable;
        if (this.contains(unit)) {
            return true;
        }
        if (super.add(unit)) {
            unit.setState(Unit.UnitState.IN_COLONY);
            unit.setWorkType(this.getGoodsOutputType());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (super.remove(unit)) {
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    public GoodsType getGoodsOutputType() {
        return this.getType().getProducedGoodsType();
    }

    public GoodsType getGoodsInputType() {
        return this.getType().getConsumedGoodsType();
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public ProductionInfo getProductionInfo(AbstractGoods output, List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        GoodsType outputType = this.getGoodsOutputType();
        GoodsType inputType = this.getGoodsInputType();
        if (outputType != null && outputType != output.getType()) {
            throw new IllegalArgumentException("Wrong output type: " + output.getType() + " should have been: " + outputType);
        }
        int capacity = this.getColony().getWarehouseCapacity();
        if (this.buildingType.hasAbility("model.ability.avoidExcessProduction") && output.getAmount() >= capacity) {
            return result;
        }
        int availableInput = 0;
        if (inputType != null) {
            boolean found = false;
            for (AbstractGoods goods : input) {
                if (goods.getType() != inputType) continue;
                availableInput = goods.getAmount();
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("No input goods of type " + inputType + " available.");
            }
        }
        if (outputType != null) {
            int production;
            int actualInput;
            int maximumInput = 0;
            if (inputType != null && this.canAutoProduce()) {
                int available = this.getColony().getGoodsCount(outputType);
                if (available >= outputType.getBreedingNumber()) {
                    int divisor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingDivisor");
                    int factor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingFactor");
                    maximumInput = ((available - 1) / divisor + 1) * factor;
                }
            } else {
                maximumInput = this.getProductivity(new Unit[0]);
            }
            List<Modifier> productionModifiers = this.getProductionModifiers();
            int maximumProduction = (int)FeatureContainer.applyModifiers(maximumInput, this.getGame().getTurn(), productionModifiers);
            int n = actualInput = inputType == null ? maximumInput : Math.min(maximumInput, availableInput);
            if (availableInput < maximumInput && this.buildingType.hasAbility("model.ability.expertsUseConnections") && this.getSpecification().getBoolean("model.option.expertsHaveConnections")) {
                int minimumGoodsInput = 0;
                for (Unit unit : this.getUnitList()) {
                    if (unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                if (minimumGoodsInput > availableInput) {
                    actualInput = minimumGoodsInput;
                }
            }
            if ((production = (int)FeatureContainer.applyModifiers(actualInput, this.getGame().getTurn(), productionModifiers)) > 0) {
                if (this.buildingType.hasAbility("model.ability.avoidExcessProduction")) {
                    int total = output.getAmount() + production;
                    while (total > capacity) {
                        if (actualInput <= 0) {
                            return result;
                        }
                        production = (int)FeatureContainer.applyModifiers(--actualInput, this.getGame().getTurn(), productionModifiers);
                        total = output.getAmount() + production;
                        maximumInput = actualInput;
                        maximumProduction = production;
                    }
                }
                result.addProduction(new AbstractGoods(outputType, production));
                if (maximumProduction > production) {
                    result.addMaximumProduction(new AbstractGoods(outputType, maximumProduction));
                }
                if (inputType != null) {
                    result.addConsumption(new AbstractGoods(inputType, actualInput));
                    if (maximumInput > actualInput) {
                        result.addMaximumConsumption(new AbstractGoods(inputType, maximumInput));
                    }
                }
            }
        }
        return result;
    }

    public int getProduction() {
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getProduction();
        if (production == null || production.isEmpty()) {
            return 0;
        }
        return production.get(0).getAmount();
    }

    public int getMaximumProduction() {
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getMaximumProduction();
        if (production == null || production.isEmpty()) {
            return this.getProduction();
        }
        return production.get(0).getAmount();
    }

    public int getAdditionalProductionNextTurn(Unit addUnit) {
        return this.getUnitProductivity(addUnit);
    }

    @Override
    public boolean canAutoProduce() {
        return this.buildingType.hasAbility("model.ability.autoProduction");
    }

    private int getProductivity(Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int productivity = 0;
        for (Unit unit : this.getUnitList()) {
            productivity += this.getUnitProductivity(unit);
        }
        for (Unit unit : additionalUnits) {
            if (!this.canAdd(unit)) continue;
            productivity += this.getUnitProductivity(unit);
        }
        return productivity;
    }

    public int getUnitProductivity(Unit prodUnit) {
        if (this.getGoodsOutputType() == null || prodUnit == null) {
            return 0;
        }
        int productivity = this.buildingType.getBasicProduction();
        if (productivity > 0) {
            return (int)prodUnit.getType().getFeatureContainer().applyModifier(Math.max(1, productivity += this.getColony().getProductionBonus()), this.getGoodsOutputType().getId());
        }
        return 0;
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == this.getGoodsOutputType()) {
            return this.getProduction();
        }
        return 0;
    }

    @Override
    public int getProductionOf(Unit unit, GoodsType goodsType) {
        return unit == null || this.getGoodsOutputType() == null || this.getGoodsOutputType() != goodsType ? 0 : this.getUnitProductivity(unit);
    }

    @Override
    public int getPotentialProduction(UnitType unitType, GoodsType goodsType) {
        int production = 0;
        if (this.getGoodsOutputType() == goodsType && (production += this.buildingType.getBasicProduction()) > 0) {
            production += this.getColony().getProductionBonus();
            if (unitType != null) {
                unitType.getFeatureContainer().applyModifier(Math.max(1, production), this.getGoodsOutputType().getId());
            }
            production = (int)FeatureContainer.applyModifiers(production, this.getGame().getTurn(), this.getProductionModifiers());
        }
        return production;
    }

    public List<Modifier> getProductionModifiers() {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        GoodsType goodsOutputType = this.getGoodsOutputType();
        if (goodsOutputType != null) {
            modifiers.addAll(this.getColony().getFeatureContainer().getModifierSet(goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
            if (this.getOwner() != null) {
                modifiers.addAll(this.getOwner().getFeatureContainer().getModifierSet(goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
            }
            Collections.sort(modifiers);
        }
        return modifiers;
    }

    @Override
    public int compareTo(Building other) {
        return this.getType().compareTo(other.getType());
    }

    public boolean consumes(GoodsType goodsType) {
        return goodsType == this.getGoodsInputType();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        GoodsType inputType = this.getGoodsInputType();
        if (inputType != null) {
            result.add(new AbstractGoods(inputType, 0));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.buildingType.getPriority();
    }

    @Override
    public Set<Modifier> getModifierSet(String id) {
        return this.buildingType.getModifierSet(id);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Building.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("buildingType", this.buildingType.getId());
        super.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.buildingType = this.getSpecification().getBuildingType(in.getAttributeValue(null, "buildingType"));
        super.readChildren(in);
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return this.getType().getId() + " [" + this.getColony().getName() + "]";
    }

    public static String getXMLElementTagName() {
        return "building";
    }
}

