/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoundingFather
extends FreeColGameObjectType {
    private int[] weight = new int[4];
    private FoundingFatherType type;
    private List<Scope> scopes = new ArrayList<Scope>();
    private List<Event> events = new ArrayList<Event>();
    private Map<UnitType, UnitType> upgrades;
    private List<AbstractUnit> units = null;

    public FoundingFather(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.FATHER_PRODUCTION_INDEX);
    }

    public FoundingFatherType getType() {
        return this.type;
    }

    public void setType(FoundingFatherType type) {
        this.type = type;
    }

    public String getTypeKey() {
        return FoundingFather.getTypeKey(this.type);
    }

    public static String getTypeKey(FoundingFatherType type) {
        return "model.foundingFather." + type.toString().toLowerCase(Locale.US);
    }

    public int getWeight(int age) {
        switch (age) {
            case 1: {
                return this.weight[1];
            }
            case 2: {
                return this.weight[2];
            }
        }
        return this.weight[3];
    }

    public final List<AbstractUnit> getUnits() {
        return this.units;
    }

    public final void setUnits(List<AbstractUnit> newUnits) {
        this.units = newUnits;
    }

    public final List<Event> getEvents() {
        return this.events;
    }

    public final void setEvents(List<Event> newEvents) {
        this.events = newEvents;
    }

    public final List<Scope> getScopes() {
        return this.scopes;
    }

    public boolean isAvailableTo(Player player) {
        if (player.isEuropean()) {
            if (this.scopes == null || this.scopes.isEmpty()) {
                return true;
            }
            for (Scope scope : this.scopes) {
                if (!scope.appliesTo(player)) continue;
                return true;
            }
        }
        return false;
    }

    public final Map<UnitType, UnitType> getUpgrades() {
        return this.upgrades;
    }

    public final void setUpgrades(Map<UnitType, UnitType> newUpgrades) {
        this.upgrades = newUpgrades;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, FoundingFather.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("type", this.type.toString().toLowerCase(Locale.US));
        for (int index = 1; index <= 3; ++index) {
            out.writeAttribute("weight" + index, Integer.toString(this.weight[index]));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.events != null) {
            for (Event event : this.events) {
                event.toXMLImpl(out);
            }
        }
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                scope.toXMLImpl(out);
            }
        }
        if (this.units != null) {
            for (AbstractUnit abstractUnit : this.units) {
                out.writeStartElement("unit");
                out.writeAttribute("id", abstractUnit.getId());
                out.writeEndElement();
            }
        }
        if (this.upgrades != null) {
            for (Map.Entry entry : this.upgrades.entrySet()) {
                out.writeStartElement("upgrade");
                out.writeAttribute("from-id", ((UnitType)entry.getKey()).getId());
                out.writeAttribute("to-id", ((UnitType)entry.getValue()).getId());
                out.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String typeString = in.getAttributeValue(null, "type").toUpperCase(Locale.US);
        this.type = Enum.valueOf(FoundingFatherType.class, typeString);
        this.weight[1] = Integer.parseInt(in.getAttributeValue(null, "weight1"));
        this.weight[2] = Integer.parseInt(in.getAttributeValue(null, "weight2"));
        this.weight[3] = Integer.parseInt(in.getAttributeValue(null, "weight3"));
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if (Event.getXMLElementTagName().equals(childName)) {
            Event event = new Event(null, this.getSpecification());
            event.readFromXML(in);
            this.events.add(event);
        } else if ("scope".equals(childName)) {
            this.scopes.add(new Scope(in));
        } else if ("unit".equals(childName)) {
            AbstractUnit unit = new AbstractUnit(in);
            if (this.units == null) {
                this.units = new ArrayList<AbstractUnit>();
            }
            this.units.add(unit);
        } else if ("upgrade".equals(childName)) {
            UnitType fromType = this.getSpecification().getUnitType(in.getAttributeValue(null, "from-id"));
            UnitType toType = this.getSpecification().getUnitType(in.getAttributeValue(null, "to-id"));
            if (fromType != null && toType != null) {
                if (this.upgrades == null) {
                    this.upgrades = new HashMap<UnitType, UnitType>();
                }
                this.upgrades.put(fromType, toType);
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public void fixup09x() {
        try {
            if (!this.getModifierSet("model.modifier.nativeTreasureModifier").isEmpty()) {
                this.addAbility(new Ability("model.ability.plunderNatives"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getXMLElementTagName() {
        return "founding-father";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FoundingFatherType {
        TRADE,
        EXPLORATION,
        MILITARY,
        POLITICAL,
        RELIGIOUS;

    }
}

