/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GoodsLocation
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(GoodsLocation.class.getName());
    private GoodsContainer goodsContainer;

    protected GoodsLocation() {
    }

    public GoodsLocation(Game game) {
        super(game);
    }

    public GoodsLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public GoodsLocation(Game game, String id) {
        super(game, id);
    }

    public abstract int getGoodsCapacity();

    public Iterator<Goods> getGoodsIterator() {
        return this.goodsContainer.getGoodsIterator();
    }

    public List<Goods> getCompactGoods() {
        return this.goodsContainer.getCompactGoods();
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Goods) {
            return UnitLocation.NoAddReason.NONE;
        }
        return super.getNoAddReason(locatable);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Goods) {
            return this.addGoods((Goods)locatable);
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Goods) {
            return this.removeGoods((Goods)locatable) != null;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Goods) {
            return this.goodsContainer.contains((Goods)locatable);
        }
        return super.contains(locatable);
    }

    @Override
    public final GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    public final void setGoodsContainer(GoodsContainer newGoodsContainer) {
        this.goodsContainer = newGoodsContainer;
    }

    public int getWarehouseCapacity() {
        return this.getGoodsCapacity();
    }

    public Goods removeGoods(GoodsType type, int amount) {
        return this.goodsContainer.removeGoods(type, amount);
    }

    public Goods removeGoods(AbstractGoods goods) {
        return this.goodsContainer.removeGoods(goods);
    }

    public Goods removeGoods(GoodsType type) {
        return this.goodsContainer.removeGoods(type);
    }

    public boolean addGoods(GoodsType type, int amount) {
        return this.goodsContainer.addGoods(type, amount);
    }

    public boolean addGoods(AbstractGoods goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    public int getGoodsCount(GoodsType type) {
        return this.goodsContainer.getGoodsCount(type);
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.goodsContainer != null) {
            objects.addAll(this.goodsContainer.disposeList());
            this.goodsContainer = null;
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        super.writeChildren(out, player, showAll, toSavedGame);
        if (this.goodsContainer != null) {
            this.goodsContainer.toXML(out, player, showAll, toSavedGame);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (GoodsContainer.getXMLElementTagName().equals(in.getLocalName())) {
            this.goodsContainer = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
            if (this.goodsContainer == null) {
                this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
            } else {
                this.goodsContainer.readFromXML(in);
            }
        } else {
            super.readChild(in);
        }
    }
}

