/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;

public class MarketData
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(MarketData.class.getName());
    public static final int MINIMUM_PRICE = 1;
    public static final int MAXIMUM_PRICE = 19;
    private GoodsType goodsType;
    private int costToBuy;
    private int paidForSale;
    private int amountInMarket;
    private int initialPrice;
    private int arrears;
    private int sales;
    private int incomeBeforeTaxes;
    private int incomeAfterTaxes;
    private int oldPrice;
    private boolean traded;

    public MarketData(Game game, GoodsType goodsType) {
        super(game);
        this.goodsType = goodsType;
        this.paidForSale = goodsType.getInitialSellPrice();
        this.costToBuy = goodsType.getInitialBuyPrice();
        this.amountInMarket = goodsType.getInitialAmount();
        this.initialPrice = goodsType.getInitialSellPrice();
        this.arrears = 0;
        this.sales = 0;
        this.incomeBeforeTaxes = 0;
        this.incomeAfterTaxes = 0;
        this.oldPrice = this.costToBuy;
        this.traded = false;
    }

    public MarketData(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public MarketData(Game game, String id) {
        super(game, id);
    }

    public void price() {
        if (!this.goodsType.isStorable()) {
            return;
        }
        int diff = this.goodsType.getPriceDifference();
        float amountPrice = (float)this.initialPrice * ((float)this.goodsType.getInitialAmount() / (float)this.amountInMarket);
        int newSalePrice = Math.round(amountPrice);
        int newPrice = newSalePrice + diff;
        if ((this.goodsType.isNewWorldGoodsType() || this.goodsType.getRawMaterial() != null && this.goodsType.getRawMaterial().isNewWorldGoodsType()) && newSalePrice > this.initialPrice + 2) {
            newSalePrice = this.initialPrice + 2;
            newPrice = newSalePrice + diff;
        }
        if (this.costToBuy > 0) {
            if (newPrice > this.costToBuy + diff) {
                this.amountInMarket = Math.round((float)this.goodsType.getInitialAmount() * ((float)this.initialPrice / (amountPrice -= (float)(newPrice - (this.costToBuy + diff)))));
                logger.warning("Clamped price rise for " + this.getId() + " from " + newPrice + " to " + (this.costToBuy + diff));
                newPrice = this.costToBuy + diff;
            } else if (newPrice < this.costToBuy - diff) {
                this.amountInMarket = Math.round((float)this.goodsType.getInitialAmount() * ((float)this.initialPrice / (amountPrice += (float)(this.costToBuy - diff - newPrice))));
                logger.warning("Clamped price fall for " + this.getId() + " from " + newPrice + " to " + (this.costToBuy - diff));
                newPrice = this.costToBuy - diff;
            }
            newSalePrice = newPrice - diff;
        }
        if (newPrice > 19) {
            newPrice = 19;
            newSalePrice = newPrice - diff;
        } else if (newSalePrice < 1) {
            newSalePrice = 1;
            newPrice = newSalePrice + diff;
        }
        this.costToBuy = newPrice;
        this.paidForSale = newSalePrice;
    }

    public final GoodsType getGoodsType() {
        return this.goodsType;
    }

    public final int getCostToBuy() {
        return this.costToBuy;
    }

    public final void setCostToBuy(int newCostToBuy) {
        this.costToBuy = newCostToBuy;
    }

    public final int getPaidForSale() {
        return this.paidForSale;
    }

    public final void setPaidForSale(int newPaidForSale) {
        this.paidForSale = newPaidForSale;
    }

    public final int getAmountInMarket() {
        return this.amountInMarket;
    }

    public final void setAmountInMarket(int newAmountInMarket) {
        this.amountInMarket = newAmountInMarket;
    }

    public final int getInitialPrice() {
        return this.initialPrice;
    }

    public final void setInitialPrice(int newInitialPrice) {
        this.initialPrice = newInitialPrice;
    }

    public final int getArrears() {
        return this.arrears;
    }

    public final void setArrears(int newArrears) {
        this.arrears = newArrears;
    }

    public final int getSales() {
        return this.sales;
    }

    public final void setSales(int newSales) {
        this.sales = newSales;
    }

    public final int getIncomeBeforeTaxes() {
        return this.incomeBeforeTaxes;
    }

    public final void setIncomeBeforeTaxes(int newIncomeBeforeTaxes) {
        this.incomeBeforeTaxes = newIncomeBeforeTaxes;
    }

    public final int getIncomeAfterTaxes() {
        return this.incomeAfterTaxes;
    }

    public final void setIncomeAfterTaxes(int newIncomeAfterTaxes) {
        this.incomeAfterTaxes = newIncomeAfterTaxes;
    }

    public final int getOldPrice() {
        return this.oldPrice;
    }

    public void setOldPrice(int oldPrice) {
        this.oldPrice = oldPrice;
    }

    public final boolean getTraded() {
        return this.traded;
    }

    public void setTraded(boolean traded) {
        this.traded = traded;
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(MarketData.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("goods-type", this.goodsType.getId());
        out.writeAttribute("amount", Integer.toString(this.amountInMarket));
        out.writeAttribute("initialPrice", Integer.toString(this.initialPrice));
        out.writeAttribute("arrears", Integer.toString(this.arrears));
        out.writeAttribute("sales", Integer.toString(this.sales));
        out.writeAttribute("incomeBeforeTaxes", Integer.toString(this.incomeBeforeTaxes));
        out.writeAttribute("incomeAfterTaxes", Integer.toString(this.incomeAfterTaxes));
        out.writeAttribute("traded", Boolean.toString(this.traded));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String goodsTypeStr = in.getAttributeValue(null, "goods-type");
        if (goodsTypeStr == null) {
            goodsTypeStr = in.getAttributeValue(null, "ID");
            this.setDefaultId(this.getGame());
        } else {
            this.setId(in.getAttributeValue(null, "ID"));
        }
        if (goodsTypeStr == null) {
            throw new XMLStreamException("Missing goods-type");
        }
        this.goodsType = this.getSpecification().getGoodsType(goodsTypeStr);
        this.amountInMarket = this.getAttribute(in, "amount", 0);
        this.initialPrice = this.getAttribute(in, "initialPrice", -1);
        this.arrears = this.getAttribute(in, "arrears", 0);
        this.sales = this.getAttribute(in, "sales", 0);
        this.incomeBeforeTaxes = this.getAttribute(in, "incomeBeforeTaxes", 0);
        this.incomeAfterTaxes = this.getAttribute(in, "incomeAfterTaxes", 0);
        this.traded = MarketData.getAttribute(in, "traded", this.sales != 0);
        this.costToBuy = -1;
        this.price();
        this.oldPrice = this.costToBuy;
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "marketData";
    }
}

