/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionMap;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionCache {
    private Colony colony;
    private TypeCountMap<GoodsType> netProduction = new TypeCountMap();
    private Map<Object, ProductionInfo> productionAndConsumption = new HashMap<Object, ProductionInfo>();
    private Set<GoodsType> goodsUsed = new HashSet<GoodsType>();
    private boolean upToDate = false;

    public ProductionCache(Colony colony) {
        this.colony = colony;
    }

    private synchronized void update() {
        if (this.upToDate) {
            return;
        }
        this.productionAndConsumption.clear();
        this.netProduction.clear();
        this.goodsUsed.clear();
        ProductionMap production = new ProductionMap();
        for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
            List<AbstractGoods> p = colonyTile.getProduction();
            if (p.isEmpty()) continue;
            production.add(p);
            ProductionInfo info = new ProductionInfo();
            info.addProduction(p);
            this.productionAndConsumption.put(colonyTile, info);
            for (AbstractGoods goods : p) {
                this.goodsUsed.add(goods.getType());
                this.netProduction.incrementCount(goods.getType().getStoredAs(), goods.getAmount());
            }
        }
        GoodsType bells = this.colony.getSpecification().getGoodsType("model.goods.bells");
        int unitsThatUseNoBells = this.colony.getSpecification().getInteger("model.option.unitsThatUseNoBells");
        int amount = Math.min(unitsThatUseNoBells, this.colony.getUnitCount());
        ProductionInfo bellsInfo = new ProductionInfo();
        bellsInfo.addProduction(new AbstractGoods(bells, amount));
        this.productionAndConsumption.put(this, bellsInfo);
        this.netProduction.incrementCount(bells, amount);
        for (Consumer consumer : this.colony.getConsumers()) {
            Set<Modifier> modifier = consumer.getModifierSet("model.modifier.consumeOnlySurplusProduction");
            ArrayList<AbstractGoods> goods = new ArrayList<AbstractGoods>();
            for (AbstractGoods g : consumer.getConsumedGoods()) {
                this.goodsUsed.add(g.getType());
                AbstractGoods surplus = new AbstractGoods(production.get(g.getType()));
                if (modifier.isEmpty()) {
                    surplus.setAmount(surplus.getAmount() + this.getGoodsCount(g.getType()));
                } else {
                    surplus.setAmount((int)FeatureContainer.applyModifierSet(surplus.getAmount(), null, modifier));
                }
                goods.add(surplus);
            }
            ProductionInfo info = null;
            if (consumer instanceof Building) {
                Building building = (Building)consumer;
                AbstractGoods output = null;
                GoodsType outputType = building.getGoodsOutputType();
                if (outputType != null) {
                    this.goodsUsed.add(outputType);
                    output = new AbstractGoods(production.get(outputType));
                    output.setAmount(output.getAmount() + this.getGoodsCount(outputType));
                }
                info = building.getProductionInfo(output, goods);
            } else if (consumer instanceof Unit) {
                info = ((Unit)consumer).getProductionInfo(goods);
            } else if (consumer instanceof BuildQueue) {
                info = ((BuildQueue)consumer).getProductionInfo(goods);
            }
            if (info == null) continue;
            production.add(info.getProduction());
            production.remove(info.getConsumption());
            for (AbstractGoods g : info.getProduction()) {
                this.netProduction.incrementCount(g.getType().getStoredAs(), g.getAmount());
            }
            for (AbstractGoods g : info.getConsumption()) {
                this.netProduction.incrementCount(g.getType().getStoredAs(), -g.getAmount());
            }
            this.productionAndConsumption.put(consumer, info);
        }
        this.productionAndConsumption = this.productionAndConsumption;
        this.netProduction = this.netProduction;
        this.upToDate = true;
    }

    private int getGoodsCount(GoodsType type) {
        return this.colony.getGoodsCount(type);
    }

    public synchronized void invalidate() {
        this.upToDate = false;
    }

    public synchronized void invalidate(GoodsType goodsType) {
        if (this.goodsUsed.contains(goodsType)) {
            this.upToDate = false;
        }
    }

    public int getNetProductionOf(GoodsType type) {
        this.update();
        return this.netProduction.getCount(type);
    }

    public ProductionInfo getProductionInfo(Object object) {
        this.update();
        return this.productionAndConsumption.get(object);
    }

    public TypeCountMap<GoodsType> getProductionMap() {
        this.update();
        TypeCountMap<GoodsType> result = new TypeCountMap<GoodsType>();
        result.putAll(this.netProduction);
        return result;
    }
}

