/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Settlement
extends GoodsLocation
implements Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Settlement.class.getName());
    public static final int FOOD_PER_COLONIST = 200;
    protected Player owner;
    private String name;
    protected Tile tile;
    private FeatureContainer featureContainer;
    private List<Tile> ownedTiles = new ArrayList<Tile>();
    private SettlementType type;

    protected Settlement() {
    }

    public Settlement(Game game, Player owner, String name, Tile tile) {
        super(game);
        this.owner = owner;
        this.name = name;
        this.tile = tile;
        this.featureContainer = new FeatureContainer();
        this.setType(owner.getNationType().getSettlementType(false));
    }

    public Settlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public Settlement(Game game, String id) {
        super(game, id);
    }

    public final SettlementType getType() {
        return this.type;
    }

    public final void setType(SettlementType newType) {
        if (this.type != null) {
            this.featureContainer.remove(this.type.getFeatureContainer());
        }
        this.type = newType;
        if (newType != null) {
            this.featureContainer.add(newType.getFeatureContainer());
        }
    }

    public Set<Modifier> getModifierSet(String key) {
        return this.featureContainer.getModifierSet(key);
    }

    @Override
    public String getNameKey() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public abstract String getNameFor(Player var1);

    public void setName(String newName) {
        this.name = newName;
    }

    public abstract String getImageKey();

    public boolean isCapital() {
        return this.getType().isCapital();
    }

    public void setCapital(boolean isCapital) {
        if (this.isCapital() != isCapital) {
            this.setType(this.owner.getNationType().getSettlementType(isCapital));
        }
    }

    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    protected void setFeatureContainer(FeatureContainer container) {
        this.featureContainer = container;
    }

    public int getLineOfSight() {
        return (int)this.getFeatureContainer().applyModifier(this.getType().getVisibleRadius(), "model.modifier.lineOfSightBonus");
    }

    public abstract Unit getDefendingUnit(Unit var1);

    public abstract RandomRange getPlunderRange(Unit var1);

    public int getPlunder(Unit attacker, Random random) {
        RandomRange range = this.getPlunderRange(attacker);
        return range == null ? 0 : range.getAmount("Plunder " + this.getName(), random, false);
    }

    @Override
    public Tile getTile() {
        return this.tile;
    }

    @Override
    public Settlement getSettlement() {
        return this;
    }

    public void placeSettlement(boolean maximal) {
        List<Object> tiles;
        if (maximal) {
            tiles = this.getGame().getMap().getClaimableTiles(this.owner, this.tile, this.getRadius());
        } else {
            tiles = new ArrayList<Tile>();
            tiles.add(this.tile);
        }
        this.tile.setSettlement(this);
        for (Tile tile : tiles) {
            tile.changeOwnership(this.owner, this);
        }
        for (Tile tile : this.tile.getSurroundingTiles(this.getLineOfSight())) {
            this.owner.setExplored(tile);
        }
        this.owner.invalidateCanSeeTiles();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player;
    }

    public void changeOwner(Player newOwner) {
        Player oldOwner = this.owner;
        this.setOwner(newOwner);
        if (oldOwner.hasSettlement(this)) {
            oldOwner.removeSettlement(this);
        }
        if (!newOwner.hasSettlement(this)) {
            newOwner.addSettlement(this);
        }
        List<Unit> units = this.getUnitList();
        units.addAll(this.getTile().getUnitList());
        while (!units.isEmpty()) {
            Unit u = units.remove(0);
            units.addAll(u.getUnitList());
            u.setState(Unit.UnitState.ACTIVE);
            UnitType type = u.getTypeChange(newOwner.isUndead() ? UnitTypeChange.ChangeType.UNDEAD : UnitTypeChange.ChangeType.CAPTURE, newOwner);
            if (type != null) {
                u.setType(type);
            }
            u.setOwner(newOwner);
        }
        for (Tile t : this.getOwnedTiles()) {
            t.changeOwnership(newOwner, this);
        }
        oldOwner.invalidateCanSeeTiles();
        newOwner.invalidateCanSeeTiles();
        if (this.getGame().getFreeColGameObjectListener() != null) {
            this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, newOwner);
        }
    }

    public List<Tile> getOwnedTiles() {
        return new ArrayList<Tile>(this.ownedTiles);
    }

    public void addTile(Tile tile) {
        this.ownedTiles.add(tile);
    }

    public void removeTile(Tile tile) {
        this.ownedTiles.remove(tile);
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.owner != null && this.getTile() != null && this.getTile().getSettlement() != null) {
            Tile settlementTile = this.getTile();
            List<Tile> lostTiles = this.getOwnedTiles();
            for (Tile tile : lostTiles) {
                tile.changeOwnership(null, null);
            }
            settlementTile.setSettlement(null);
            Player oldOwner = this.owner;
            this.setOwner(null);
            oldOwner.removeSettlement(this);
            oldOwner.invalidateCanSeeTiles();
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    public int getRadius() {
        return this.getType().getClaimableRadius();
    }

    public boolean isConnected() {
        for (Tile t : this.getTile().getSurroundingTiles(1)) {
            if (!t.isExplored() || !t.getType().isWater() || !t.isConnected()) continue;
            return true;
        }
        return false;
    }

    public abstract int getSoL();

    public abstract boolean propagateAlarm(Player var1, int var2);

    public abstract int getProductionOf(GoodsType var1);

    public int getConsumptionOf(GoodsType goodsType) {
        int result = 0;
        for (Unit unit : this.getUnitList()) {
            result += unit.getType().getConsumptionOf(goodsType);
        }
        return Math.max(0, result);
    }

    public int getConsumptionOf(List<GoodsType> goodsTypes) {
        int result = 0;
        if (goodsTypes != null) {
            for (GoodsType goodsType : goodsTypes) {
                result += this.getConsumptionOf(goodsType);
            }
        }
        return result;
    }

    public int getFoodConsumption() {
        return this.getConsumptionOf(this.getSpecification().getFoodGoodsTypeList());
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            if (this.getGoodsCount(requiredGoods.getType()) >= requiredGoods.getAmount()) continue;
            return false;
        }
        return true;
    }

    public boolean canProvideEquipment(EquipmentType equipmentType) {
        for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
            int available = this.getGoodsCount(goods.getType());
            int breedingNumber = goods.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            if (available >= goods.getAmount()) continue;
            return false;
        }
        return true;
    }

    public boolean canProvideEquipment(List<EquipmentType> equipment) {
        for (EquipmentType e : equipment) {
            if (this.canProvideEquipment(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("name", this.getName());
        out.writeAttribute("owner", this.owner.getId());
        out.writeAttribute("tile", this.tile.getId());
        out.writeAttribute("settlementType", this.getType().getId());
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        SettlementType settlementType;
        super.readAttributes(in);
        this.setName(in.getAttributeValue(null, "name"));
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        this.featureContainer = new FeatureContainer();
        String typeStr = in.getAttributeValue(null, "settlementType");
        if (typeStr == null) {
            String capital = in.getAttributeValue(null, "isCapital");
            settlementType = this.owner.getNationType().getSettlementType("true".equals(capital));
        } else {
            settlementType = this.owner.getNationType().getSettlementType(typeStr);
        }
        this.setType(settlementType);
    }
}

