/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCombatModel
extends CombatModel {
    private static final Logger logger = Logger.getLogger(SimpleCombatModel.class.getName());
    public static final int MAXIMUM_BOMBARD_POWER = 48;
    public static final String SMALL_MOVEMENT_PENALTY = "model.modifier.smallMovementPenalty";
    public static final String BIG_MOVEMENT_PENALTY = "model.modifier.bigMovementPenalty";
    public static final String ARTILLERY_IN_THE_OPEN = "model.modifier.artilleryInTheOpen";
    public static final String ATTACK_BONUS = "model.modifier.attackBonus";
    public static final String FORTIFIED = "model.modifier.fortified";
    public static final String ARTILLERY_AGAINST_RAID = "model.modifier.artilleryAgainstRaid";
    public static final String AMPHIBIOUS_ATTACK = "model.modifier.amphibiousAttack";
    public static final String BOMBARD_BONUS = "model.modifier.bombardBonus";
    public static final Modifier UNKNOWN_DEFENCE_MODIFIER = new Modifier("bogus", Float.MIN_VALUE, Modifier.Type.ADDITIVE);

    @Override
    public CombatModel.CombatOdds calculateCombatOdds(FreeColGameObject attacker, FreeColGameObject defender) {
        if (attacker == null || defender == null) {
            return new CombatModel.CombatOdds(-1.0f);
        }
        float attackPower = this.getOffencePower(attacker, defender);
        float defencePower = this.getDefencePower(attacker, defender);
        if (attackPower == 0.0f && defencePower == 0.0f) {
            return new CombatModel.CombatOdds(-1.0f);
        }
        float victory = attackPower / (attackPower + defencePower);
        return new CombatModel.CombatOdds(victory);
    }

    @Override
    public float getOffencePower(FreeColGameObject attacker, FreeColGameObject defender) {
        float result = 0.0f;
        if (attacker == null) {
            throw new IllegalStateException("Null attacker");
        }
        if (this.combatIsAttackMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender)) {
            result = FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), this.getOffensiveModifiers(attacker, defender));
        } else if (this.combatIsBombard(attacker, defender)) {
            Settlement attackerSettlement = (Settlement)attacker;
            if (attackerSettlement.hasAbility("model.ability.bombardShips")) {
                for (Unit unit : attackerSettlement.getTile().getUnitList()) {
                    if (!unit.hasAbility("model.ability.bombard")) continue;
                    result += (float)unit.getType().getOffence();
                }
            }
            if (result > 48.0f) {
                result = 48.0f;
            }
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    @Override
    public float getDefencePower(FreeColGameObject attacker, FreeColGameObject defender) {
        float result;
        if (this.combatIsDefenceMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender)) {
            result = FeatureContainer.applyModifierSet(0.0f, defender.getGame().getTurn(), this.getDefensiveModifiers(attacker, defender));
        } else if (this.combatIsBombard(attacker, defender)) {
            result = ((Unit)defender).getType().getDefence();
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    @Override
    public Set<Modifier> getOffensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender) {
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        if (attacker == null) {
            throw new IllegalStateException("Null attacker");
        }
        if (this.combatIsAttackMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender)) {
            Unit attackerUnit = (Unit)attacker;
            UnitType type = attackerUnit.getType();
            result.add(new Modifier("model.modifier.offence", Specification.BASE_OFFENCE_SOURCE, type.getOffence(), Modifier.Type.ADDITIVE));
            result.addAll(attackerUnit.getModifierSet("model.modifier.offence"));
            if (defender instanceof Ownable) {
                result.addAll(attackerUnit.getModifierSet("model.modifier.offenceAgainst", (Ownable)((Object)defender)));
            }
            if (attackerUnit.isNaval()) {
                this.addNavalOffensiveModifiers(attackerUnit, result);
            } else {
                this.addLandOffensiveModifiers(attacker, defender, result);
            }
        } else if (this.combatIsBombard(attacker, defender)) {
            result.add(new Modifier("model.modifier.bombardModifier", this.getOffencePower(attacker, defender), Modifier.Type.ADDITIVE));
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    private void addNavalOffensiveModifiers(Unit attacker, Set<Modifier> result) {
        int goodsCount = attacker.getGoodsCount();
        if (goodsCount > 0) {
            result.add(new Modifier("model.modifier.offence", Specification.CARGO_PENALTY_SOURCE, -12.5f * (float)goodsCount, Modifier.Type.PERCENTAGE));
        }
    }

    private void addLandOffensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender, Set<Modifier> result) {
        Unit attackerUnit = (Unit)attacker;
        Specification spec = attackerUnit.getSpecification();
        TypeCountMap<EquipmentType> equip = attackerUnit.getEquipment();
        if (equip != null) {
            for (EquipmentType et : equip.keySet()) {
                result.addAll(et.getModifierSet("model.modifier.offence"));
            }
        }
        result.addAll(spec.getModifiers(ATTACK_BONUS));
        int movesLeft = attackerUnit.getMovesLeft();
        if (movesLeft == 1) {
            result.addAll(spec.getModifiers(BIG_MOVEMENT_PENALTY));
        } else if (movesLeft == 2) {
            result.addAll(spec.getModifiers(SMALL_MOVEMENT_PENALTY));
        }
        if (this.combatIsAmphibious(attacker, defender)) {
            result.addAll(spec.getModifiers(AMPHIBIOUS_ATTACK));
        }
        if (!this.combatIsAttackMeasurement(attacker, defender)) {
            if (this.combatIsSettlementAttack(attacker, defender)) {
                result.addAll(attackerUnit.getModifierSet(BOMBARD_BONUS));
            } else if (this.combatIsAttack(attacker, defender)) {
                Unit defenderUnit = (Unit)defender;
                Tile tile = defenderUnit.getTile();
                if (tile != null) {
                    if (tile.getSettlement() != null) {
                        result.addAll(attackerUnit.getModifierSet(BOMBARD_BONUS));
                    } else {
                        if (this.isAmbush(attacker, defender)) {
                            for (Modifier mod : tile.getType().getModifierSet("model.modifier.defence")) {
                                Modifier modifier = new Modifier(mod);
                                modifier.setId("model.modifier.offence");
                                modifier.setSource(Specification.AMBUSH_BONUS_SOURCE);
                                result.add(modifier);
                            }
                        }
                        if (attackerUnit.hasAbility("model.ability.bombard") && attackerUnit.getLocation() instanceof Tile && attackerUnit.getSettlement() == null) {
                            result.addAll(spec.getModifiers(ARTILLERY_IN_THE_OPEN));
                        }
                    }
                }
            } else {
                throw new IllegalStateException("Bogus combat");
            }
        }
    }

    @Override
    public Set<Modifier> getDefensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender) {
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        if (this.combatIsDefenceMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            result.add(new Modifier("model.modifier.defence", Specification.BASE_DEFENCE_SOURCE, defenderUnit.getType().getDefence(), Modifier.Type.ADDITIVE));
            result.addAll(defenderUnit.getType().getModifierSet("model.modifier.defence"));
            if (defenderUnit.isNaval()) {
                this.addNavalDefensiveModifiers(defender, result);
            } else {
                this.addLandDefensiveModifiers(attacker, defender, result);
            }
        } else if (this.combatIsSettlementAttack(attacker, defender)) {
            result.add(UNKNOWN_DEFENCE_MODIFIER);
        } else if (this.combatIsBombard(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            result.add(new Modifier("model.modifier.defenceBonus", defenderUnit.getType().getDefence(), Modifier.Type.ADDITIVE));
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    private void addNavalDefensiveModifiers(FreeColGameObject defender, Set<Modifier> result) {
        Unit defenderUnit = (Unit)defender;
        int goodsCount = defenderUnit.getVisibleGoodsCount();
        if (goodsCount > 0) {
            result.add(new Modifier("model.modifier.defence", Specification.CARGO_PENALTY_SOURCE, -12.5f * (float)goodsCount, Modifier.Type.PERCENTAGE));
        }
    }

    private void addLandDefensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender, Set<Modifier> result) {
        Tile tile;
        Unit defenderUnit = (Unit)defender;
        Specification spec = defender.getSpecification();
        TypeCountMap<EquipmentType> equip = defenderUnit.getEquipment();
        if (equip != null) {
            for (EquipmentType et : equip.keySet()) {
                result.addAll(et.getModifierSet("model.modifier.defence"));
            }
        }
        if ((equip = defenderUnit.getAutomaticEquipment()) != null) {
            for (EquipmentType et : equip.keySet()) {
                result.addAll(et.getModifierSet("model.modifier.defence"));
            }
        }
        if (defenderUnit.getState() == Unit.UnitState.FORTIFIED) {
            result.addAll(spec.getModifiers(FORTIFIED));
        }
        if ((tile = defenderUnit.getTile()) != null) {
            if (tile.getSettlement() == null) {
                if (!this.isAmbush(attacker, defender)) {
                    result.addAll(tile.getType().getDefenceBonus());
                }
                if (defenderUnit.hasAbility("model.ability.bombard") && defenderUnit.getState() != Unit.UnitState.FORTIFIED) {
                    result.addAll(spec.getModifiers(ARTILLERY_IN_THE_OPEN));
                }
            } else {
                result.addAll(tile.getSettlement().getModifierSet("model.modifier.defence"));
                if (defenderUnit.hasAbility("model.ability.bombard") && attacker != null && ((Unit)attacker).getOwner().isIndian()) {
                    result.addAll(spec.getModifiers(ARTILLERY_AGAINST_RAID));
                }
            }
        }
    }

    @Override
    public List<CombatModel.CombatResult> generateAttackResult(Random random, FreeColGameObject attacker, FreeColGameObject defender) {
        String action;
        ArrayList<CombatModel.CombatResult> crs = new ArrayList<CombatModel.CombatResult>();
        CombatModel.CombatOdds odds = this.calculateCombatOdds(attacker, defender);
        float r = random.nextFloat();
        boolean great = false;
        if (this.combatIsAttack(attacker, defender)) {
            Unit attackerUnit = (Unit)attacker;
            Unit defenderUnit = (Unit)defender;
            action = "Attack";
            if (r < odds.win || this.isBeached(defenderUnit)) {
                great = r < 0.1f * odds.win;
                crs.add(CombatModel.CombatResult.WIN);
                this.resolveAttack(attackerUnit, defenderUnit, great, r / (0.1f * odds.win), crs);
            } else if (r < 0.8f * odds.win + 0.2f && defenderUnit.hasAbility("model.ability.evadeAttack")) {
                crs.add(CombatModel.CombatResult.NO_RESULT);
                crs.add(CombatModel.CombatResult.EVADE_ATTACK);
            } else {
                great = r >= 0.1f * odds.win + 0.9f;
                crs.add(CombatModel.CombatResult.LOSE);
                this.resolveAttack(defenderUnit, attackerUnit, great, (1.25f * r - 0.25f - odds.win) / (1.0f - odds.win), crs);
            }
        } else if (this.combatIsBombard(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            if (!defenderUnit.isNaval()) {
                throw new IllegalStateException("Bombard of non-naval");
            }
            action = "Bombard";
            if (r <= odds.win) {
                crs.add(CombatModel.CombatResult.WIN);
                float offencePower = this.getOffencePower(attacker, defender);
                float defencePower = this.getDefencePower(attacker, defender);
                float diff = Math.max(3.0f, defencePower * 2.0f - offencePower);
                boolean bl = great = r < odds.win / diff;
                if (great || defenderUnit.getRepairLocation() == null) {
                    crs.add(CombatModel.CombatResult.SINK_SHIP_BOMBARD);
                } else {
                    crs.add(CombatModel.CombatResult.DAMAGE_SHIP_BOMBARD);
                }
            } else {
                crs.add(CombatModel.CombatResult.NO_RESULT);
                crs.add(CombatModel.CombatResult.EVADE_BOMBARD);
            }
        } else {
            throw new IllegalStateException("Bogus combat");
        }
        ArrayList<String> results = new ArrayList<String>();
        for (CombatModel.CombatResult cr : crs) {
            results.add(cr.toString());
        }
        logger.info(attacker.toString() + " " + action + " " + defender.toString() + ": victory=" + Float.toString(odds.win) + " random(1.0)=" + Float.toString(r) + " great=" + Boolean.toString(great) + " => " + Utils.join(" ", results));
        return crs;
    }

    private void resolveAttack(Unit winner, Unit loser, boolean great, float r, List<CombatModel.CombatResult> crs) {
        Player winnerPlayer;
        block23: {
            EquipmentType equip;
            EquipmentType autoEquip;
            Settlement settlement;
            Player loserPlayer;
            block25: {
                int lose;
                Tile tile;
                block26: {
                    block27: {
                        boolean attackerWon;
                        block24: {
                            CombatModel.CombatResult colonyResult;
                            boolean loserWasUnarmed;
                            block22: {
                                loserPlayer = loser.getOwner();
                                tile = loser.getTile();
                                winnerPlayer = winner.getOwner();
                                boolean bl = attackerWon = crs.get(0) == CombatModel.CombatResult.WIN;
                                if (!loser.isNaval()) break block22;
                                if (winner.isNaval() && winner.canCaptureGoods() && !loser.getGoodsList().isEmpty()) {
                                    crs.add(CombatModel.CombatResult.LOOT_SHIP);
                                }
                                if (great || loser.getRepairLocation() == null || this.isBeached(loser)) {
                                    crs.add(CombatModel.CombatResult.SINK_SHIP_ATTACK);
                                } else {
                                    crs.add(CombatModel.CombatResult.DAMAGE_SHIP_ATTACK);
                                }
                                break block23;
                            }
                            settlement = tile.getSettlement();
                            autoEquip = null;
                            equip = null;
                            boolean bl = loserWasUnarmed = !loser.isDefensiveUnit();
                            if (settlement instanceof Colony && (autoEquip = loser.getBestCombatEquipmentType(loser.getAutomaticEquipment())) != null) {
                                crs.add(CombatModel.CombatResult.AUTOEQUIP_UNIT);
                                loserWasUnarmed = false;
                            }
                            if (!(settlement instanceof Colony) || !loserWasUnarmed) break block24;
                            Colony colony = (Colony)settlement;
                            CombatModel.CombatResult combatResult = winnerPlayer.isEuropean() ? CombatModel.CombatResult.CAPTURE_COLONY : (!great && colony.canBePillaged(winner) ? CombatModel.CombatResult.PILLAGE_COLONY : (colonyResult = colony.getUnitCount() > 1 || loser.getLocation() == tile ? CombatModel.CombatResult.SLAUGHTER_UNIT : CombatModel.CombatResult.DESTROY_COLONY));
                            if (colonyResult == CombatModel.CombatResult.DESTROY_COLONY) {
                                crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                            }
                            if (colonyResult == CombatModel.CombatResult.CAPTURE_COLONY || colonyResult == CombatModel.CombatResult.DESTROY_COLONY) {
                                CombatModel.CombatResult shipResult = null;
                                CombatModel.CombatResult combatResult2 = colony.getShipList().isEmpty() ? null : (shipResult = colony.getShipList().get(0).getRepairLocation() == null ? CombatModel.CombatResult.SINK_COLONY_SHIPS : CombatModel.CombatResult.DAMAGE_COLONY_SHIPS);
                                if (shipResult != null) {
                                    crs.add(shipResult);
                                }
                            }
                            crs.add(colonyResult);
                            break block23;
                        }
                        if (!(settlement instanceof IndianSettlement)) break block25;
                        IndianSettlement is = (IndianSettlement)settlement;
                        lose = 1;
                        if (!attackerWon) break block26;
                        if (!(r < winner.getConvertProbability())) break block27;
                        if (is.getUnitCount() + tile.getUnitCount() <= 1 || is.getMissionary(winnerPlayer) == null || winner.getTile() == null || !winner.getTile().isLand()) break block26;
                        crs.add(CombatModel.CombatResult.CAPTURE_CONVERT);
                        ++lose;
                        break block26;
                    }
                    if (r >= 1.0f - winner.getBurnProbability()) {
                        for (IndianSettlement s : loserPlayer.getIndianSettlements()) {
                            if (s.getMissionary(winnerPlayer) == null) continue;
                            crs.add(CombatModel.CombatResult.BURN_MISSIONS);
                            break;
                        }
                    }
                }
                crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                if (settlement.getUnitCount() + tile.getUnitCount() <= lose) {
                    crs.add(CombatModel.CombatResult.DESTROY_SETTLEMENT);
                }
                break block23;
            }
            if (loser.hasAbility("model.ability.disposeOnCombatLoss")) {
                crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
            } else {
                equip = loser.getBestCombatEquipmentType(loser.getEquipment());
                if (equip != null) {
                    crs.add(loser.losingEquipmentKillsUnit(equip) ? CombatModel.CombatResult.SLAUGHTER_UNIT : (winner.canCaptureEquipment(equip, loser) != null ? CombatModel.CombatResult.CAPTURE_EQUIP : CombatModel.CombatResult.LOSE_EQUIP));
                    if (loser.losingEquipmentDemotesUnit(equip)) {
                        crs.add(CombatModel.CombatResult.DEMOTE_UNIT);
                    }
                } else if (settlement instanceof Colony && autoEquip != null) {
                    crs.add(loser.losingEquipmentKillsUnit(autoEquip) ? CombatModel.CombatResult.SLAUGHTER_UNIT : (winner.canCaptureEquipment(autoEquip, loser) != null ? CombatModel.CombatResult.CAPTURE_AUTOEQUIP : CombatModel.CombatResult.LOSE_AUTOEQUIP));
                } else if (loser.getTypeChange(UnitTypeChange.ChangeType.DEMOTION, loserPlayer) != null) {
                    crs.add(CombatModel.CombatResult.DEMOTE_UNIT);
                } else if (loser.hasAbility("model.ability.canBeCaptured") && winner.hasAbility("model.ability.captureUnits") && !this.combatIsAmphibious(winner, loser)) {
                    crs.add(CombatModel.CombatResult.CAPTURE_UNIT);
                } else {
                    crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                }
            }
        }
        UnitTypeChange promotion = winner.getType().getUnitTypeChange(UnitTypeChange.ChangeType.PROMOTION, winnerPlayer);
        if (promotion != null && (winner.hasAbility("model.ability.automaticPromotion") || great && 100.0 * ((double)r - Math.floor(r)) <= (double)promotion.getProbability(UnitTypeChange.ChangeType.PROMOTION))) {
            crs.add(CombatModel.CombatResult.PROMOTE_UNIT);
        }
    }

    private boolean isAmbush(FreeColGameObject attacker, FreeColGameObject defender) {
        return attacker.hasAbility("model.ability.ambushBonus") || defender.hasAbility("model.ability.ambushPenalty");
    }

    private boolean isBeached(Unit unit) {
        return unit.isNaval() && unit.getTile().isLand() && unit.getSettlement() == null;
    }
}

