/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileType;

public class TileTypeChange {
    private TileType from;
    private TileType to;
    private AbstractGoods production;

    public final TileType getFrom() {
        return this.from;
    }

    public final void setFrom(TileType newFrom) {
        this.from = newFrom;
    }

    public final TileType getTo() {
        return this.to;
    }

    public final void setTo(TileType newTo) {
        this.to = newTo;
    }

    public final AbstractGoods getProduction() {
        return this.production;
    }

    public final void setProduction(AbstractGoods newProduction) {
        this.production = newProduction;
    }

    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(TileTypeChange.getXMLElementTagName());
        out.writeAttribute("from", this.from.getId());
        out.writeAttribute("to", this.to.getId());
        if (this.production != null) {
            out.writeStartElement("production");
            out.writeAttribute("goods-type", this.production.getType().getId());
            out.writeAttribute("value", Integer.toString(this.production.getAmount()));
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    protected void readFromXML(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.from = specification.getTileType(in.getAttributeValue(null, "from"));
        this.to = specification.getTileType(in.getAttributeValue(null, "to"));
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if (!"production".equals(childName)) continue;
            GoodsType type = specification.getGoodsType(in.getAttributeValue(null, "goods-type"));
            int amount = Integer.parseInt(in.getAttributeValue(null, "value"));
            this.production = new AbstractGoods(type, amount);
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "change";
    }
}

