/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitLocation
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(UnitLocation.class.getName());
    private final List<Unit> units = new ArrayList<Unit>();

    protected UnitLocation() {
    }

    public UnitLocation(Game game) {
        super(game);
    }

    public UnitLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public UnitLocation(Game game, String id) {
        super(game, id);
    }

    public int getUnitCapacity() {
        return Integer.MAX_VALUE;
    }

    public int getSpaceTaken() {
        int space = 0;
        for (Unit u : this.units) {
            space += u.getSpaceTaken();
        }
        return space;
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.key(this.getId());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return this.getNoAddReason(locatable) == NoAddReason.NONE;
    }

    public NoAddReason getNoAddReason(Locatable locatable) {
        Unit unit;
        Unit unit2 = unit = locatable instanceof Unit ? (Unit)locatable : null;
        return unit == null ? NoAddReason.WRONG_TYPE : (this.units == null || unit.getSpaceTaken() + this.getSpaceTaken() > this.getUnitCapacity() ? NoAddReason.CAPACITY_EXCEEDED : (!this.isEmpty() && this.units.get(0).getOwner() != unit.getOwner() ? NoAddReason.OCCUPIED_BY_ENEMY : (this.contains(unit) ? NoAddReason.ALREADY_PRESENT : NoAddReason.NONE)));
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (this.contains(unit)) {
                return true;
            }
            if (this.canAdd(unit)) {
                return this.units.add(unit);
            }
        } else {
            if (locatable instanceof Goods) {
                locatable.setLocation(null);
                logger.finest("Dumped " + locatable + " in UnitLocation with ID " + this.getId());
                return true;
            }
            logger.warning("Tried to add Locatable " + locatable + " to UnitLocation with ID " + this.getId() + ".");
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.remove((Unit)locatable);
        }
        logger.warning("Tried to remove Locatable " + locatable + " from UnitLocation with ID " + this.getId() + ".");
        return false;
    }

    @Override
    public boolean contains(Locatable locatable) {
        return this.units != null && this.units.contains(locatable);
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    public boolean isEmpty() {
        return this.units.isEmpty();
    }

    public boolean isFull() {
        return this.getUnitCount() >= this.getUnitCapacity();
    }

    @Override
    public List<Unit> getUnitList() {
        return new ArrayList<Unit>(this.units);
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (!this.units.isEmpty()) {
            objects.addAll(this.units.remove(0).disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("ID", this.getId());
    }

    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        for (Unit unit : this.units) {
            unit.toXML(out, player, showAll, toSavedGame);
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.units.clear();
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (Unit.getXMLElementTagName().equals(in.getLocalName())) {
            Unit unit = this.updateFreeColGameObject(in, Unit.class);
            if (!this.units.contains(unit)) {
                this.units.add(unit);
            }
        } else {
            logger.warning("Found unknown child element '" + in.getLocalName() + "' of UnitLocation " + this.getId() + ".");
            in.nextTag();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoAddReason {
        NONE,
        ALREADY_PRESENT,
        WRONG_TYPE,
        CAPACITY_EXCEEDED,
        OCCUPIED_BY_ENEMY,
        OWNED_BY_ENEMY,
        ANOTHER_COLONY,
        COLONY_CENTER,
        MISSING_ABILITY,
        MISSING_SKILL,
        CLAIM_REQUIRED;

    }
}

