/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.FreeCol;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMMessage {
    protected static final Logger logger = Logger.getLogger(DOMMessage.class.getName());
    private static final String FREECOL_PROTOCOL_VERSION = "0.1.6";
    private static final String INVALID_MESSAGE = "invalid";
    protected Document document;

    protected DOMMessage() {
    }

    public DOMMessage(String msg) throws SAXException, IOException {
        this(new InputSource(new StringReader(msg)));
    }

    public DOMMessage(InputStream inputStream) throws SAXException, IOException {
        this(new InputSource(inputStream));
    }

    private DOMMessage(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document tempDocument = null;
        boolean dumpMsgOnError = true;
        if (dumpMsgOnError) {
            inputSource.setByteStream(new BufferedInputStream(inputSource.getByteStream()));
            inputSource.getByteStream().mark(1000000);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            tempDocument = builder.parse(inputSource);
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, "Parser error", pce);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dumpMsgOnError) {
                int i;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                inputSource.getByteStream().reset();
                while (-1 != (i = inputSource.getByteStream().read())) {
                    baos.write(i);
                }
                logger.severe(baos.toString());
            }
            throw e;
        }
        this.document = tempDocument;
    }

    public DOMMessage(Document document) {
        this.document = document;
    }

    public static String getFreeColProtocolVersion() {
        return FREECOL_PROTOCOL_VERSION;
    }

    public static Document createNewDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
    }

    public static Element createNewRootElement(String tagName) {
        return DOMMessage.createNewDocument().createElement(tagName);
    }

    public static Element collapseElements(List<Element> elements) {
        switch (elements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return elements.get(0);
            }
        }
        Element first = elements.remove(0);
        Document doc = first.getOwnerDocument();
        Element result = doc.createElement("multiple");
        result.appendChild(first);
        for (Element e : elements) {
            result.appendChild(doc.importNode(e, true));
        }
        return result;
    }

    public static Element createError(String messageID, String message) {
        Element errorElement = DOMMessage.createNewRootElement("error");
        if (messageID != null && !messageID.equals("")) {
            errorElement.setAttribute("messageID", messageID);
        }
        if (message != null && !message.equals("")) {
            errorElement.setAttribute("message", message);
        }
        return errorElement;
    }

    public static void createError(XMLStreamWriter out, String messageID, String message) {
        try {
            out.writeStartElement("error");
            if (messageID != null && !messageID.equals("")) {
                out.writeAttribute("messageID", messageID);
            }
            if (message != null && !message.equals("")) {
                out.writeAttribute("message", message);
            }
            out.writeEndElement();
        }
        catch (XMLStreamException e) {
            logger.warning("Could not send error message.");
        }
    }

    public static Element clientError(String message) {
        logger.warning(message);
        if (FreeCol.isInDebugMode()) {
            Thread.dumpStack();
        }
        Element errorElement = DOMMessage.createNewRootElement("error");
        errorElement.setAttribute("messageID", "server.reject");
        errorElement.setAttribute("message", message);
        return errorElement;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getType() {
        if (this.document != null && this.document.getDocumentElement() != null) {
            return this.document.getDocumentElement().getTagName();
        }
        return INVALID_MESSAGE;
    }

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    public void setAttribute(String key, String value) {
        this.document.getDocumentElement().setAttribute(key, value);
    }

    public void setAttribute(String key, int value) {
        this.document.getDocumentElement().setAttribute(key, new Integer(value).toString());
    }

    public String getAttribute(String key) {
        return this.document.getDocumentElement().getAttribute(key);
    }

    public boolean hasAttribute(String attribute) {
        return this.document.getDocumentElement().hasAttribute(attribute);
    }

    public void insertAsRoot(Element newRoot) {
        Element oldRoot = this.document.getDocumentElement();
        if (oldRoot != null) {
            this.document.removeChild(oldRoot);
            newRoot.appendChild(oldRoot);
        }
        this.document.appendChild(newRoot);
    }

    public static Element getChildElement(Element element, String tagName) {
        NodeList n = element.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            if (!(n.item(i) instanceof Element) || !((Element)n.item(i)).getTagName().equals(tagName)) continue;
            return (Element)n.item(i);
        }
        return null;
    }

    public static String elementToString(Element element) {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer xt = factory.newTransformer();
            StringWriter sw = new StringWriter();
            xt.transform(new DOMSource(element), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "TransformerException", e);
            return null;
        }
    }

    public Element toXMLElement() {
        return null;
    }

    public String toString() {
        return this.document.getDocumentElement().toString();
    }
}

