/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetNationSummaryMessage
extends DOMMessage {
    private String playerId;
    private NationSummary summary;

    public GetNationSummaryMessage(Player player) {
        this.playerId = player.getId();
        this.summary = null;
    }

    public GetNationSummaryMessage(Element element) {
        this.playerId = element.getAttribute("player");
        NodeList nodes = element.getChildNodes();
        this.summary = nodes == null || nodes.getLength() != 1 ? null : new NationSummary((Element)nodes.item(0));
    }

    public NationSummary getNationSummary() {
        return this.summary;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = serverPlayer.getGame();
        FreeColGameObject fcgo = game.getFreeColGameObjectSafely(this.playerId);
        if (!(fcgo instanceof Player)) {
            return DOMMessage.clientError("Not a player: " + this.playerId);
        }
        Player player = (Player)fcgo;
        if (player.isIndian() && !serverPlayer.hasContacted(player)) {
            return DOMMessage.clientError("Not contacted: " + this.playerId);
        }
        this.summary = server.getInGameController().getNationSummary(serverPlayer, player);
        return this.toXMLElement();
    }

    public Element toXMLElement() {
        Element result = GetNationSummaryMessage.createNewRootElement(GetNationSummaryMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("player", this.playerId);
        if (this.summary != null) {
            result.appendChild(this.summary.toXMLElement(null, doc));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "getNationSummary";
    }
}

