/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class IndianDemandMessage
extends DOMMessage {
    private String unitId;
    private String colonyId;
    private Goods goods;
    private String goldString;
    private String resultString;

    public IndianDemandMessage(Unit unit, Colony colony, Goods goods, int gold) {
        this.unitId = unit.getId();
        this.colonyId = colony.getId();
        this.goods = goods;
        this.goldString = gold == 0 ? null : Integer.toString(gold);
        this.resultString = null;
    }

    public IndianDemandMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.colonyId = element.getAttribute("colony");
        this.goldString = !element.hasAttribute("gold") ? null : element.getAttribute("gold");
        this.resultString = element.getAttribute("result");
        this.goods = !element.hasChildNodes() ? null : new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
    }

    public Unit getUnit(Game game) {
        return (Unit)game.getFreeColGameObjectSafely(this.unitId);
    }

    public Colony getColony(Game game) {
        return (Colony)game.getFreeColGameObjectSafely(this.colonyId);
    }

    public Goods getGoods() {
        return this.goods;
    }

    public int getGold() {
        return this.goldString == null ? 0 : Integer.parseInt(this.goldString);
    }

    public boolean getResult() {
        return Boolean.valueOf(this.resultString);
    }

    public void setResult(boolean result) {
        this.resultString = Boolean.toString(result);
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = player.getGame();
        if (this.resultString == null) {
            try {
                unit = server.getUnitSafely(this.unitId, serverPlayer);
            }
            catch (Exception e) {
                return DOMMessage.clientError(e.getMessage());
            }
            if (unit.getMovesLeft() <= 0) {
                return DOMMessage.clientError("Unit has no moves left: " + this.unitId);
            }
        } else if (game.getFreeColGameObject(this.unitId) instanceof Unit) {
            unit = (Unit)game.getFreeColGameObject(this.unitId);
        } else {
            return DOMMessage.clientError("Not a unit: " + this.unitId);
        }
        try {
            Settlement settlement = server.getAdjacentSettlementSafely(this.colonyId, unit);
            if (!(settlement instanceof Colony)) {
                return DOMMessage.clientError("Not a colony: " + this.colonyId);
            }
            colony = (Colony)settlement;
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        int gold = 0;
        if (this.goods != null) {
            if (this.goods.getLocation() != colony) {
                return DOMMessage.clientError("Goods are not in colony: " + this.colonyId);
            }
        } else if (this.goldString != null) {
            try {
                gold = Integer.parseInt(this.goldString);
            }
            catch (NumberFormatException e) {
                return DOMMessage.clientError(e.getMessage());
            }
            if (gold <= 0) {
                return DOMMessage.clientError("Bad gold: " + this.goldString);
            }
        } else {
            return DOMMessage.clientError("Goods+gold can not both be empty");
        }
        return server.getInGameController().indianDemand(serverPlayer, unit, colony, this.goods, gold);
    }

    public Element toXMLElement() {
        Element ret = IndianDemandMessage.createNewRootElement(IndianDemandMessage.getXMLElementTagName());
        ret.setAttribute("unit", this.unitId);
        ret.setAttribute("colony", this.colonyId);
        if (this.goldString != null) {
            ret.setAttribute("gold", this.goldString);
        }
        if (this.resultString != null) {
            ret.setAttribute("result", this.resultString);
        }
        if (this.goods != null) {
            ret.appendChild(this.goods.toXMLElement(null, ret.getOwnerDocument()));
        }
        return ret;
    }

    public static String getXMLElementTagName() {
        return "indianDemand";
    }
}

