/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModOption
extends AbstractOption<FreeColModFile> {
    private static Logger logger = Logger.getLogger(ModOption.class.getName());
    private FreeColModFile value;
    private List<FreeColModFile> choices = new ArrayList<FreeColModFile>(Mods.getAllMods());

    public ModOption(String id) {
        super(id);
    }

    public ModOption(Specification specification) {
        super(specification);
    }

    public ModOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public ModOption clone() {
        ModOption result = new ModOption(this.getId());
        result.setValues(this);
        result.choices = new ArrayList<FreeColModFile>(this.choices);
        return result;
    }

    @Override
    public FreeColModFile getValue() {
        return this.value;
    }

    @Override
    public void setValue(FreeColModFile value) {
        FreeColModFile oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        String id = valueString != null ? valueString : defaultValueString;
        this.setValue(Mods.getModFile(id));
    }

    public final List<FreeColModFile> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<FreeColModFile> newChoices) {
        this.choices = newChoices;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, ModOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.value != null) {
            out.writeAttribute("value", this.value.getId());
        }
    }

    public static String getXMLElementTagName() {
        return "modOption";
    }

    @Override
    public String toString() {
        String result = "";
        if (this.choices != null) {
            for (FreeColModFile choice : this.choices) {
                result = result + ", " + choice.getId();
            }
            if (result.length() > 0) {
                result = result.substring(2);
            }
        }
        return ModOption.getXMLElementTagName() + " [value=" + this.value + ", choices=[" + result + "]]";
    }
}

