/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.server.ai.AIMain;

public abstract class AIObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColObject.class.getName());
    private final AIMain aiMain;
    protected boolean uninitialized = false;

    public AIObject(AIMain aiMain) {
        this.aiMain = aiMain;
    }

    public AIObject(AIMain aiMain, String id) {
        this.aiMain = aiMain;
        this.setId(id);
        aiMain.addAIObject(id, this);
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public Game getGame() {
        return this.aiMain.getGame();
    }

    public Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public void dispose() {
        this.getAIMain().removeAIObject(this.getId());
    }

    public final void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readFromXML(in);
        this.uninitialized = false;
    }

    public static String getXMLElementTagName() {
        return "AIObject";
    }
}

