/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(NativeAIPlayer.class.getName());
    private static final String SHIP_TRADE_PENALTY = "model.modifier.shipTradePenalty";
    private static final String MISSIONARY_TRADE_BONUS = "model.modifier.missionaryTradeBonus";
    private HashMap<String, Integer> sessionRegister = new HashMap();

    public NativeAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.setPlayer(player);
    }

    public NativeAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public NativeAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        logger.finest("Entering method startWorking: " + player + ", year " + this.getGame().getTurn());
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.determineStances();
        this.abortInvalidAndOneTimeMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.doMissions();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.abortInvalidMissions();
        this.clearAIUnits();
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        boolean validOffer = true;
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                switch (stance) {
                    case UNCONTACTED: {
                        validOffer = false;
                        break;
                    }
                    case WAR: {
                        break;
                    }
                    case CEASE_FIRE: {
                        value -= 500;
                        break;
                    }
                    case PEACE: {
                        if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace")) break;
                        value -= 1000;
                        break;
                    }
                    case ALLIANCE: {
                        value -= 2000;
                    }
                }
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        if (validOffer) {
            logger.info("Trade value is " + value + ", accept if >=0");
        } else {
            logger.info("Trade offer is considered invalid!");
        }
        return value >= 0 && validOffer;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    private Set<Modifier> getMissionaryTradeBonuses(Unit missionary, boolean sense) {
        Set<Modifier> result;
        Set<Modifier> missionaryBonuses = missionary.getModifierSet(MISSIONARY_TRADE_BONUS);
        if (sense) {
            result = missionaryBonuses;
        } else {
            result = new HashSet<Modifier>();
            for (Modifier m : missionaryBonuses) {
                result.add(new Modifier(m.getId(), m.getSource(), -m.getValue(), m.getType()));
            }
        }
        return result;
    }

    private Set<Modifier> getShipTradePenalties(boolean sense) {
        Specification spec = this.getSpecification();
        List<Modifier> shipPenalties = spec.getModifiers(SHIP_TRADE_PENALTY);
        HashSet<Modifier> result = new HashSet<Modifier>();
        int penalty = spec.getInteger("model.option.shipTradePenalty");
        for (Modifier m : shipPenalties) {
            result.add(new Modifier(m.getId(), m.getSource(), sense ? penalty : -penalty, m.getType()));
        }
        return result;
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player buyer = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = is.getPriceToSell(goods);
            switch (is.getAlarm(buyer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price *= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            Unit missionary = is.getMissionary(buyer);
            if (missionary != null && spec.getBoolean("model.option.enhancedMissionaries")) {
                modifiers.addAll(this.getMissionaryTradeBonuses(missionary, false));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(false));
            }
            price = (int)FeatureContainer.applyModifierSet(price, this.getGame().getTurn(), modifiers);
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (Utils.randomInt(logger, "Haggle-buy", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -2;
        }
        this.sessionRegister.put(goldKey, new Integer(gold));
        this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
        return gold;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        int price;
        logger.finest("Entering method sellProposition");
        Specification spec = this.getSpecification();
        IndianSettlement is = (IndianSettlement)settlement;
        Player seller = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        if (this.sessionRegister.containsKey(goldKey)) {
            price = this.sessionRegister.get(goldKey);
        } else {
            price = is.getPriceToBuy(goods);
            switch (is.getAlarm(seller).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    break;
                }
                case DISPLEASED: {
                    price /= 2;
                    break;
                }
                case ANGRY: {
                    if (!goods.getType().isMilitaryGoods()) {
                        return -3;
                    }
                    price /= 2;
                    break;
                }
                default: {
                    return -3;
                }
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            Unit missionary = is.getMissionary(seller);
            if (missionary != null && spec.getBoolean("model.option.enhancedMissionaries")) {
                modifiers.addAll(this.getMissionaryTradeBonuses(missionary, true));
            }
            if (unit.isNaval()) {
                modifiers.addAll(this.getShipTradePenalties(true));
            }
            if ((price = (int)FeatureContainer.applyModifierSet(price, this.getGame().getTurn(), modifiers)) <= 0) {
                return 0;
            }
            this.sessionRegister.put(goldKey, new Integer(price));
        }
        if (gold < 0 || price == gold) {
            return price;
        }
        if (gold > price * 11 / 10) {
            logger.warning("Cheating attempt: haggling with a request too high");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (Utils.randomInt(logger, "Haggle-sell", this.getAIRandom(), 3 + haggling) >= 3) {
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -2;
        }
        this.sessionRegister.put(goldKey, new Integer(gold));
        this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
        return gold;
    }

    private void secureSettlements() {
        List<IndianSettlement> settlements = this.getPlayer().getIndianSettlements();
        for (IndianSettlement is : settlements) {
            int n = Utils.randomInt(logger, "Secure", this.getAIRandom(), settlements.size());
            IndianSettlement settlement = settlements.get(n);
            if (settlement == is) continue;
            is.tradeGoodsWithSetlement(settlement);
        }
        for (IndianSettlement is : settlements) {
            this.equipBraves(is);
            this.secureIndianSettlement(is);
        }
    }

    public void equipBraves(IndianSettlement is) {
        Specification spec = this.getSpecification();
        List<Unit> units = is.getUnitList();
        block0: for (Unit.Role r : new Unit.Role[]{Unit.Role.DRAGOON, Unit.Role.SOLDIER, Unit.Role.SCOUT}) {
            List<EquipmentType> e = r.getRoleEquipment(spec);
            while (!units.isEmpty()) {
                Unit u = units.get(0);
                for (EquipmentType et : e) {
                    if (!u.canBeEquippedWith(et) || is.canProvideEquipment(et)) continue;
                    continue block0;
                }
                if (u.getRole() != Unit.Role.DRAGOON && u.getRole() != r) {
                    this.getAIUnit(u).equipForRole(r, false);
                }
                units.remove(0);
            }
        }
    }

    void secureIndianSettlement(IndianSettlement is) {
        AIUnit newDefenderAI;
        if (!is.getOwner().isAtWar()) {
            return;
        }
        int defenders = is.getTile().getUnitCount();
        int threat = 0;
        int worstThreat = 0;
        Location bestTarget = null;
        for (Tile t : is.getTile().getSurroundingTiles(2)) {
            if (!t.isLand() || t.getUnitCount() == 0) continue;
            Player enemy = t.getFirstUnit().getOwner();
            if (enemy == this.getPlayer()) {
                ++defenders;
                continue;
            }
            if (!this.getPlayer().hasContacted(enemy)) continue;
            int value = this.getPlayer().getTension(enemy).getValue();
            int threatModifier = 0;
            int unitThreat = 0;
            if (value >= 300) {
                threatModifier = 2;
                unitThreat = t.getUnitCount() * 2;
            } else if (value >= 100) {
                threatModifier = 1;
                unitThreat = t.getUnitCount();
            }
            threat += threatModifier;
            if (unitThreat <= worstThreat) continue;
            bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
            worstThreat = unitThreat;
        }
        if (threat > defenders && bestTarget != null && (newDefenderAI = this.getBraveForSeekAndDestroy(is)) != null) {
            Tile targetTile = bestTarget.getTile();
            if (this.isTargetValidForSeekAndDestroy(newDefenderAI.getUnit(), targetTile)) {
                newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, bestTarget));
            }
        }
    }

    private AIUnit getBraveForSeekAndDestroy(IndianSettlement indianSettlement) {
        Iterator<Unit> it = indianSettlement.getOwnedUnitsIterator();
        while (it.hasNext()) {
            AIUnit chosenOne = this.getAIUnit(it.next());
            if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission)) continue;
            return chosenOne;
        }
        return null;
    }

    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        HashMap workerWishes = new HashMap();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            workerWishes.put(unitType, new ArrayList());
        }
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            boolean isExpert;
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (unit.getState() == Unit.UnitState.IN_COLONY && unit.getSettlement().getUnitCount() <= 1) continue;
            if (unit.isOffensiveUnit() || unit.isDefensiveUnit()) {
                boolean isPastStart;
                Player owner = unit.getOwner();
                boolean bl = isPastStart = this.getGame().getTurn().getNumber() > 5 && !owner.getSettlements().isEmpty();
                if (!unit.isColonist() || isPastStart || owner.isIndian() || owner.isREF()) {
                    this.giveMilitaryMission(aiUnit);
                    continue;
                }
            }
            boolean isPioneer = unit.hasAbility("model.ability.improveTerrain") || unit.hasAbility("model.ability.expertPioneer");
            boolean bl = isExpert = unit.getSkillLevel() > 0;
            if (isPioneer && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (aiUnit.hasMission()) continue;
            if (aiUnit.getUnit().isOffensiveUnit()) {
                aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new IdleAtColonyMission(this.getAIMain(), aiUnit));
        }
    }

    private void bringGifts() {
        logger.finest("Entering method bringGifts");
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (Utils.randomInt(logger, "BringGifts", this.getAIRandom(), 10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianBringGiftMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null || !IndianBringGiftMission.isValidMission(this.getPlayer(), t.getColony().getOwner())) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            Colony target = (Colony)nearbyColonies.get(Utils.randomInt(logger, "Choose colony", this.getAIRandom(), nearbyColonies.size()));
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || !chosenOne.getUnit().canCarryGoods() || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                chosenOne.setMission(new IndianBringGiftMission(this.getAIMain(), chosenOne, target));
                continue block0;
            }
        }
    }

    private void demandTribute() {
        logger.finest("Entering method demandTribute");
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (Utils.randomInt(logger, "DemandTribute", this.getAIRandom(), 10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianDemandMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            int targetTension = Integer.MIN_VALUE;
            Settlement target = null;
            for (int i = 0; i < nearbyColonies.size(); ++i) {
                Colony t = (Colony)nearbyColonies.get(i);
                Player to = t.getOwner();
                if (!this.getPlayer().hasContacted(to) || !indianSettlement.hasContactedSettlement(to)) continue;
                int tension = 1 + this.getPlayer().getTension(to).getValue() + indianSettlement.getAlarm(to).getValue();
                tension = Utils.randomInt(logger, "Tension", this.getAIRandom(), tension);
                if (tension <= targetTension) continue;
                targetTension = tension;
                target = t;
            }
            if (target == null) continue;
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || !chosenOne.getUnit().canCarryGoods() || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                Player tp = target.getOwner();
                int tension = 1 + this.getPlayer().getTension(tp).getValue() + indianSettlement.getAlarm(tp).getValue();
                if (Utils.randomInt(logger, "Unhappy?", this.getAIRandom(), tension) <= Tension.Level.HAPPY.getLimit()) continue;
                chosenOne.setMission(new IndianDemandMission(this.getAIMain(), chosenOne, (Colony)target));
                continue block0;
            }
        }
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        if (!this.isTargetValidForSeekAndDestroy(unit, newTile)) {
            return Integer.MIN_VALUE;
        }
        Settlement settlement = newTile.getSettlement();
        Unit defender = newTile.getDefendingUnit(unit);
        int value = 10020 - turns * 100;
        if (settlement != null) {
            IndianSettlement is;
            Tension tension;
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                value += 50 * colony.getUnitCount();
                if (colony.hasStockade()) {
                    value -= 1000 * colony.getStockade().getLevel();
                }
            } else if (settlement instanceof IndianSettlement && (tension = (is = (IndianSettlement)settlement).getAlarm(unit.getOwner())) != null) {
                value += tension.getValue();
            }
        } else if (defender != null) {
            CombatModel combatModel = unit.getGame().getCombatModel();
            float off = combatModel.getOffencePower(unit, defender);
            float def = combatModel.getDefencePower(unit, defender);
            if (defender.getType().getOffence() > 0) {
                value = (int)((float)value + (200.0f - def * 2.0f - (float)(turns * 50)));
            }
            value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
            if (!defender.isNaval() && defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - def * 2.0f - (float)(turns * 25)));
            }
            if (value < 0) {
                value = 0;
            }
        }
        logger.finest("getUnitSeekAndDestroyMissionValue " + unit.getId() + " v " + (settlement != null ? settlement.getId() : (defender != null ? defender.getId() : "none")) + " = " + value);
        return value;
    }

    public void giveMilitaryMission(AIUnit aiUnit) {
        logger.finest("Entering giveMilitaryMission for: " + aiUnit.getUnit());
        AIMain aiMain = this.getAIMain();
        UnitWanderHostileMission mission = new UnitWanderHostileMission(aiMain, aiUnit);
        aiUnit.setMission(mission);
        logger.finest("giveMilitaryMission found: " + mission + " for unit: " + aiUnit);
    }
}

