/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkLocationPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(WorkLocationPlan.class.getName());
    private WorkLocation workLocation;
    private int priority;
    private GoodsType goodsType;

    public WorkLocationPlan(AIMain aiMain, WorkLocation workLocation, GoodsType goodsType) {
        super(aiMain);
        this.workLocation = workLocation;
        this.goodsType = goodsType;
        this.setValue(this.getProductionOf(goodsType));
    }

    public WorkLocationPlan(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
        this.setValue(this.getProductionOf(this.goodsType));
    }

    public WorkLocation getWorkLocation() {
        return this.workLocation;
    }

    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == null || goodsType != this.goodsType) {
            return 0;
        }
        if (this.workLocation instanceof ColonyTile) {
            if (!goodsType.isFarmed()) {
                return 0;
            }
            ColonyTile ct = (ColonyTile)this.workLocation;
            Tile t = ct.getWorkTile();
            UnitType expertUnitType = this.getSpecification().getExpertForProducing(goodsType);
            int base = t.getMaximumPotential(goodsType, expertUnitType);
            if (t.isLand() && base != 0) {
                ++base;
            }
            if (base == 0) {
                return 0;
            }
            base = (int)expertUnitType.getFeatureContainer().applyModifier(base, goodsType.getId());
            return Math.max(base, 1);
        }
        if (goodsType.isFarmed()) {
            return 0;
        }
        if (goodsType == this.getSpecification().getGoodsType("model.goods.hammers")) {
            return 16;
        }
        if (goodsType == this.getSpecification().getGoodsType("model.goods.bells")) {
            return 12;
        }
        if (goodsType == this.getSpecification().getGoodsType("model.goods.crosses")) {
            return 10;
        }
        return this.workLocation.getColony().getOwner().getMarket().getSalePrice(goodsType, 1);
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public void setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
        this.setValue(this.getProductionOf(goodsType));
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(WorkLocationPlan.getXMLElementTagName());
        element.setAttribute("ID", this.workLocation.getId());
        element.setAttribute("priority", Integer.toString(this.priority));
        element.setAttribute("goodsType", this.goodsType.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.workLocation = (WorkLocation)this.getAIMain().getFreeColGameObject(element.getAttribute("ID"));
        this.priority = Integer.parseInt(element.getAttribute("priority"));
        this.goodsType = this.getSpecification().getGoodsType(element.getAttribute("goodsType"));
    }

    public static String getXMLElementTagName() {
        return "workLocationPlan";
    }
}

