/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.XMLStream;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectController {
    private static final Logger logger = Logger.getLogger(ConnectController.class.getName());
    private final FreeColClient freeColClient;
    private GUI gui;

    public ConnectController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    private boolean unblockServer(int port) {
        FreeColServer freeColServer = this.freeColClient.getFreeColServer();
        if (freeColServer != null && freeColServer.getServer().getPort() == port) {
            if (this.gui.showConfirmDialog("stopServer.text", "stopServer.yes", "stopServer.no")) {
                freeColServer.getController().shutdown();
            } else {
                return false;
            }
        }
        return true;
    }

    public void startMultiplayerGame(Specification specification, boolean publicServer, String userName, int port, NationOptions.Advantages advantages, OptionGroup level) {
        FreeColServer freeColServer;
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if (!this.unblockServer(port)) {
            return;
        }
        try {
            freeColServer = new FreeColServer(specification, publicServer, false, port, null, advantages);
        }
        catch (NoRouteToServerException e) {
            this.gui.errorMessage("server.noRouteToServer");
            logger.log(Level.WARNING, "No route to server.", e);
            return;
        }
        catch (IOException e) {
            this.gui.errorMessage("server.couldNotStart");
            logger.log(Level.WARNING, "Could not start server.", e);
            return;
        }
        this.freeColClient.setFreeColServer(freeColServer);
        this.joinMultiplayerGame(userName, "localhost", port);
    }

    private void loadModFragments(Specification specification) {
        boolean loadedMod = false;
        for (FreeColModFile f : this.freeColClient.getClientOptions().getActiveMods()) {
            InputStream sis = null;
            try {
                sis = f.getSpecificationInputStream();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "IO error in mod fragment " + f.getId(), ioe);
            }
            if (sis == null) continue;
            try {
                specification.loadFragment(sis);
                loadedMod = true;
                logger.info("Loaded mod fragment " + f.getId());
            }
            catch (RuntimeException rte) {
                logger.log(Level.WARNING, "Parse error in mod fragment " + f.getId(), rte);
            }
        }
        if (loadedMod) {
            this.freeColClient.updateActions();
        }
    }

    public void startSinglePlayerGame(Specification specification, String userName, NationOptions.Advantages advantages) {
        FreeColServer freeColServer;
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if (!this.unblockServer(FreeCol.getDefaultPort())) {
            return;
        }
        this.loadModFragments(specification);
        try {
            freeColServer = new FreeColServer(specification, false, true, -1, null, advantages);
        }
        catch (NoRouteToServerException e) {
            this.gui.errorMessage("server.noRouteToServer");
            logger.log(Level.WARNING, "No route to server (single player!).", e);
            return;
        }
        catch (IOException e) {
            this.gui.errorMessage("server.couldNotStart");
            logger.log(Level.WARNING, "Could not start server.", e);
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autosaveDelete")) {
            FreeColServer.removeAutosaves(Messages.message("clientOptions.savegames.autosave.fileprefix"));
        }
        this.freeColClient.setFreeColServer(freeColServer);
        this.freeColClient.setSinglePlayer(true);
        if (this.login(userName, "127.0.0.1", freeColServer.getPort())) {
            this.freeColClient.getPreGameController().setReady(true);
            this.gui.showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), true);
        }
    }

    public void joinMultiplayerGame(String userName, String host, int port) {
        List<String> vacantPlayers;
        this.freeColClient.setMapEditor(false);
        if (this.freeColClient.isLoggedIn()) {
            this.logout(true);
        }
        if ((vacantPlayers = this.getVacantPlayers(host, port)) != null) {
            String choice = this.gui.showSimpleChoiceDialog(null, "connectController.choicePlayer", "cancel", vacantPlayers);
            if (choice == null) {
                return;
            }
            userName = choice;
        }
        this.freeColClient.setSinglePlayer(false);
        if (this.login(userName, host, port) && !this.freeColClient.isInGame()) {
            this.gui.showStartGamePanel(this.freeColClient.getGame(), this.freeColClient.getMyPlayer(), false);
        }
    }

    public boolean login(String userName, String host, int port) {
        Game game;
        this.freeColClient.setMapEditor(false);
        this.freeColClient.askServer().disconnect();
        try {
            this.freeColClient.askServer().connect("FreeColClient:" + userName, host, port, this.freeColClient.getPreGameInputHandler());
        }
        catch (Exception e) {
            this.gui.errorMessage("server.couldNotConnect", e.getMessage());
            return false;
        }
        LoginMessage msg = this.freeColClient.askServer().login(userName, FreeCol.getVersion());
        if (msg == null || (game = msg.getGame()) == null) {
            return false;
        }
        this.freeColClient.setGame(game);
        Player player = game.getPlayerByName(userName);
        if (player == null) {
            logger.warning("New game does not contain player: " + userName);
            return false;
        }
        this.freeColClient.setMyPlayer(player);
        this.freeColClient.addSpecificationActions(game.getSpecification());
        logger.info("FreeColClient logged in as " + userName + "/" + player.getId());
        if (msg.getStartGame()) {
            Tile entryTile = player.getEntryLocation() == null ? null : player.getEntryLocation().getTile();
            this.freeColClient.setSinglePlayer(msg.isSinglePlayer());
            this.freeColClient.getPreGameController().startGame();
            if (msg.isCurrentPlayer()) {
                this.freeColClient.getInGameController().setCurrentPlayer(player);
                Unit activeUnit = msg.getActiveUnit();
                if (activeUnit != null) {
                    activeUnit.getOwner().resetIterators();
                    activeUnit.getOwner().setNextActiveUnit(activeUnit);
                    this.gui.setActiveUnit(activeUnit);
                } else {
                    this.gui.setSelectedTile(entryTile, false);
                }
            } else {
                this.gui.setSelectedTile(entryTile, false);
            }
        }
        this.freeColClient.setLoggedIn(true);
        return true;
    }

    public void reconnect() {
        String userName = this.freeColClient.getMyPlayer().getName();
        String host = this.freeColClient.getClient().getHost();
        int port = this.freeColClient.getClient().getPort();
        this.gui.removeInGameComponents();
        this.logout(true);
        this.login(userName, host, port);
        this.freeColClient.getInGameController().nextModelMessage();
    }

    public void loadGame() {
        File file = this.gui.showLoadDialog(FreeColDirectories.getSaveDirectory());
        if (file != null) {
            this.loadGame(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadGame(File file) {
        class ErrorJob
        implements Runnable {
            private final String message;

            ErrorJob(String message) {
                this.message = message;
            }

            public void run() {
                ConnectController.this.gui.closeMenus();
                ConnectController.this.gui.errorMessage(this.message);
            }
        }
        int port;
        String name;
        boolean singlePlayer;
        final File theFile = file;
        this.freeColClient.setMapEditor(false);
        XMLStream xs = null;
        try {
            boolean show;
            FreeColSavegameFile fis = new FreeColSavegameFile(theFile);
            xs = new XMLStream(fis.getSavegameInputStream());
            XMLStreamReader in = xs.getXMLStreamReader();
            in.nextTag();
            String str = in.getAttributeValue(null, "singleplayer");
            boolean defaultSinglePlayer = str != null && Boolean.valueOf(str) != false;
            str = in.getAttributeValue(null, "publicServer");
            boolean defaultPublicServer = str != null && Boolean.valueOf(str) != false;
            xs.close();
            try {
                ClientOptions options = this.freeColClient.getClientOptions();
                options.updateOptions(fis.getInputStream("client-options.xml"));
                options.fixClientOptions();
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            int sgo = this.freeColClient.getClientOptions().getInteger("model.option.showSavegameSettings");
            boolean bl = show = sgo == 2 || !defaultSinglePlayer && sgo == 1;
            if (show) {
                if (!this.gui.showLoadingSavegameDialog(defaultPublicServer, defaultSinglePlayer)) return;
                LoadingSavegameDialog lsd = this.gui.getLoadingSavegameDialog();
                singlePlayer = lsd.isSinglePlayer();
                name = lsd.getName();
                port = lsd.getPort();
            } else {
                singlePlayer = defaultSinglePlayer;
                name = null;
                port = -1;
            }
        }
        catch (FileNotFoundException e) {
            SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
            logger.log(Level.WARNING, "Can not find file: " + file.getName(), e);
            return;
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
            logger.log(Level.WARNING, "Could not start server.", e);
            return;
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, "Error reading game from: " + file.getName(), e);
            SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
            return;
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new ErrorJob("couldNotLoadGame"));
            logger.log(Level.WARNING, "Could not load game from: " + file.getName(), e);
            return;
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
        if (!this.unblockServer(port)) {
            return;
        }
        this.gui.showStatusPanel(Messages.message("status.loadingGame"));
        Runnable loadGameJob = new Runnable(){

            public void run() {
                FreeColServer freeColServer = null;
                try {
                    final FreeColSavegameFile saveGame = new FreeColSavegameFile(theFile);
                    freeColServer = new FreeColServer(saveGame, port, name);
                    ConnectController.this.freeColClient.setFreeColServer(freeColServer);
                    final String userName = freeColServer.getOwner();
                    final int port2 = freeColServer.getPort();
                    ConnectController.this.freeColClient.setSinglePlayer(singlePlayer);
                    ConnectController.this.freeColClient.getInGameController().setGameConnected();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ResourceManager.setScenarioMapping(saveGame.getResourceMapping());
                            ConnectController.this.login(userName, "127.0.0.1", port2);
                            ConnectController.this.gui.closeStatusPanel();
                        }
                    });
                }
                catch (NoRouteToServerException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.gui.closeMainPanel();
                            ConnectController.this.gui.showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("server.noRouteToServer"));
                    logger.log(Level.WARNING, "No route to server.", e);
                }
                catch (FileNotFoundException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.gui.closeMainPanel();
                            ConnectController.this.gui.showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("fileNotFound"));
                    logger.log(Level.WARNING, "Can not find file.", e);
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.gui.closeMainPanel();
                            ConnectController.this.gui.showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob("server.couldNotStart"));
                    logger.log(Level.WARNING, "Error starting game.", e);
                }
                catch (FreeColException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectController.this.gui.closeMainPanel();
                            ConnectController.this.gui.showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(e.getMessage()));
                    logger.log(Level.WARNING, "FreeCol error starting game.", e);
                }
            }
        };
        this.freeColClient.worker.schedule(loadGameJob);
    }

    public void logout(boolean notifyServer) {
        if (notifyServer) {
            this.freeColClient.askServer().logout();
        }
        this.freeColClient.askServer().disconnect();
        ResourceManager.setScenarioMapping(null);
        ResourceManager.setCampaignMapping(null);
        if (!this.freeColClient.isHeadless()) {
            this.freeColClient.setInGame(false);
        }
        this.freeColClient.setGame(null);
        this.freeColClient.setMyPlayer(null);
        this.freeColClient.askServer().reset();
        this.freeColClient.setLoggedIn(false);
    }

    public void quitGame(boolean stopServer, boolean notifyServer) {
        if (this.freeColClient.isLoggedIn()) {
            this.logout(notifyServer);
        }
        FreeColServer server = this.freeColClient.getFreeColServer();
        if (stopServer && server != null) {
            server.getController().shutdown();
            this.freeColClient.setFreeColServer(null);
        }
    }

    public void quitGame(boolean stopServer) {
        this.quitGame(stopServer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getVacantPlayers(String host, int port) {
        Connection mc;
        try {
            mc = new Connection(host, port, null, "FreeColClient:");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to server.", e);
            return null;
        }
        ArrayList<String> items = new ArrayList<String>();
        Element element = DOMMessage.createMessage("getVacantPlayers", new String[0]);
        try {
            Element reply = mc.ask(element);
            if (reply == null) {
                logger.warning("The server did not return a list.");
                List<String> list = null;
                return list;
            }
            if (!reply.getTagName().equals("vacantPlayers")) {
                logger.warning("The reply has an unknown type: " + reply.getTagName());
                List<String> list = null;
                return list;
            }
            NodeList nl = reply.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                items.add(((Element)nl.item(i)).getAttribute("username"));
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send message to server.", e);
        }
        finally {
            mc.close();
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInfo> getServerList() {
        Connection mc;
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColClient:");
        }
        catch (IOException e) {
            this.gui.errorMessage("metaServer.couldNotConnect");
            logger.log(Level.WARNING, "Could not connect to meta-server.", e);
            return null;
        }
        try {
            Element reply = mc.ask(DOMMessage.createMessage("getServerList", new String[0]));
            if (reply == null) {
                this.gui.errorMessage("metaServer.communicationError");
                logger.warning("The meta-server did not return a list.");
                List<ServerInfo> list = null;
                return list;
            }
            ArrayList<ServerInfo> items = new ArrayList<ServerInfo>();
            NodeList nl = reply.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                items.add(new ServerInfo((Element)nl.item(i)));
            }
            ArrayList<ServerInfo> arrayList = items;
            return arrayList;
        }
        catch (IOException e) {
            this.gui.errorMessage("metaServer.communicationError");
            logger.log(Level.WARNING, "Network error with meta-server.", e);
            List<ServerInfo> list = null;
            return list;
        }
        finally {
            mc.close();
        }
    }
}

