/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.resources.ResourceManager;

public final class CornerMapControls
extends MapControls {
    private final JLabel compassRose = new JLabel(ResourceManager.getImageIcon("compass.image"));
    private final MiniMapPanel miniMapPanel;
    private Image miniMapSkin;

    public CornerMapControls(final FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, true);
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                Map.Direction direction = Map.Direction.values()[(int)Math.floor(theta / 0.7853981633974483)];
                freeColClient.getInGameController().moveActiveUnit(direction);
            }
        });
        this.miniMapSkin = ResourceManager.getImage("MiniMap.skin");
        this.miniMapPanel = new MiniMapPanel();
        this.miniMapPanel.setFocusable(false);
        this.miniMapPanel.setLayout(null);
        this.miniMap.setSize(220, 128);
        this.miniMapPanel.add(this.miniMapZoomInButton);
        this.miniMapPanel.add(this.miniMapZoomOutButton);
        this.miniMapPanel.add(this.miniMap);
        if (this.miniMapSkin != null) {
            this.miniMapPanel.setBorder(null);
            this.miniMapPanel.setSize(this.miniMapSkin.getWidth(null), this.miniMapSkin.getHeight(null));
            this.miniMapPanel.setOpaque(false);
            this.miniMap.setLocation(38, 75);
            this.miniMapZoomInButton.setLocation(4, 174);
            this.miniMapZoomOutButton.setLocation(264, 174);
        } else {
            int width = this.miniMapZoomOutButton.getWidth() + this.miniMapZoomInButton.getWidth() + 16;
            this.miniMapPanel.setOpaque(true);
            this.miniMap.setBorder(new BevelBorder(0));
            this.miniMap.setLocation(width / 2, 4);
            this.miniMapZoomInButton.setLocation(4, 132 - this.miniMapZoomInButton.getHeight());
            this.miniMapZoomOutButton.setLocation(this.miniMapZoomInButton.getWidth() + 220 + 12, 132 - this.miniMapZoomOutButton.getHeight());
        }
    }

    public void addToComponent(Canvas component) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        this.infoPanel.setLocation(component.getWidth() - this.infoPanel.getWidth(), component.getHeight() - this.infoPanel.getHeight());
        this.miniMapPanel.setLocation(0, component.getHeight() - this.miniMapPanel.getHeight());
        this.compassRose.setLocation(component.getWidth() - this.compassRose.getWidth() - 20, 20);
        if (!this.unitButtons.isEmpty()) {
            int WIDTH = ((UnitButton)this.unitButtons.get(0)).getWidth();
            int SPACE = 5;
            int length = this.unitButtons.size();
            int x = this.miniMapPanel.getWidth() + 1 + (this.infoPanel.getX() - this.miniMapPanel.getWidth() - length * WIDTH - (length - 1) * 5 - WIDTH) / 2;
            int y = component.getHeight() - 40;
            int step = WIDTH + 5;
            for (UnitButton button : this.unitButtons) {
                button.setLocation(x, y);
                x += step;
            }
        }
        component.addToCanvas(this.infoPanel, CONTROLS_LAYER);
        component.addToCanvas(this.miniMapPanel, CONTROLS_LAYER);
        if (this.freeColClient.getClientOptions().getBoolean("model.option.displayCompassRose")) {
            component.addToCanvas(this.compassRose, CONTROLS_LAYER);
        }
        if (!this.freeColClient.isMapEditor()) {
            for (UnitButton button : this.unitButtons) {
                component.addToCanvas(button, CONTROLS_LAYER);
                button.refreshAction();
            }
        }
    }

    public boolean isShowing() {
        return this.infoPanel.getParent() != null;
    }

    public void removeFromComponent(Canvas canvas) {
        canvas.removeFromCanvas(this.infoPanel);
        canvas.removeFromCanvas(this.miniMapPanel);
        canvas.removeFromCanvas(this.compassRose);
        for (UnitButton button : this.unitButtons) {
            canvas.removeFromCanvas(button);
        }
    }

    public void repaint() {
        this.miniMapPanel.repaint();
    }

    public class MiniMapPanel
    extends JPanel {
        public void paintComponent(Graphics graphics) {
            if (CornerMapControls.this.miniMapSkin != null) {
                graphics.drawImage(CornerMapControls.this.miniMapSkin, 0, 0, null);
            }
            super.paintComponent(graphics);
        }
    }
}

