/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoadingSavegameDialog
extends FreeColDialog<Boolean>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(LoadingSavegameDialog.class.getName());
    private JPanel buttons = new JPanel(new FlowLayout());
    private JLabel header;
    private JRadioButton singlePlayer;
    private JRadioButton privateMultiplayer;
    private JRadioButton publicMultiplayer;
    private JTextField serverNameField;
    private JSpinner portField;

    public LoadingSavegameDialog(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        this.setLayout(new BorderLayout());
        this.buttons.add(this.okButton);
        this.buttons.add(this.cancelButton);
        this.header = new JLabel(Messages.message("LoadingSavegame.title"), 0);
        this.header.setFont(mediumHeaderFont);
        this.header.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.add((Component)this.header, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(new JLabel(Messages.message("LoadingSavegame.serverName"), 2));
        panel.add(p1);
        this.serverNameField = new JTextField();
        panel.add(this.serverNameField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(new JLabel(Messages.message("LoadingSavegame.port"), 2));
        panel.add(p2);
        this.portField = new JSpinner(new SpinnerNumberModel(FreeCol.getDefaultPort(), 1, 65536, 1));
        panel.add(this.portField);
        ButtonGroup bg = new ButtonGroup();
        this.singlePlayer = new JRadioButton(Messages.message("LoadingSavegame.singlePlayer"));
        bg.add(this.singlePlayer);
        panel.add(this.singlePlayer);
        this.privateMultiplayer = new JRadioButton(Messages.message("LoadingSavegame.privateMultiplayer"));
        bg.add(this.privateMultiplayer);
        panel.add(this.privateMultiplayer);
        this.publicMultiplayer = new JRadioButton(Messages.message("LoadingSavegame.publicMultiplayer"));
        bg.add(this.publicMultiplayer);
        panel.add(this.publicMultiplayer);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)panel, "Center");
        this.add((Component)this.buttons, "South");
        this.setSize(this.getPreferredSize());
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer.isSelected();
    }

    public boolean isPublic() {
        return this.publicMultiplayer.isSelected();
    }

    public int getPort() {
        return (Integer)this.portField.getValue();
    }

    @Override
    public String getName() {
        return this.serverNameField.getName();
    }

    public void initialize(boolean publicServer, boolean singlePlayer) {
        this.singlePlayer.setSelected(false);
        this.privateMultiplayer.setSelected(false);
        this.publicMultiplayer.setSelected(false);
        if (singlePlayer) {
            this.singlePlayer.setSelected(true);
        } else if (publicServer) {
            this.publicMultiplayer.setSelected(true);
        } else {
            this.privateMultiplayer.setSelected(true);
        }
        this.serverNameField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
            this.setResponse(Boolean.TRUE);
        } else if ("CANCEL".equals(command)) {
            this.getGUI().removeFromCanvas(this);
            this.setResponse(Boolean.FALSE);
        } else {
            logger.warning("Invalid ActionCommand: " + command);
        }
    }
}

