/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersDialog
extends FreeColDialog<Parameters> {
    public static final String COPYRIGHT = "Copyright (C) 2003-2012 The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 9688 $";
    final int COLUMNS = 5;
    final int DEFAULT_distToLandFromHighSeas = 4;
    final int DEFAULT_maxDistanceToEdge = 12;
    final JTextField inputD = new JTextField(Integer.toString(4), 5);
    final JTextField inputM = new JTextField(Integer.toString(12), 5);

    public ParametersDialog(FreeColClient freeColClient, final GUI gui) {
        super(freeColClient, gui);
        this.setLayout(new BoxLayout(this, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int d = Integer.parseInt(ParametersDialog.this.inputD.getText());
                    int m = Integer.parseInt(ParametersDialog.this.inputM.getText());
                    if (d <= 0 || m <= 0) {
                        throw new NumberFormatException();
                    }
                    ParametersDialog.this.setResponse(new Parameters(d, m));
                }
                catch (NumberFormatException nfe) {
                    gui.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(Messages.message("ok"));
        buttons.add(okButton);
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ParametersDialog.this.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        this.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        this.inputD.addActionListener(al);
        this.inputM.addActionListener(al);
        JLabel widthLabel = new JLabel(Messages.message("menuBar.tools.determineHighSeas.distToLandFromHighSeas"));
        widthLabel.setLabelFor(this.inputD);
        JLabel heightLabel = new JLabel(Messages.message("menuBar.tools.determineHighSeas.maxDistanceToEdge"));
        heightLabel.setLabelFor(this.inputM);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(this.inputD);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(this.inputM);
        this.add(widthPanel);
        this.add(heightPanel);
        this.add(buttons);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.inputD.requestFocus();
    }
}

