/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportMilitaryPanel
extends ReportUnitPanel {
    public ReportMilitaryPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, "reportMilitaryAction.name", true);
    }

    protected void addREFUnits() {
        this.reportPanel.add((Component)new JLabel(Messages.message(this.player.getNation().getRefNation().getId() + ".name")), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.getController().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit unit : refUnits) {
                if (unit.getUnitType(this.getSpecification()).hasAbility("model.ability.navalUnit")) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
            }
        }
    }

    protected void addOwnUnits() {
        this.reportPanel.add((Component)this.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", this.player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> scoutUnits = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> dragoonUnits = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> soldierUnits = new ArrayList<AbstractUnit>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isAvailableTo(this.player) || unitType.hasAbility("model.ability.navalUnit") || !unitType.hasAbility("model.ability.expertSoldier") && unitType.getOffence() <= 0) continue;
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                scoutUnits.add(new AbstractUnit(unitType, Unit.Role.SCOUT, this.getCount("scouts", unitType)));
                dragoonUnits.add(new AbstractUnit(unitType, Unit.Role.DRAGOON, this.getCount("dragoons", unitType)));
                soldierUnits.add(new AbstractUnit(unitType, Unit.Role.SOLDIER, this.getCount("soldiers", unitType)));
                continue;
            }
            units.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.getCount("others", unitType)));
        }
        UnitType defaultType = this.getSpecification().getDefaultUnitType();
        dragoonUnits.add(new AbstractUnit(defaultType, Unit.Role.DRAGOON, this.getCount("dragoons", defaultType)));
        soldierUnits.add(new AbstractUnit(defaultType, Unit.Role.SOLDIER, this.getCount("soldiers", defaultType)));
        scoutUnits.add(new AbstractUnit(defaultType, Unit.Role.SCOUT, this.getCount("scouts", defaultType)));
        units.addAll(dragoonUnits);
        units.addAll(soldierUnits);
        units.addAll(scoutUnits);
        for (AbstractUnit unit : units) {
            this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected void gatherData() {
        UnitType defaultType = this.getSpecification().getDefaultUnitType();
        for (Unit unit : this.player.getUnits()) {
            if (!unit.isOffensiveUnit() || unit.isNaval()) continue;
            UnitType unitType = defaultType;
            if (unit.getType().getOffence() > 0 || unit.hasAbility("model.ability.expertSoldier")) {
                unitType = unit.getType();
            }
            String key = unit.getRole() == Unit.Role.DRAGOON ? "dragoons" : (unit.getRole() == Unit.Role.SOLDIER ? "soldiers" : "others");
            this.addUnit(unit, key);
        }
    }
}

