/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.Utils;

public final class UnitLabel
extends JLabel
implements ActionListener,
Draggable {
    private static Logger logger = Logger.getLogger(UnitLabel.class.getName());
    private final Unit unit;
    private boolean selected;
    private boolean isSmall = false;
    private boolean ignoreLocation;
    private InGameController inGameController;
    private FreeColClient freeColClient;
    private GUI gui;

    public UnitLabel(FreeColClient freeColClient, Unit unit, GUI gui) {
        this.freeColClient = freeColClient;
        this.unit = unit;
        this.gui = gui;
        this.inGameController = freeColClient.getInGameController();
        this.selected = false;
        this.setSmall(false);
        this.setIgnoreLocation(false);
        this.updateIcon();
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, GUI gui, boolean isSmall) {
        this(freeColClient, unit, gui);
        this.setSmall(isSmall);
        this.setIgnoreLocation(false);
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, GUI gui, boolean isSmall, boolean ignoreLocation) {
        this(freeColClient, unit, gui);
        this.setSmall(isSmall);
        this.setIgnoreLocation(ignoreLocation);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setIgnoreLocation(boolean b) {
        this.ignoreLocation = b;
    }

    public void setSmall(boolean isSmall) {
        ImageIcon imageIcon = this.gui.getImageLibrary().getUnitImageIcon(this.unit);
        ImageIcon disabledImageIcon = this.gui.getImageLibrary().getUnitImageIcon(this.unit, true);
        if (isSmall) {
            this.setPreferredSize(null);
            this.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            this.setDisabledIcon(new ImageIcon(disabledImageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.isSmall = true;
        } else {
            if (this.unit.getLocation() instanceof ColonyTile) {
                Tile tile = ((ColonyTile)this.unit.getLocation()).getTile();
                TileType tileType = tile.getType();
                Image image = this.gui.getImageLibrary().getTerrainImage(tileType, tile.getX(), tile.getY());
                this.setSize(new Dimension(image.getWidth(null) / 2, imageIcon.getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setIcon(imageIcon);
            this.setDisabledIcon(disabledImageIcon);
            if (this.unit.getLocation() instanceof ColonyTile) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            }
            this.isSmall = false;
        }
    }

    public String getDescriptionLabel() {
        return this.getToolTipText();
    }

    public void setDescriptionLabel(String label) {
        this.setToolTipText(label);
    }

    public void paintComponent(Graphics g) {
        Player player = this.freeColClient.getMyPlayer();
        if (this.ignoreLocation || this.selected || !this.unit.isCarrier() && this.unit.getState() != Unit.UnitState.SENTRY) {
            this.setEnabled(true);
        } else if (this.unit.getOwner() != player && this.unit.getColony() == null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        super.paintComponent(g);
        if (this.ignoreLocation) {
            return;
        }
        if (this.unit.getLocation() instanceof ColonyTile) {
            GoodsType workType = this.unit.getWorkType();
            if (workType != null) {
                int production = ((ColonyTile)this.unit.getLocation()).getTotalProductionOf(workType);
                ProductionLabel pl = new ProductionLabel(this.freeColClient, this.gui, workType, production);
                g.translate(0, 10);
                pl.paintComponent(g);
                g.translate(0, -10);
            }
        } else if (this.getParent() instanceof ColonyPanel.OutsideColonyPanel || this.getParent() instanceof InPortPanel || this.getParent() instanceof EuropePanel.DocksPanel || this.getParent().getParent() instanceof ReportPanel) {
            String text = Messages.message(this.unit.getOccupationKey(player.owns(this.unit)));
            ImageLibrary lib = this.gui.getImageLibrary();
            g.drawImage(lib.getOccupationIndicatorChip(this.unit, text), 0, 0, null);
            if (this.unit.isUnderRepair()) {
                String underRepair = Messages.message(StringTemplate.template("underRepair").addAmount("%turns%", this.unit.getTurnsForRepair()));
                String underRepair1 = underRepair.substring(0, underRepair.indexOf(40)).trim();
                String underRepair2 = underRepair.substring(underRepair.indexOf(40)).trim();
                Font font = ResourceManager.getFont("NormalFont", 14.0f);
                Image repairImage1 = lib.getStringImage((Graphics2D)g, underRepair1, Color.RED, font);
                Image repairImage2 = lib.getStringImage((Graphics2D)g, underRepair2, Color.RED, font);
                int textHeight = repairImage1.getHeight(null) + repairImage2.getHeight(null);
                int leftIndent = Math.min(5, Math.min(this.getWidth() - repairImage1.getWidth(null), this.getWidth() - repairImage2.getWidth(null)));
                g.drawImage(repairImage1, leftIndent, (this.getHeight() - textHeight) / 2, null);
                g.drawImage(repairImage2, leftIndent, (this.getHeight() - textHeight) / 2 + repairImage1.getHeight(null), null);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        String[] args = event.getActionCommand().split("/");
        switch (Enum.valueOf(UnitAction.class, args[0].toUpperCase(Locale.US))) {
            case ASSIGN: {
                this.inGameController.assignTeacher(this.unit, game.getFreeColGameObject(args[1], Unit.class));
                break;
            }
            case WORK_COLONYTILE: {
                if (args.length < 3) break;
                ColonyTile colonyTile = game.getFreeColGameObject(args[1], ColonyTile.class);
                if (args.length >= 4 && "!".equals(args[3]) && !this.inGameController.claimLand(colonyTile.getWorkTile(), this.unit.getColony(), 0)) break;
                if (colonyTile != this.unit.getLocation()) {
                    this.inGameController.work(this.unit, colonyTile);
                }
                this.inGameController.changeWorkType(this.unit, spec.getGoodsType(args[2]));
                break;
            }
            case WORK_BUILDING: {
                Building building;
                if (args.length < 3 || (building = game.getFreeColGameObject(args[1], Building.class)) == this.unit.getLocation()) break;
                this.inGameController.changeWorkType(this.unit, spec.getGoodsType(args[2]));
                this.inGameController.work(this.unit, building);
                break;
            }
            case ACTIVATE_UNIT: {
                this.inGameController.changeState(this.unit, Unit.UnitState.ACTIVE);
                this.gui.setActiveUnit(this.unit);
                break;
            }
            case FORTIFY: {
                this.inGameController.changeState(this.unit, Unit.UnitState.FORTIFYING);
                break;
            }
            case SENTRY: {
                this.inGameController.changeState(this.unit, Unit.UnitState.SENTRY);
                break;
            }
            case COLOPEDIA: {
                this.gui.showColopediaPanel(this.unit.getType().getId());
                break;
            }
            case LEAVE_TOWN: {
                this.inGameController.putOutsideColony(this.unit);
                break;
            }
            case CLEAR_SPECIALITY: {
                this.inGameController.clearSpeciality(this.unit);
                break;
            }
            case CLEAR_ORDERS: {
                this.inGameController.clearOrders(this.unit);
                break;
            }
            case ASSIGN_TRADE_ROUTE: {
                this.inGameController.assignTradeRoute(this.unit);
            }
        }
        this.updateIcon();
    }

    public void updateIcon() {
        ImageLibrary lib = this.gui.getImageLibrary();
        this.setIcon(lib.getUnitImageIcon(this.unit));
        this.setDisabledIcon(lib.getUnitImageIcon(this.unit, true));
        this.setDescriptionLabel(Messages.message(Messages.getLabel(this.unit)));
        StringTemplate label = this.unit.getEquipmentLabel();
        if (label != null) {
            this.setDescriptionLabel(this.getDescriptionLabel() + " (" + Messages.message(label) + ")");
        }
        this.setSmall(this.isSmall);
        for (Container uc = this.getParent(); uc != null; uc = uc.getParent()) {
            if (uc instanceof ColonyPanel) {
                if (this.unit.getColony() != null) break;
                this.gui.removeFromCanvas(uc);
                this.freeColClient.updateActions();
                break;
            }
            if (uc instanceof EuropePanel) break;
        }
    }

    public boolean canUnitBeEquipedWith(JLabel data) {
        if (!this.getUnit().hasAbility("model.ability.canBeEquipped")) {
            return false;
        }
        if (data instanceof GoodsLabel && ((GoodsLabel)data).isToEquip()) {
            return true;
        }
        return data instanceof MarketLabel && ((MarketLabel)data).isToEquip();
    }

    public boolean isOnCarrier() {
        return this.unit != null && this.unit.isOnCarrier();
    }

    public static String getWorkLabel(WorkLocation wl) {
        return "WORK_" + Utils.lastPart(wl.getClass().toString(), ".").toUpperCase(Locale.US);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitAction {
        ASSIGN,
        CLEAR_SPECIALITY,
        ACTIVATE_UNIT,
        FORTIFY,
        SENTRY,
        COLOPEDIA,
        LEAVE_TOWN,
        WORK_COLONYTILE,
        WORK_BUILDING,
        CLEAR_ORDERS,
        ASSIGN_TRADE_ROUTE;

    }
}

