/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

public abstract class UnitPanel
extends JPanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(UnitPanel.class.getName());
    private boolean editable;
    private PortPanel portPanel;

    public UnitPanel(PortPanel portPanel, String name, boolean editable) {
        this.portPanel = portPanel;
        this.editable = editable;
        this.setName(name);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public PortPanel getPortPanel() {
        return this.portPanel;
    }

    public void initialize() {
        this.addPropertyChangeListeners();
        this.update();
    }

    public void update() {
        this.removeAll();
        for (Unit unit : this.portPanel.getUnitList()) {
            if (!this.accepts(unit)) continue;
            UnitLabel unitLabel = new UnitLabel(this.portPanel.getFreeColClient(), unit, this.portPanel.getGUI());
            TradeRoute tradeRoute = unit.getTradeRoute();
            if (tradeRoute != null) {
                unitLabel.setDescriptionLabel(Messages.message(Messages.getLabel(unit)) + " (" + tradeRoute.getName() + ")");
            }
            if (this.editable) {
                unitLabel.setTransferHandler(this.portPanel.getTransferHandler());
                unitLabel.addMouseListener(this.portPanel.getPressListener());
            }
            this.add(unitLabel);
        }
        this.selectLabel();
        this.revalidate();
        this.repaint();
    }

    public void selectLabel() {
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
    }

    protected void removePropertyChangeListeners() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        logger.finest(this.getName() + " change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    public abstract boolean accepts(Unit var1);
}

