/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
extends WorkLocation
implements Named,
Comparable<Building>,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected BuildingType buildingType;

    protected Building() {
    }

    protected Building(Game game, Colony colony, BuildingType type) {
        super(game);
        this.setColony(colony);
        this.buildingType = type;
    }

    public Building(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    private void setType(BuildingType newBuildingType) {
        Colony colony = this.getColony();
        colony.removeFeatures(this.buildingType);
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            colony.addFeatures(this.buildingType);
            for (Unit unit : this.getUnitList()) {
                if (this.canAddType(unit.getType())) continue;
                unit.setLocation(colony.getTile());
            }
        }
        if (this.getUnitCount() > this.getUnitCapacity()) {
            for (Unit unit : this.getUnitList().subList(this.getUnitCapacity(), this.getUnitCount())) {
                unit.setLocation(colony.getTile());
            }
        }
    }

    @Override
    public boolean hasAbility(String id, FreeColGameObjectType type, Turn turn) {
        return this.getType().hasAbility(id);
    }

    @Override
    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType fcgot, Turn turn) {
        return this.getType().getModifierSet(id, fcgot, turn);
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    public int getLevel() {
        return this.getType().getLevel();
    }

    public String getNextNameKey() {
        BuildingType next = this.getType().getUpgradesTo();
        return next == null ? null : next.getNameKey();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.getType().getUpgradesTo());
    }

    public boolean canBeDamaged() {
        return !this.getType().isAutomaticBuild() && !this.getColony().isAutomaticBuild(this.getType());
    }

    public boolean damage() {
        if (this.canBeDamaged()) {
            this.setType(this.getType().getUpgradesFrom());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    public boolean upgrade() {
        if (this.canBuildNext()) {
            this.setType(this.getType().getUpgradesTo());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    public UnitType getExpertUnitType() {
        return this.getSpecification().getExpertForProducing(this.getGoodsOutputType());
    }

    public boolean canAddType(UnitType unitType) {
        return this.canBeWorked() && this.getType().canAdd(unitType);
    }

    public GoodsType getGoodsOutputType() {
        return this.getType().getProducedGoodsType();
    }

    public GoodsType getGoodsInputType() {
        return this.getType().getConsumedGoodsType();
    }

    public int getUnitProduction(Unit unit) {
        if (this.getGoodsOutputType() == null || unit == null) {
            return 0;
        }
        int productivity = 0;
        if (this.getType().getBasicProduction() > 0) {
            GoodsType goodsType = this.getGoodsOutputType();
            UnitType unitType = unit.getType();
            Turn turn = this.getGame().getTurn();
            productivity = (int)FeatureContainer.applyModifiers(0.0f, turn, this.getProductionModifiers(goodsType, unitType));
        }
        return Math.max(0, productivity);
    }

    public ProductionInfo getAdjustedProductionInfo(AbstractGoods output, List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        GoodsType outputType = this.getGoodsOutputType();
        GoodsType inputType = this.getGoodsInputType();
        if (outputType != null && outputType != output.getType()) {
            throw new IllegalArgumentException("Wrong output type: " + output.getType() + " should have been: " + outputType);
        }
        int capacity = this.getColony().getWarehouseCapacity();
        if (this.getType().hasAbility("model.ability.avoidExcessProduction") && output.getAmount() >= capacity) {
            return result;
        }
        int availableInput = 0;
        if (inputType != null) {
            boolean found = false;
            for (AbstractGoods goods : input) {
                if (goods.getType() != inputType) continue;
                availableInput = goods.getAmount();
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("No input goods of type " + inputType + " available.");
            }
        }
        if (outputType != null) {
            int prod;
            int actualInput;
            int maximumInput = 0;
            if (inputType != null && this.canAutoProduce()) {
                int available = this.getColony().getGoodsCount(outputType);
                if (available >= outputType.getBreedingNumber()) {
                    int divisor = (int)this.getType().applyModifier(0.0f, "model.modifier.breedingDivisor");
                    int factor = (int)this.getType().applyModifier(0.0f, "model.modifier.breedingFactor");
                    maximumInput = ((available - 1) / divisor + 1) * factor;
                }
            } else {
                for (Unit u : this.getUnitList()) {
                    maximumInput += this.getUnitProduction(u);
                }
                maximumInput = Math.max(0, maximumInput);
            }
            Turn turn = this.getGame().getTurn();
            List<Modifier> productionModifiers = this.getProductionModifiers(this.getGoodsOutputType(), null);
            int maxProd = (int)FeatureContainer.applyModifiers(maximumInput, turn, productionModifiers);
            int n = actualInput = inputType == null ? maximumInput : Math.min(maximumInput, availableInput);
            if (availableInput < maximumInput && this.getType().hasAbility("model.ability.expertsUseConnections") && this.getSpecification().getBoolean("model.option.expertsHaveConnections")) {
                int minimumGoodsInput = 0;
                for (Unit unit : this.getUnitList()) {
                    if (unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                if (minimumGoodsInput > availableInput) {
                    actualInput = minimumGoodsInput;
                }
            }
            if ((prod = (int)FeatureContainer.applyModifiers(actualInput, turn, productionModifiers)) > 0) {
                if (this.getType().hasAbility("model.ability.avoidExcessProduction")) {
                    int total = output.getAmount() + prod;
                    while (total > capacity) {
                        if (actualInput <= 0) {
                            return result;
                        }
                        prod = (int)FeatureContainer.applyModifiers(--actualInput, turn, productionModifiers);
                        total = output.getAmount() + prod;
                        maximumInput = actualInput;
                        maxProd = prod;
                    }
                }
                prod = Math.max(0, prod);
                maxProd = Math.max(0, maxProd);
                result.addProduction(new AbstractGoods(outputType, prod));
                if (maxProd > prod) {
                    result.addMaximumProduction(new AbstractGoods(outputType, maxProd));
                }
                if (inputType != null) {
                    result.addConsumption(new AbstractGoods(inputType, actualInput));
                    if (maximumInput > actualInput) {
                        result.addMaximumConsumption(new AbstractGoods(inputType, maximumInput));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int compareTo(Building other) {
        return this.getType().compareTo(other.getType());
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("inLocation").add("%location%", this.getNameKey());
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        if (reason != UnitLocation.NoAddReason.NONE) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString() + " because " + (Object)((Object)reason));
        }
        Unit unit = (Unit)locatable;
        if (this.contains(unit)) {
            return true;
        }
        if (super.add(unit)) {
            unit.setState(Unit.UnitState.IN_COLONY);
            unit.setWorkType(this.getGoodsOutputType());
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (super.remove(unit)) {
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            return UnitLocation.NoAddReason.WRONG_TYPE;
        }
        UnitLocation.NoAddReason reason = this.getNoWorkReason();
        Unit unit = (Unit)locatable;
        BuildingType type = this.getType();
        return reason != UnitLocation.NoAddReason.NONE ? reason : (!type.canAdd(unit.getType()) ? UnitLocation.NoAddReason.MISSING_SKILL : super.getNoAddReason(locatable));
    }

    @Override
    public int getUnitCapacity() {
        return this.getType().getWorkPlaces();
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        return UnitLocation.NoAddReason.NONE;
    }

    @Override
    public boolean canAutoProduce() {
        return this.getType().hasAbility("model.ability.autoProduction");
    }

    @Override
    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        int result = this.getGoodsOutputType() == null || this.getGoodsOutputType() != goodsType ? 0 : this.getPotentialProduction(goodsType, unit.getType());
        return Math.max(0, result);
    }

    @Override
    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        int production = 0;
        if (this.getGoodsOutputType() == goodsType && this.getType().getBasicProduction() > 0) {
            production = (int)FeatureContainer.applyModifiers(0.0f, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType));
        }
        return Math.max(0, production);
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        if (goodsType != null && goodsType == this.getGoodsOutputType()) {
            BuildingType type = this.getType();
            String id = goodsType.getId();
            Turn turn = this.getGame().getTurn();
            Player owner = this.getOwner();
            if (unitType != null) {
                mods.addAll(this.getModifierSet(id, unitType, turn));
                mods.add(this.getColony().getProductionModifier(goodsType));
                mods.add(type.getProductionModifier());
                mods.addAll(unitType.getModifierSet(id, goodsType, turn));
                if (owner != null) {
                    mods.addAll(owner.getModifierSet(id, unitType, turn));
                }
            } else {
                mods.addAll(this.getColony().getModifierSet(id, type, turn));
                if (owner != null) {
                    mods.addAll(owner.getModifierSet(id, type, turn));
                }
            }
        }
        return mods;
    }

    @Override
    public GoodsType getBestWorkType(Unit unit) {
        return this.getGoodsOutputType();
    }

    public boolean consumes(GoodsType goodsType) {
        return goodsType == this.getGoodsInputType();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        GoodsType inputType = this.getGoodsInputType();
        if (inputType != null) {
            result.add(new AbstractGoods(inputType, 0));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.getType().getPriority();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Building.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("buildingType", this.buildingType.getId());
        super.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.buildingType = this.getSpecification().getBuildingType(in.getAttributeValue(null, "buildingType"));
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return Utils.lastPart(this.getType().getId(), ".") + "/" + this.getColony().getName();
    }

    public static String getXMLElementTagName() {
        return "building";
    }
}

