/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeatureContainer {
    private static final Logger logger = Logger.getLogger(FeatureContainer.class.getName());
    private Map<String, Set<Ability>> abilities = null;
    private Map<String, Set<Modifier>> modifiers = null;

    private void requireAbilities() {
        if (this.abilities == null) {
            this.abilities = new HashMap<String, Set<Ability>>();
        }
    }

    private void requireModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new HashMap<String, Set<Modifier>>();
        }
    }

    public static boolean hasAbility(FeatureContainer fc, String id, FreeColGameObjectType fcgot, Turn turn) {
        Set<Ability> abilitySet;
        if (fc == null || fc.abilities == null || (abilitySet = fc.abilities.get(id)) == null) {
            return false;
        }
        boolean ret = false;
        for (Ability ability : abilitySet) {
            if (!ability.appliesTo(fcgot, turn)) continue;
            if (!ability.getValue()) {
                return false;
            }
            ret = true;
        }
        return ret;
    }

    public static boolean hasAbility(Set<Ability> abilitySet) {
        if (abilitySet == null || abilitySet.isEmpty()) {
            return false;
        }
        for (Ability ability : abilitySet) {
            if (ability.getValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAbilityKey(FeatureContainer fc, String key) {
        return fc == null || fc.abilities == null ? false : fc.abilities.containsKey(key);
    }

    public static Set<Ability> getAbilities(FeatureContainer fc) {
        HashSet<Ability> result = new HashSet<Ability>();
        if (fc != null && fc.abilities != null) {
            for (Set<Ability> abilitySet : fc.abilities.values()) {
                result.addAll(abilitySet);
            }
        }
        return result;
    }

    public static Set<Ability> getAbilitySet(FeatureContainer fc, String id, FreeColGameObjectType fcgot, Turn turn) {
        Set<Ability> abilitySet;
        HashSet<Ability> result = new HashSet<Ability>();
        if (fc != null && fc.abilities != null && (abilitySet = fc.abilities.get(id)) != null) {
            for (Ability ability : abilitySet) {
                if (!ability.appliesTo(fcgot, turn)) continue;
                result.add(ability);
            }
        }
        return result;
    }

    public static boolean addAbility(FeatureContainer fc, Ability ability) {
        if (fc == null || ability == null) {
            return false;
        }
        fc.requireAbilities();
        Set<Ability> abilitySet = fc.abilities.get(ability.getId());
        if (abilitySet == null) {
            abilitySet = new HashSet<Ability>();
            fc.abilities.put(ability.getId(), abilitySet);
        }
        return abilitySet.add(ability);
    }

    public static Ability removeAbility(FeatureContainer fc, Ability ability) {
        if (fc == null || fc.abilities == null || ability == null) {
            return null;
        }
        Set<Ability> abilitySet = fc.abilities.get(ability.getId());
        return abilitySet == null || !abilitySet.remove(ability) ? null : ability;
    }

    public static void removeAbilities(FeatureContainer fc, String id) {
        if (fc != null && fc.abilities != null) {
            fc.abilities.remove(id);
        }
    }

    public static Set<Modifier> getModifiers(FeatureContainer fc) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (fc != null && fc.modifiers != null) {
            for (Set<Modifier> modifierSet : fc.modifiers.values()) {
                result.addAll(modifierSet);
            }
        }
        return result;
    }

    public static Set<Modifier> getModifierSet(FeatureContainer fc, String id, FreeColGameObjectType fcgot, Turn turn) {
        return fc == null || fc.modifiers == null ? new HashSet<Modifier>() : fc.getModifierSet(id, fcgot, turn);
    }

    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType fcgot, Turn turn) {
        Set<Modifier> modifierSet;
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (this.modifiers != null && (modifierSet = this.modifiers.get(id)) != null) {
            for (Modifier modifier : modifierSet) {
                if (!modifier.appliesTo(fcgot, turn)) continue;
                result.add(modifier);
            }
        }
        return result;
    }

    public static float applyModifier(FeatureContainer fc, float number, String id, FreeColGameObjectType fcgot, Turn turn) {
        return fc == null || fc.modifiers == null ? number : fc.applyModifier(number, id, fcgot, turn);
    }

    public float applyModifier(float number, String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.applyModifierSet(number, turn, this.getModifierSet(id, fcgot, turn));
    }

    public static float applyModifiers(float number, Turn turn, List<Modifier> modifiers) {
        if (modifiers == null || modifiers.isEmpty()) {
            return number;
        }
        Collections.sort(modifiers);
        float result = number;
        for (Modifier modifier : modifiers) {
            float value = modifier.getValue(turn);
            if (value == Float.MIN_VALUE) {
                return value;
            }
            result = modifier.apply(result, value);
        }
        return result;
    }

    public static float applyModifierSet(float number, Turn turn, Set<Modifier> modifiers) {
        float additive = 0.0f;
        float percentage = 0.0f;
        float multiplicative = 1.0f;
        for (Modifier modifier : modifiers) {
            float value = modifier.getValue(turn);
            if (value == Float.MIN_VALUE) {
                return Float.MIN_VALUE;
            }
            switch (modifier.getType()) {
                case ADDITIVE: {
                    additive += value;
                    break;
                }
                case MULTIPLICATIVE: {
                    multiplicative *= value;
                    break;
                }
                case PERCENTAGE: {
                    percentage += value;
                }
            }
        }
        float result = number;
        result += additive;
        result *= multiplicative;
        result += result * percentage / 100.0f;
        return result;
    }

    public static boolean addModifier(FeatureContainer fc, Modifier modifier) {
        if (fc == null) {
            logger.warning("addModifier to <null-feature-container>: " + modifier);
            return false;
        }
        if (modifier == null) {
            return false;
        }
        fc.requireModifiers();
        Set<Modifier> modifierSet = fc.modifiers.get(modifier.getId());
        if (modifierSet == null) {
            modifierSet = new HashSet<Modifier>();
            fc.modifiers.put(modifier.getId(), modifierSet);
        }
        return modifierSet.add(modifier);
    }

    public static Modifier removeModifier(FeatureContainer fc, Modifier modifier) {
        if (fc == null) {
            logger.warning("removeModifier from <null-feature-container>: " + modifier);
            return null;
        }
        if (fc.modifiers == null || modifier == null) {
            return null;
        }
        Set<Modifier> modifierSet = fc.modifiers.get(modifier.getId());
        return modifierSet == null || !modifierSet.remove(modifier) ? null : modifier;
    }

    public static void removeModifiers(FeatureContainer fc, String id) {
        if (fc == null) {
            logger.warning("removeModifiers from <null-feature-container>: " + id);
        } else if (fc.modifiers != null) {
            fc.modifiers.remove(id);
        }
    }

    public static void addFeatures(FeatureContainer fc, FreeColObject fco) {
        FeatureContainer c = fco.getFeatureContainer();
        if (fc == null || c == null) {
            return;
        }
        if (c.abilities != null) {
            fc.requireAbilities();
            for (Map.Entry<String, Set<Feature>> entry : c.abilities.entrySet()) {
                Set<Ability> abilitySet = fc.abilities.get(entry.getKey());
                if (abilitySet == null) {
                    fc.abilities.put(entry.getKey(), new HashSet(entry.getValue()));
                    continue;
                }
                abilitySet.addAll((Collection<Ability>)entry.getValue());
            }
        }
        if (c.modifiers != null) {
            fc.requireModifiers();
            for (Map.Entry<String, Set<Feature>> entry : c.modifiers.entrySet()) {
                Set<Modifier> modifierSet = fc.modifiers.get(entry.getKey());
                if (modifierSet == null) {
                    fc.modifiers.put(entry.getKey(), new HashSet(entry.getValue()));
                    continue;
                }
                modifierSet.addAll((Collection<Modifier>)entry.getValue());
            }
        }
    }

    public static void removeFeatures(FeatureContainer fc, FreeColObject fco) {
        FeatureContainer c = fco.getFeatureContainer();
        if (fc == null || c == null) {
            return;
        }
        if (c.abilities != null && fc.abilities != null) {
            for (Map.Entry<String, Set<Feature>> entry : c.abilities.entrySet()) {
                Set<Ability> abilitySet = fc.abilities.get(entry.getKey());
                if (abilitySet == null) continue;
                abilitySet.removeAll((Collection)entry.getValue());
            }
        }
        if (c.modifiers != null && fc.modifiers != null) {
            for (Map.Entry<String, Set<Feature>> entry : c.modifiers.entrySet()) {
                Set<Modifier> modifierSet = fc.modifiers.get(entry.getKey());
                if (modifierSet == null) continue;
                modifierSet.removeAll((Collection)entry.getValue());
            }
        }
    }

    public void clear() {
        if (this.abilities != null) {
            this.abilities.clear();
        }
        if (this.modifiers != null) {
            this.modifiers.clear();
        }
    }

    public void replaceSource(FreeColGameObjectType oldSource, FreeColGameObjectType newSource) {
        for (Ability ability : FeatureContainer.getAbilities(this)) {
            if (oldSource != null && ability.getSource() != oldSource) continue;
            FeatureContainer.removeAbility(this, ability);
            Ability newAbility = new Ability(ability);
            newAbility.setSource(newSource);
            FeatureContainer.addAbility(this, newAbility);
        }
        for (Modifier modifier : FeatureContainer.getModifiers(this)) {
            if (oldSource != null && modifier.getSource() != oldSource) continue;
            FeatureContainer.removeModifier(this, modifier);
            Modifier newModifier = new Modifier(modifier);
            newModifier.setSource(newSource);
            FeatureContainer.addModifier(this, newModifier);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[FeatureContainer");
        if (this.abilities != null) {
            result.append("[abilities");
            for (Ability ability : FeatureContainer.getAbilities(this)) {
                result.append(" ").append(ability.toString());
            }
            result.append("]");
        }
        if (this.modifiers != null) {
            result.append("[modifiers");
            for (Modifier modifier : FeatureContainer.getModifiers(this)) {
                result.append(" ").append(modifier.toString());
            }
            result.append("]");
        }
        result.append("]");
        return result.toString();
    }
}

