/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;

public class Scope
extends FreeColObject
implements Cloneable {
    private String type;
    private String abilityID;
    private boolean abilityValue = true;
    private String methodName;
    private String methodValue;
    private boolean matchesNull = true;
    private boolean matchNegated = false;
    private static final String ABILITY_ID_TAG = "ability-id";
    private static final String ABILITY_VALUE_TAG = "ability-value";
    private static final String MATCH_NEGATED_TAG = "matchNegated";
    private static final String MATCHES_NULL_TAG = "matchesNull";
    private static final String METHOD_NAME_TAG = "method-name";
    private static final String METHOD_VALUE_TAG = "method-value";
    private static final String TYPE_TAG = "type";

    public Scope() {
    }

    public Scope(XMLStreamReader in) throws XMLStreamException {
        this.readFromXML(in);
    }

    public boolean isMatchesNull() {
        return this.matchesNull;
    }

    public void setMatchesNull(boolean newMatchesNull) {
        this.matchesNull = newMatchesNull;
    }

    public boolean isMatchNegated() {
        return this.matchNegated;
    }

    public void setMatchNegated(boolean newMatchNegated) {
        this.matchNegated = newMatchNegated;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getAbilityID() {
        return this.abilityID;
    }

    public void setAbilityID(String newAbilityID) {
        this.abilityID = newAbilityID;
    }

    public boolean getAbilityValue() {
        return this.abilityValue;
    }

    public void setAbilityValue(boolean newAbilityValue) {
        this.abilityValue = newAbilityValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public void setMethodValue(String newMethodValue) {
        this.methodValue = newMethodValue;
    }

    public boolean appliesTo(FreeColObject object) {
        Method method;
        block15: {
            if (object == null) {
                return this.matchesNull;
            }
            if (this.type != null) {
                if (object instanceof FreeColGameObjectType) {
                    if (!this.type.equals(object.getId())) {
                        return this.matchNegated;
                    }
                } else {
                    if (object instanceof FreeColGameObject) {
                        try {
                            method = object.getClass().getMethod("getType", new Class[0]);
                            if (method != null && FreeColGameObjectType.class.isAssignableFrom(method.getReturnType())) {
                                FreeColGameObjectType objectType = (FreeColGameObjectType)method.invoke((Object)object, new Object[0]);
                                if (!this.type.equals(objectType.getId())) {
                                    return this.matchNegated;
                                }
                                break block15;
                            }
                            return this.matchNegated;
                        }
                        catch (Exception e) {
                            return this.matchNegated;
                        }
                    }
                    return this.matchNegated;
                }
            }
        }
        if (this.abilityID != null && object.hasAbility(this.abilityID) != this.abilityValue) {
            return this.matchNegated;
        }
        if (this.methodName != null) {
            try {
                method = object.getClass().getMethod(this.methodName, new Class[0]);
                if (method != null && !String.valueOf(method.invoke((Object)object, new Object[0])).equals(this.methodValue)) {
                    return this.matchNegated;
                }
            }
            catch (Exception e) {
                return this.matchNegated;
            }
        }
        return !this.matchNegated;
    }

    public int hashCode() {
        int hash = 7;
        hash += 31 * hash + (this.type == null ? 0 : this.type.hashCode());
        hash += 31 * hash + (this.abilityID == null ? 0 : this.abilityID.hashCode());
        hash += 31 * hash + (this.abilityValue ? 1 : 0);
        hash += 31 * hash + (this.methodName == null ? 0 : this.methodName.hashCode());
        hash += 31 * hash + (this.methodValue == null ? 0 : this.methodValue.hashCode());
        hash += 31 * hash + (this.matchesNull ? 1 : 0);
        hash += 31 * hash + (this.matchNegated ? 1 : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Scope) {
            Scope otherScope = (Scope)o;
            if (this.matchNegated != otherScope.matchNegated) {
                return false;
            }
            if (this.matchesNull != otherScope.matchesNull) {
                return false;
            }
            if (this.type == null ? otherScope.getType() != this.type : !this.type.equals(otherScope.getType())) {
                return false;
            }
            if (this.abilityID == null ? otherScope.getAbilityID() != this.abilityID : !this.abilityID.equals(otherScope.getAbilityID())) {
                return false;
            }
            if (this.abilityValue != otherScope.getAbilityValue()) {
                return false;
            }
            if (this.methodName == null ? otherScope.getMethodName() != this.methodName : !this.methodName.equals(otherScope.getMethodName())) {
                return false;
            }
            return !(this.methodValue == null ? otherScope.getMethodValue() != this.methodValue : !this.methodValue.equals(otherScope.getMethodValue()));
        }
        return false;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Scope.getXMLElementTagName());
        this.writeAttributes(out);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        this.writeAttribute(out, MATCH_NEGATED_TAG, this.matchNegated);
        this.writeAttribute(out, MATCHES_NULL_TAG, this.matchesNull);
        if (this.type != null) {
            this.writeAttribute(out, TYPE_TAG, this.type);
        }
        if (this.abilityID != null) {
            this.writeAttribute(out, ABILITY_ID_TAG, this.abilityID);
            this.writeAttribute(out, ABILITY_VALUE_TAG, this.abilityValue);
        }
        if (this.methodName != null) {
            this.writeAttribute(out, METHOD_NAME_TAG, this.methodName);
            if (this.methodValue != null) {
                this.writeAttribute(out, METHOD_VALUE_TAG, this.methodValue);
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        this.matchNegated = this.getAttribute(in, MATCH_NEGATED_TAG, false);
        this.matchesNull = this.getAttribute(in, MATCHES_NULL_TAG, true);
        this.type = this.getAttribute(in, TYPE_TAG, null);
        this.abilityID = this.getAttribute(in, ABILITY_ID_TAG, null);
        this.abilityValue = this.getAttribute(in, ABILITY_VALUE_TAG, true);
        this.methodName = this.getAttribute(in, METHOD_NAME_TAG, null);
        this.methodValue = this.getAttribute(in, METHOD_VALUE_TAG, null);
    }

    public String toString() {
        return "[Scope " + this.type + (this.abilityID == null ? "" : " " + this.abilityID + "=" + this.abilityValue) + (this.methodName == null ? "" : " " + this.methodName + "=" + this.methodValue) + (this.matchesNull ? " matchesNull" : "") + (this.matchNegated ? " matchNegated" : "") + "]";
    }

    public static String getXMLElementTagName() {
        return "scope";
    }
}

