/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;

public class TileImprovement
extends TileItem
implements Named {
    private static Logger logger = Logger.getLogger(TileImprovement.class.getName());
    private TileImprovementType type;
    private int turnsToComplete;
    private int magnitude;
    public static final int NO_RIVER = 0;
    public static final int SMALL_RIVER = 1;
    public static final int LARGE_RIVER = 2;
    public static final int FJORD_RIVER = 3;
    private TileImprovementStyle style;
    private boolean virtual;

    public TileImprovement(Game game, Tile tile, TileImprovementType type) {
        super(game, tile);
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        this.type = type;
        if (!type.isNatural()) {
            this.turnsToComplete = tile.getType().getBasicWorkTurns() + type.getAddWorkTurns();
        }
        this.magnitude = type.getMagnitude();
    }

    public TileImprovement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public TileImprovement(Game game, String id) {
        super(game, id);
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(int magnitude) {
        this.magnitude = magnitude;
    }

    public final boolean isVirtual() {
        return this.virtual;
    }

    public final void setVirtual(boolean newVirtual) {
        this.virtual = newVirtual;
    }

    public boolean isRoad() {
        return this.getType().getId().equals("model.improvement.road");
    }

    public boolean isRiver() {
        return this.getType().getId().equals("model.improvement.river");
    }

    public String getNameKey() {
        return this.getType().getNameKey();
    }

    public String toString() {
        if (this.turnsToComplete > 0) {
            return this.getType().getId() + " (" + Integer.toString(this.turnsToComplete) + " turns left)";
        }
        return this.getType().getId();
    }

    public int getTurnsToComplete() {
        return this.turnsToComplete;
    }

    public void setTurnsToComplete(int turns) {
        this.turnsToComplete = turns;
    }

    public final int getZIndex() {
        return this.type.getZIndex();
    }

    public boolean isComplete() {
        return this.turnsToComplete <= 0;
    }

    public EquipmentType getExpendedEquipmentType() {
        return this.type.getExpendedEquipmentType();
    }

    public int getExpendedAmount() {
        return this.type.getExpendedAmount();
    }

    public int getBonus(GoodsType goodsType) {
        if (!this.isComplete()) {
            return 0;
        }
        return this.type.getBonus(goodsType);
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        if (!this.isComplete()) {
            return null;
        }
        return this.type.getProductionModifier(goodsType);
    }

    public int getMoveCost(Tile fromTile, Tile targetTile, int moveCost) {
        if (this.isComplete()) {
            boolean connected;
            if (this.style == null) {
                return this.type.getMoveCost(moveCost);
            }
            Map.Direction direction = targetTile.getMap().getDirection(targetTile, fromTile);
            boolean bl = this.isRiver() ? this.style != null && this.style.isConnectedTo(direction) : (this.isRoad() ? fromTile.hasRoad() && targetTile.hasRoad() : (connected = false));
            if (connected) {
                return this.type.getMoveCost(moveCost);
            }
        }
        return moveCost;
    }

    public TileType getChange(TileType tileType) {
        if (!this.isComplete()) {
            return null;
        }
        return this.type.getChange(tileType);
    }

    public TileImprovementStyle getStyle() {
        return this.style;
    }

    public void setStyle(TileImprovementStyle style) {
        this.style = style;
    }

    public boolean isConnectedTo(Map.Direction direction) {
        return this.style == null ? false : this.style.isConnectedTo(direction);
    }

    public boolean isWorkerAllowed(Unit unit) {
        if (unit == null) {
            return false;
        }
        if (this.isComplete()) {
            return false;
        }
        return this.type.isWorkerAllowed(unit);
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        return this.type.isTileTypeAllowed(tileType);
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(TileImprovement.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.getTile().getId());
        out.writeAttribute("type", this.getType().getId());
        out.writeAttribute("turns", Integer.toString(this.turnsToComplete));
        out.writeAttribute("magnitude", Integer.toString(this.magnitude));
        if (this.style != null) {
            out.writeAttribute("style", this.style.toString());
        }
        if (this.virtual) {
            out.writeAttribute("virtual", Boolean.toString(this.virtual));
        }
        out.writeEndElement();
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = game.getFreeColGameObject(in.getAttributeValue(null, "tile"), Tile.class);
        if (this.tile == null) {
            this.tile = new Tile(game, in.getAttributeValue(null, "tile"));
        }
        String str = in.getAttributeValue(null, "type");
        this.type = this.getSpecification().getTileImprovementType(str);
        this.turnsToComplete = Integer.parseInt(in.getAttributeValue(null, "turns"));
        this.magnitude = Integer.parseInt(in.getAttributeValue(null, "magnitude"));
        this.style = TileImprovementStyle.getInstance(in.getAttributeValue(null, "style"));
        this.virtual = this.getAttribute(in, "virtual", false);
    }

    public static String getXMLElementTagName() {
        return "tileimprovement";
    }
}

