/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.sf.freecol.common.model.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileImprovementStyle {
    private String style;
    private String mask;
    private Map<Map.Direction, Integer> connections = new EnumMap<Map.Direction, Integer>(Map.Direction.class);
    private static final Map<String, TileImprovementStyle> cache = new HashMap<String, TileImprovementStyle>();

    private TileImprovementStyle(String input) {
        int magnitude;
        int index;
        Map.Direction[] directions;
        Map.Direction[] directionArray = directions = input.length() < 8 ? Map.Direction.longSides : Map.Direction.values();
        if (input.length() < 4) {
            this.style = new String();
            int value = Integer.parseInt(input);
            for (index = 0; index < 4; ++index) {
                magnitude = value % 3;
                this.style = this.style.concat(Integer.toString(magnitude, 36));
                this.connections.put(directions[index], magnitude);
                value /= 3;
            }
        } else {
            this.style = input;
            char[] chars = new char[directions.length];
            for (index = 0; index < directions.length; ++index) {
                magnitude = Integer.parseInt(this.style.substring(index, index + 1), 36);
                this.connections.put(directions[index], magnitude);
            }
        }
        this.mask = new String();
        for (Map.Direction direction : directions) {
            this.mask = this.mask.concat(this.getConnection(direction) == 0 ? "0" : "1");
        }
    }

    public static TileImprovementStyle getInstance(String key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        TileImprovementStyle result = cache.get(key);
        if (result == null) {
            result = new TileImprovementStyle(key);
            cache.put(key, result);
            if (result.getString() != key) {
                cache.put(result.getString(), result);
            }
        }
        return result;
    }

    public String getString() {
        return this.style;
    }

    public String toString() {
        return this.style;
    }

    public String getMask() {
        return this.mask;
    }

    public Map<Map.Direction, Integer> getConnections() {
        return new EnumMap<Map.Direction, Integer>(this.connections);
    }

    public int getConnection(Map.Direction direction) {
        if (this.connections.containsKey((Object)direction)) {
            return this.connections.get((Object)direction);
        }
        return 0;
    }

    public boolean isConnectedTo(Map.Direction direction) {
        return this.getConnection(direction) > 0;
    }
}

