/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Movable;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unit
extends GoodsLocation
implements Consumer,
Locatable,
Movable,
Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    private static final EquipmentType[] horsesEq = new EquipmentType[]{null, null};
    private static final EquipmentType[] musketsEq = new EquipmentType[]{null, null};
    private static Comparator<Unit> skillLevelComp = new Comparator<Unit>(){

        @Override
        public int compare(Unit u1, Unit u2) {
            return u1.getSkillLevel() - u2.getSkillLevel();
        }
    };
    private static final String EQUIPMENT_TAG = "equipment";
    public static final String CARGO_CHANGE = "CARGO_CHANGE";
    public static final String EQUIPMENT_CHANGE = "EQUIPMENT_CHANGE";
    protected UnitType unitType;
    protected int movesLeft;
    protected UnitState state = UnitState.ACTIVE;
    protected Role role = Role.DEFAULT;
    protected int workLeft;
    protected int hitpoints;
    protected Player owner;
    protected String nationality = null;
    protected String ethnicity = null;
    protected Location entryLocation;
    protected Location location;
    protected IndianSettlement indianSettlement = null;
    protected Location destination = null;
    protected TradeRoute tradeRoute = null;
    protected int currentStop = -1;
    protected int treasureAmount;
    protected TileImprovement workImprovement;
    protected GoodsType workType;
    private GoodsType experienceType;
    protected int experience = 0;
    protected int turnsOfTraining = 0;
    protected int attrition = 0;
    protected String name = null;
    protected int visibleGoodsCount;
    protected Unit student;
    protected Unit teacher;
    protected final TypeCountMap<EquipmentType> equipment = new TypeCountMap();

    protected Unit() {
    }

    protected Unit(Game game) {
        super(game);
    }

    public Unit(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Unit(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Unit(Game game, String id) {
        super(game, id);
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("onBoard").addStringTemplate("%unit%", this.getLabel());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    public final UnitType getType() {
        return this.unitType;
    }

    public boolean canCarryTreasure() {
        return this.unitType.hasAbility("model.ability.carryTreasure");
    }

    public int getTreasureAmount() {
        if (this.canCarryTreasure()) {
            return this.treasureAmount;
        }
        throw new IllegalStateException("Unit can't carry treasure");
    }

    public void setTreasureAmount(int amt) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit can't carry treasure");
        }
        this.treasureAmount = amt;
    }

    public final TypeCountMap<EquipmentType> getEquipment() {
        return this.equipment;
    }

    public void clearEquipment() {
        this.equipment.clear();
    }

    public final TradeRoute getTradeRoute() {
        return this.tradeRoute;
    }

    public final void setTradeRoute(TradeRoute newTradeRoute) {
        this.tradeRoute = newTradeRoute;
    }

    public TradeRoute.Stop getStop() {
        return this.validateCurrentStop() < 0 ? null : this.getTradeRoute().getStops().get(this.currentStop);
    }

    public int getCurrentStop() {
        return this.currentStop;
    }

    public void setCurrentStop(int currentStop) {
        this.currentStop = currentStop;
    }

    public int validateCurrentStop() {
        if (this.tradeRoute == null) {
            this.currentStop = -1;
        } else {
            List<TradeRoute.Stop> stops = this.tradeRoute.getStops();
            if (stops == null || stops.size() == 0) {
                this.currentStop = -1;
            } else if (this.currentStop < 0 || this.currentStop >= stops.size()) {
                this.currentStop = 0;
            }
        }
        return this.currentStop;
    }

    public boolean canCashInTreasureTrain() {
        return this.canCashInTreasureTrain(this.getLocation());
    }

    public boolean canCashInTreasureTrain(Location loc) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Can't carry treasure");
        }
        if (loc == null) {
            return false;
        }
        if (this.getOwner().getEurope() == null) {
            return loc.getColony() != null;
        }
        if (loc.getColony() != null) {
            return loc.getColony().isConnectedPort();
        }
        return loc instanceof Europe || loc instanceof Unit && ((Unit)loc).isInEurope();
    }

    public int getTransportFee() {
        if (!this.isInEurope() && this.getOwner().getEurope() != null) {
            float fee = this.getSpecification().getInteger("model.option.treasureTransportFee") * this.getTreasureAmount() / 100;
            return (int)this.getOwner().applyModifier(fee, "model.modifier.treasureTransportFee", this.unitType, this.getGame().getTurn());
        }
        return 0;
    }

    public boolean isTradingUnit() {
        return this.canCarryGoods() && this.owner.isEuropean();
    }

    public boolean isColonist() {
        return this.unitType.hasAbility("model.ability.foundColony") && this.owner.isEuropean();
    }

    public boolean isOffensiveUnit() {
        return this.unitType.isOffensive() || this.isArmed() || this.isMounted();
    }

    public int getNeededTurnsOfTraining() {
        int result = 0;
        if (this.student != null) {
            result = this.getNeededTurnsOfTraining(this.unitType, this.student.unitType);
            if (this.getColony() != null) {
                result -= this.getColony().getProductionBonus();
            }
        }
        return result;
    }

    public int getNeededTurnsOfTraining(UnitType typeTeacher, UnitType typeStudent) {
        UnitType teaching = Unit.getUnitTypeTeaching(typeTeacher, typeStudent);
        if (teaching != null) {
            return typeStudent.getEducationTurns(teaching);
        }
        throw new IllegalStateException("typeTeacher=" + typeTeacher + " typeStudent=" + typeStudent);
    }

    public static UnitType getUnitTypeTeaching(UnitType typeTeacher, UnitType typeStudent) {
        UnitType skillTaught = typeTeacher.getSkillTaught();
        if (typeStudent.canBeUpgraded(skillTaught, UnitTypeChange.ChangeType.EDUCATION)) {
            return skillTaught;
        }
        return typeStudent.getEducationUnit(0);
    }

    public int getSkillLevel() {
        return Unit.getSkillLevel(this.unitType);
    }

    public static int getSkillLevel(UnitType unitType) {
        if (unitType.hasSkill()) {
            return unitType.getSkill();
        }
        return 0;
    }

    public static Comparator<Unit> getSkillLevelComparator() {
        return skillLevelComp;
    }

    public int getTurnsOfTraining() {
        return this.turnsOfTraining;
    }

    public void setTurnsOfTraining(int turnsOfTraining) {
        this.turnsOfTraining = turnsOfTraining;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = Math.min(experience, this.getType().getMaximumExperience());
    }

    public void modifyExperience(int value) {
        this.experience += value;
    }

    public int getAttrition() {
        return this.attrition;
    }

    public void setAttrition(int attrition) {
        this.attrition = attrition;
    }

    @Override
    public boolean hasAbility(String id, FreeColGameObjectType fcgot, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        HashSet<Ability> result = new HashSet<Ability>();
        result.addAll(this.unitType.getAbilitySet(id));
        result.addAll(this.getOwner().getAbilitySet(id, this.unitType, turn));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getAbilitySet(id));
            result.addAll(this.getOwner().getAbilitySet(id, equipmentType, turn));
        }
        if (this.getSettlement() != null) {
            result.addAll(this.getSettlement().getAbilitySet(id, this.unitType, turn));
        } else if (this.isInEurope()) {
            result.addAll(this.getOwner().getEurope().getAbilitySet(id, this.unitType, turn));
        }
        return FeatureContainer.hasAbility(result);
    }

    @Override
    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType fcgot, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.unitType.getModifierSet(id));
        result.addAll(this.getOwner().getModifierSet(id, this.unitType, turn));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getModifierSet(id));
            result.addAll(this.getOwner().getModifierSet(id, equipmentType, turn));
        }
        return result;
    }

    public Set<Modifier> getModifierSet(String id, Ownable ownable) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        Turn turn = this.getGame().getTurn();
        NationType nationType = ownable.getOwner().getNationType();
        result.addAll(this.unitType.getModifierSet(id, nationType, turn));
        result.addAll(this.getOwner().getModifierSet(id, nationType, turn));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getModifierSet(id, nationType, turn));
        }
        return result;
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException("Can not add Feature to Unit directly!");
    }

    public boolean canBeStudent(Unit teacher) {
        return teacher != this && this.canBeStudent(this.unitType, teacher.unitType);
    }

    public boolean canBeStudent(UnitType typeStudent, UnitType typeTeacher) {
        return Unit.getUnitTypeTeaching(typeTeacher, typeStudent) != null;
    }

    public final Unit getStudent() {
        return this.student;
    }

    public final void setStudent(Unit newStudent) {
        Unit oldStudent = this.student;
        if (oldStudent == newStudent) {
            return;
        }
        if (newStudent == null) {
            this.student = null;
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
        } else if (newStudent.getColony() != null && newStudent.getColony() == this.getColony() && newStudent.canBeStudent(this)) {
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
            this.student = newStudent;
            newStudent.setTeacher(this);
        } else {
            throw new IllegalStateException("unit can not be student: " + newStudent);
        }
    }

    public final Unit getTeacher() {
        return this.teacher;
    }

    public final void setTeacher(Unit newTeacher) {
        Unit oldTeacher = this.teacher;
        if (newTeacher == oldTeacher) {
            return;
        }
        if (newTeacher == null) {
            this.teacher = null;
            if (oldTeacher != null && oldTeacher.getStudent() == this) {
                oldTeacher.setStudent(null);
            }
        } else {
            UnitType skillTaught = newTeacher.getType().getSkillTaught();
            if (newTeacher.getColony() != null && newTeacher.getColony() == this.getColony() && this.getColony().canTrain(skillTaught)) {
                if (oldTeacher != null && oldTeacher.getStudent() == this) {
                    oldTeacher.setStudent(null);
                }
                this.teacher = newTeacher;
                this.teacher.setStudent(this);
            } else {
                throw new IllegalStateException("unit can not be teacher: " + newTeacher);
            }
        }
    }

    public StringTemplate getAbandonEducationMessage(boolean checkStudent) {
        boolean student;
        if (!(this.getLocation() instanceof WorkLocation)) {
            return null;
        }
        boolean teacher = this.getStudent() != null;
        boolean bl = student = checkStudent && this.getTeacher() != null;
        if (!teacher && !student) {
            return null;
        }
        Building school = (Building)(teacher ? this.getLocation() : this.getTeacher().getLocation());
        String action = teacher ? Messages.message("abandonEducation.action.teaching") : Messages.message("abandonEducation.action.studying");
        return StringTemplate.template("abandonEducation.text").addStringTemplate("%unit%", Messages.getLabel(this)).addName("%colony%", this.getColony().getName()).add("%building%", school.getNameKey()).addName("%action%", action);
    }

    public Building getWorkLocation() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public Location getWorkLocation2() {
        if (this.getLocation() instanceof Building) {
            return this.getLocation();
        }
        if (this.getLocation() instanceof ColonyTile) {
            return this.getLocation();
        }
        return null;
    }

    public Building getWorkBuilding() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public ColonyTile getWorkTile() {
        if (this.getLocation() instanceof ColonyTile) {
            return (ColonyTile)this.getLocation();
        }
        return null;
    }

    public GoodsType getExperienceType() {
        return this.experienceType;
    }

    public GoodsType getWorkType() {
        return this.workType;
    }

    public void setWorkType(GoodsType type) {
        this.workType = type;
        if (type != null) {
            this.experienceType = type;
        }
    }

    public TileImprovement getWorkImprovement() {
        return this.workImprovement;
    }

    public void setWorkImprovement(TileImprovement imp) {
        this.workImprovement = imp;
    }

    public Location getDestination() {
        return this.destination;
    }

    public void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public Tile getPathStartTile() {
        if (this.isOnCarrier()) {
            Unit carrier = this.getCarrier();
            return carrier.getTile() != null ? carrier.getTile() : (carrier.getDestination() instanceof Map ? carrier.getFullEntryLocation() : (carrier.getDestination() instanceof Settlement ? ((Settlement)carrier.getDestination()).getTile() : null));
        }
        return this.getTile();
    }

    public boolean shouldTakeTransportTo(Location loc) {
        PathNode path;
        return loc != null && !this.isNaval() && !this.isAtLocation(loc) && ((path = this.findPath(this.getLocation(), loc, this.getCarrier(), null)) == null || path.usesCarrier());
    }

    public PathNode findPath(Location end) {
        return this.findPath(this.getLocation(), end, null, null);
    }

    public PathNode findPath(Location start, Location end, Unit carrier, CostDecider costDecider) {
        return this.getGame().getMap().findPath(this, start, end, carrier, costDecider);
    }

    public int getTurnsToReach(Location end) {
        return this.getTurnsToReach(this.getLocation(), end);
    }

    public int getTurnsToReach(Location start, Location end) {
        return this.getTurnsToReach(start, end, this.getCarrier(), CostDeciders.avoidSettlementsAndBlockingUnits());
    }

    public int getTurnsToReach(Location start, Location end, Unit carrier, CostDecider costDecider) {
        PathNode path = this.findPath(start, end, carrier, costDecider);
        return path == null ? Integer.MAX_VALUE : path.getTotalTurns();
    }

    public PathNode findOurNearestSettlement(final boolean excludeStart, int range, final boolean coastal) {
        final Player player = this.getOwner();
        if (player.getNumberOfSettlements() <= 0 || this.getTile() == null) {
            return null;
        }
        final Tile startTile = this.getTile();
        GoalDecider gd = new GoalDecider(){
            private int bestValue = Integer.MAX_VALUE;
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value;
                Tile t = path.getTile();
                if (t == null || t == startTile && excludeStart) {
                    return false;
                }
                Settlement settlement = t.getSettlement();
                if (settlement != null && settlement.getOwner() == player && (!coastal || settlement.isConnectedPort()) && (value = path.getTotalTurns()) < this.bestValue) {
                    this.bestValue = value;
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
        return this.search(startTile, gd, CostDeciders.avoidIllegal(), range, null);
    }

    public PathNode findOurNearestSettlement() {
        return this.findOurNearestSettlement(false, Integer.MAX_VALUE, false);
    }

    public PathNode findOurNearestPort() {
        PathNode sPath;
        int sTurns;
        PathNode ePath = null;
        int eTurns = -1;
        Europe europe = this.getOwner().getEurope();
        if (this.getType().canMoveToHighSeas()) {
            ePath = europe == null ? null : this.findPath(europe);
            eTurns = ePath == null ? -1 : ePath.getTotalTurns();
        }
        int n = sTurns = (sPath = this.findOurNearestSettlement(false, Integer.MAX_VALUE, true)) == null ? -1 : sPath.getTotalTurns();
        return ePath == null ? sPath : (sPath == null ? ePath : (sTurns <= eTurns ? sPath : ePath));
    }

    public PathNode findOurNearestOtherSettlement() {
        return this.findOurNearestSettlement(true, Integer.MAX_VALUE, false);
    }

    public PathNode search(Location start, GoalDecider gd, CostDecider cd, int maxTurns, Unit carrier) {
        return this.getGame().getMap().search(this, start, gd, cd, maxTurns, carrier);
    }

    public boolean canAttack(Unit defender) {
        if (!this.isOffensiveUnit() || defender == null || defender.getTile() == null) {
            return false;
        }
        Tile tile = defender.getTile();
        return this.isNaval() ? tile.getSettlement() == null && defender.isNaval() : !defender.isNaval() || defender.isBeached();
    }

    public PathNode searchForDanger(final int range, final float threat) {
        final CombatModel cm = this.getGame().getCombatModel();
        final Tile start = this.getTile();
        GoalDecider threatDecider = new GoalDecider(){
            private PathNode found = null;

            public PathNode getGoal() {
                return this.found;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit unit, PathNode path) {
                Tile tile = path.getTile();
                if (tile == null) {
                    return false;
                }
                Unit first = tile.getFirstUnit();
                if (first == null || !Unit.this.getOwner().atWarWith(first.getOwner())) {
                    return false;
                }
                for (Unit u : tile.getUnitList()) {
                    PathNode reverse;
                    if (!u.canAttack(unit) || !(cm.calculateCombatOdds((FreeColGameObject)u, (FreeColGameObject)unit).win >= threat) || (reverse = u.findPath(start)) == null || reverse.getTotalTurns() >= range) continue;
                    this.found = path;
                    return true;
                }
                return false;
            }
        };
        int reverseRange = range * (this.isNaval() ? this.getSpecification().getFastestNavalUnitType() : this.getSpecification().getFastestLandUnitType()).getMovement() / this.getType().getMovement();
        return start == null ? null : this.search(start, threatDecider, CostDeciders.avoidIllegal(), reverseRange, this.getCarrier());
    }

    public boolean isInDanger(int range, float threat) {
        return this.searchForDanger(range, threat) != null;
    }

    public boolean isTileAccessible(Tile tile) {
        return this.isNaval() ? !tile.isLand() || tile.getSettlement() != null && this.getOwner() == tile.getSettlement().getOwner() : tile.isLand();
    }

    public int getMoveCost(Tile target) {
        return this.getMoveCost(this.getTile(), target, this.getMovesLeft());
    }

    public int getMoveCost(Tile from, Tile target, int ml) {
        TileItemContainer container;
        int cost = target.getType().getBasicMoveCost();
        if (target.isLand() && (container = target.getTileItemContainer()) != null) {
            cost = container.getMoveCost(from, target, cost);
        }
        if (this.isBeached(from)) {
            cost = ml;
        } else if (cost > ml && (ml + 2 >= this.getInitialMovesLeft() || cost <= ml + 2 || target.getSettlement() != null) && ml != 0) {
            cost = ml;
        }
        return cost;
    }

    public MoveType getMoveType(Map.Direction direction) {
        Tile tile = this.getTile();
        if (tile == null) {
            return MoveType.MOVE_NO_TILE;
        }
        Tile target = tile.getNeighbourOrNull(direction);
        if (target == null) {
            return MoveType.MOVE_ILLEGAL;
        }
        return this.getMoveType(target);
    }

    public MoveType getMoveType(Tile target) {
        Tile tile = this.getTile();
        if (tile == null) {
            return MoveType.MOVE_NO_TILE;
        }
        return this.getMoveType(tile, target, this.getMovesLeft());
    }

    public MoveType getMoveType(Tile from, Tile target, int ml) {
        MoveType move = this.getSimpleMoveType(from, target);
        if (move.isLegal()) {
            switch (move) {
                case ATTACK_UNIT: 
                case ATTACK_SETTLEMENT: {
                    if (ml > 0) break;
                    move = MoveType.MOVE_NO_MOVES;
                    break;
                }
                default: {
                    if (ml > 0 && (from == null || this.getMoveCost(from, target, ml) <= ml)) break;
                    move = MoveType.MOVE_NO_MOVES;
                }
            }
        }
        return move;
    }

    public MoveType getSimpleMoveType(Tile from, Tile target) {
        return this.isNaval() ? this.getNavalMoveType(from, target) : this.getLandMoveType(from, target);
    }

    public MoveType getSimpleMoveType(Tile target) {
        Tile tile = this.getTile();
        if (tile == null) {
            return MoveType.MOVE_NO_TILE;
        }
        return this.getSimpleMoveType(tile, target);
    }

    public MoveType getSimpleMoveType(Map.Direction direction) {
        Tile tile = this.getTile();
        if (tile == null) {
            return MoveType.MOVE_NO_TILE;
        }
        Tile target = tile.getNeighbourOrNull(direction);
        return this.getSimpleMoveType(tile, target);
    }

    private MoveType getNavalMoveType(Tile from, Tile target) {
        if (target == null) {
            return this.getOwner().canMoveToEurope() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE_NO_EUROPE;
        }
        if (this.isUnderRepair()) {
            return MoveType.MOVE_NO_REPAIR;
        }
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                return MoveType.MOVE_NO_ACCESS_LAND;
            }
            if (settlement.getOwner() == this.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        Unit defender = target.getFirstUnit();
        if (defender != null && !this.getOwner().owns(defender)) {
            return this.isOffensiveUnit() ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_CIVILIAN;
        }
        return target.isDirectlyHighSeasConnected() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE;
    }

    private MoveType getLandMoveType(Tile from, Tile target) {
        if (target == null) {
            return MoveType.MOVE_ILLEGAL;
        }
        Player owner = this.getOwner();
        Unit defender = target.getFirstUnit();
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                if (defender != null && owner != defender.getOwner()) {
                    if (defender.isNaval()) {
                        return MoveType.ATTACK_UNIT;
                    }
                    if (!this.isOffensiveUnit()) {
                        return MoveType.MOVE_NO_ATTACK_CIVILIAN;
                    }
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (target.hasLostCityRumour() && owner.isEuropean()) {
                    return MoveType.EXPLORE_LOST_CITY_RUMOUR;
                }
                return MoveType.MOVE;
            }
            if (owner == settlement.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            if (this.isColonist()) {
                switch (this.getRole()) {
                    case DEFAULT: 
                    case PIONEER: {
                        return this.getLearnMoveType(from, settlement);
                    }
                    case MISSIONARY: {
                        return this.getMissionaryMoveType(from, settlement);
                    }
                    case SCOUT: {
                        return this.getScoutMoveType(from, settlement);
                    }
                    case SOLDIER: 
                    case DRAGOON: {
                        return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
                    }
                }
                return MoveType.MOVE_ILLEGAL;
            }
            if (this.isOffensiveUnit()) {
                return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (defender == null || !this.getOwner().owns(defender)) {
            return MoveType.MOVE_NO_ACCESS_EMBARK;
        }
        for (Unit u : target.getUnitList()) {
            if (!u.canAdd(this)) continue;
            return MoveType.EMBARK;
        }
        return MoveType.MOVE_NO_ACCESS_FULL;
    }

    private MoveType getTradeMoveType(Settlement settlement) {
        if (settlement instanceof Colony) {
            return this.getOwner().atWarWith(settlement.getOwner()) ? MoveType.MOVE_NO_ACCESS_WAR : (!this.hasAbility("model.ability.tradeWithForeignColonies") ? MoveType.MOVE_NO_ACCESS_TRADE : MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS);
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (this.hasGoodsCargo() || this.getSpecification().getBoolean("model.option.emptyTraders") ? MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS : MoveType.MOVE_NO_ACCESS_GOODS);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getLearnMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            UnitType scoutSkill = this.getSpecification().getUnitType("model.unit.seasonedScout");
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (!this.getType().canBeUpgraded(null, UnitTypeChange.ChangeType.NATIVES) ? MoveType.MOVE_NO_ACCESS_SKILL : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getMissionaryMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getScoutMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT;
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private boolean allowMoveFrom(Tile from) {
        return from.isLand() || !this.getOwner().isREF() && this.getSpecification().getBoolean("model.option.amphibiousMoves");
    }

    private boolean allowContact(Settlement settlement) {
        return this.getOwner().hasContacted(settlement.getOwner());
    }

    @Override
    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int movesLeft) {
        if (movesLeft < 0) {
            movesLeft = 0;
        }
        this.movesLeft = movesLeft;
    }

    public int getLineOfSight() {
        Turn turn = this.getGame().getTurn();
        HashSet<Modifier> modifierSet = new HashSet<Modifier>();
        modifierSet.addAll(this.getModifierSet("model.modifier.lineOfSightBonus"));
        if (this.getTile() != null && this.getTile().getType() != null) {
            modifierSet.addAll(this.getTile().getType().getModifierSet("model.modifier.lineOfSightBonus", this.unitType, turn));
        }
        return (int)FeatureContainer.applyModifierSet(this.unitType.getLineOfSight(), turn, modifierSet);
    }

    public boolean isOnCarrier() {
        return this.getLocation() instanceof Unit;
    }

    public Unit getCarrier() {
        return this.isOnCarrier() ? (Unit)this.getLocation() : null;
    }

    public void setStateToAllChildren(UnitState state) {
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                u.setState(state);
            }
        }
    }

    private void spendAllMoves() {
        if (this.getColony() != null && this.getMovesLeft() < this.getInitialMovesLeft()) {
            this.setMovesLeft(0);
        }
    }

    public boolean couldMove() {
        return !this.isDisposed() && this.getState() == UnitState.ACTIVE && this.getMovesLeft() > 0 && this.destination == null && this.tradeRoute == null && !this.isUnderRepair() && !this.isAtSea() && !this.isOnCarrier() && !(this.location instanceof WorkLocation);
    }

    public Location getRepairLocation() {
        Player player = this.getOwner();
        Tile tile = this.getTile();
        UnitLocation bestLocation = null;
        int bestTurns = Integer.MAX_VALUE;
        for (Colony colony : player.getColonies()) {
            int turns;
            if (colony == null || colony == tile.getColony() || !colony.hasAbility("model.ability.repairUnits") || (turns = this.getTurnsToReach(colony)) < 0 || turns >= bestTurns) continue;
            bestTurns = turns;
            bestLocation = colony;
        }
        if (bestLocation == null) {
            bestLocation = player.getEurope();
        }
        return bestLocation;
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean couldCarry(Unit u) {
        return this.canCarryUnits() && this.getCargoCapacity() >= u.getSpaceTaken();
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public boolean couldCarry(Goods g) {
        return this.canCarryGoods() && this.getCargoCapacity() >= g.getSpaceTaken();
    }

    public int getSpaceLeft() {
        return this.getCargoCapacity() - this.getCargoSpaceTaken();
    }

    public boolean hasSpaceLeft() {
        return this.getSpaceLeft() > 0;
    }

    @Override
    public int getSpaceTaken() {
        return this.unitType.getSpaceTaken();
    }

    public int getCargoCapacity() {
        return this.unitType.getSpace();
    }

    public int getGoodsSpaceTaken() {
        if (!this.canCarryGoods()) {
            return 0;
        }
        GoodsContainer gc = this.getGoodsContainer();
        return gc == null ? 0 : gc.getSpaceTaken();
    }

    public int getUnitSpaceTaken() {
        int space = 0;
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                space += u.getSpaceTaken();
            }
        }
        return space;
    }

    public int getCargoSpaceTaken() {
        return this.getGoodsSpaceTaken() + this.getUnitSpaceTaken();
    }

    public boolean hasGoodsCargo() {
        return this.getGoodsSpaceTaken() > 0;
    }

    public boolean hasCargo() {
        return this.getCargoSpaceTaken() > 0;
    }

    public int getLoadableAmount(GoodsType type) {
        if (!this.canCarryGoods()) {
            return 0;
        }
        int result = this.getSpaceLeft() * 100;
        int count = this.getGoodsCount(type) % 100;
        if (count != 0) {
            result += 100 - count;
        }
        return result;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable == this) {
            return UnitLocation.NoAddReason.ALREADY_PRESENT;
        }
        if (locatable instanceof Unit) {
            return !this.canCarryUnits() ? UnitLocation.NoAddReason.WRONG_TYPE : (((Unit)locatable).getSpaceTaken() > this.getSpaceLeft() ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : super.getNoAddReason(locatable));
        }
        if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            return !this.canCarryGoods() ? UnitLocation.NoAddReason.WRONG_TYPE : (goods.getAmount() > this.getLoadableAmount(goods.getType()) ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : UnitLocation.NoAddReason.NONE);
        }
        return super.getNoAddReason(locatable);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            return false;
        }
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (super.add(locatable)) {
                this.spendAllMoves();
                ((Unit)locatable).setState(UnitState.SENTRY);
                return true;
            }
        } else if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            if (super.addGoods(goods)) {
                this.spendAllMoves();
                return true;
            }
        } else {
            throw new IllegalStateException("Can not be added to unit: " + ((FreeColGameObject)((Object)locatable)).toString());
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable == null) {
            throw new IllegalArgumentException("Locatable must not be 'null'.");
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            if (super.remove((Unit)locatable)) {
                this.spendAllMoves();
                return true;
            }
        } else if (locatable instanceof Goods && this.canCarryGoods()) {
            if (super.removeGoods((Goods)locatable) != null) {
                this.spendAllMoves();
                return true;
            }
        } else {
            logger.warning("Tried to remove from unit: " + (FreeColGameObject)((Object)locatable));
        }
        return false;
    }

    @Override
    public int getGoodsCapacity() {
        throw new RuntimeException("Do not call this method, unless we implement spoilage.");
    }

    public List<Goods> getGoodsList() {
        if (this.getGoodsContainer() == null) {
            return new ArrayList<Goods>();
        }
        return this.getGoodsContainer().getGoods();
    }

    public boolean isVisibleTo(Player player) {
        Settlement settlement;
        Tile unitTile;
        return player == this.getOwner() ? true : ((unitTile = this.getTile()) == null ? false : (!player.canSee(unitTile) ? false : ((settlement = this.getSettlement()) != null && !player.owns(settlement) ? false : !this.isOnCarrier() || player.owns(this.getCarrier()))));
    }

    public void setLocationNoUpdate(Location newLocation) {
        this.location = newLocation;
    }

    @Override
    public void setLocation(Location newLocation) {
        Colony newColony;
        Colony oldColony = this.location instanceof WorkLocation ? this.getColony() : null;
        Colony colony = newColony = newLocation instanceof WorkLocation ? newLocation.getColony() : null;
        if (oldColony == newColony) {
            newColony = null;
            oldColony = null;
        }
        boolean result = true;
        if (this.location != null) {
            result = oldColony != null ? oldColony.removeUnit(this) : this.location.remove(this);
        }
        this.location = newLocation;
        this.getOwner().setExplored(this);
        if (newLocation instanceof Colony) {
            newColony = (Colony)newLocation;
            this.location = newLocation = newColony.getWorkLocationFor(this);
        }
        if (newLocation != null) {
            result = newColony != null ? newColony.addUnit(this, (WorkLocation)newLocation) : newLocation.add(this);
        }
    }

    public void setIndianSettlement(IndianSettlement indianSettlement) {
        if (this.indianSettlement != null) {
            this.indianSettlement.removeOwnedUnit(this);
        }
        this.indianSettlement = indianSettlement;
        if (indianSettlement != null) {
            indianSettlement.addOwnedUnit(this);
        }
    }

    public IndianSettlement getIndianSettlement() {
        return this.indianSettlement;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean canBeEquippedWith(EquipmentType equipmentType) {
        for (Map.Entry<String, Boolean> entry : equipmentType.getRequiredAbilities().entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        return this.equipment.getCount(equipmentType) < equipmentType.getMaximumCount();
    }

    public List<EquipmentType> changeEquipment(EquipmentType type, int amount) {
        ArrayList<EquipmentType> result = new ArrayList<EquipmentType>();
        this.equipment.incrementCount(type, amount);
        if (amount > 0) {
            for (EquipmentType oldType : new HashSet<EquipmentType>(this.equipment.keySet())) {
                if (oldType.isCompatibleWith(type)) continue;
                result.add(oldType);
            }
        }
        this.setRole();
        return result;
    }

    public int getEquipmentCount(EquipmentType equipmentType) {
        return this.equipment.getCount(equipmentType);
    }

    @Override
    public boolean isInEurope() {
        if (this.location instanceof Unit) {
            return ((Unit)this.location).isInEurope();
        }
        return this.getLocation() instanceof Europe;
    }

    public boolean isAtSea() {
        if (this.location instanceof Unit) {
            return ((Unit)this.location).isAtSea();
        }
        return this.location instanceof HighSeas;
    }

    public boolean isCarrier() {
        return this.unitType.canCarryGoods() || this.unitType.canCarryUnits();
    }

    public boolean isPerson() {
        return this.hasAbility("model.ability.person") || this.hasAbility("model.ability.bornInColony") || this.hasAbility("model.ability.bornInIndianSettlement") || this.hasAbility("model.ability.foundColony");
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    public StringTemplate getApparentOwnerName() {
        return (this.hasAbility("model.ability.piracy") ? this.getGame().getUnknownEnemy() : this.owner).getNationName();
    }

    @Override
    public void setOwner(Player owner) {
        Player oldOwner = this.owner;
        if (oldOwner == owner) {
            return;
        }
        if (oldOwner == null) {
            logger.warning("Unit " + this.getId() + " had no previous owner, when changing owner to " + owner.getId());
        }
        if (this.getTradeRoute() != null) {
            this.setTradeRoute(null);
        }
        if (this.getDestination() != null) {
            this.setDestination(null);
        }
        this.owner = owner;
        for (Unit unit : this.getUnitList()) {
            unit.setOwner(owner);
        }
        if (oldOwner != null) {
            oldOwner.removeUnit(this);
            oldOwner.modifyScore(-this.getType().getScoreValue());
            if (!this.isOnCarrier()) {
                oldOwner.invalidateCanSeeTiles();
            }
        }
        owner.setUnit(this);
        if (this.getType() != null) {
            owner.modifyScore(this.getType().getScoreValue());
        }
        if (!this.isOnCarrier()) {
            this.getOwner().setExplored(this);
        }
        if (this.getGame().getFreeColGameObjectListener() != null) {
            this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, owner);
        }
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String newNationality) {
        if (!this.isPerson()) {
            throw new UnsupportedOperationException("Can not set the nationality of a Unit which is not a person!");
        }
        this.nationality = newNationality;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String newEthnicity) {
        throw new UnsupportedOperationException("Can not change a Unit's ethnicity!");
    }

    public boolean hasNativeEthnicity() {
        try {
            return this.getGame().getSpecification().getNation(this.ethnicity).getType().isIndian();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setType(UnitType newUnitType) {
        if (newUnitType.isAvailableTo(this.owner)) {
            if (this.unitType == null) {
                this.owner.modifyScore(newUnitType.getScoreValue());
            } else {
                this.owner.modifyScore(newUnitType.getScoreValue() - this.unitType.getScoreValue());
            }
            this.unitType = newUnitType;
            if (this.getMovesLeft() > this.getInitialMovesLeft()) {
                this.setMovesLeft(this.getInitialMovesLeft());
            }
            this.hitpoints = this.unitType.getHitPoints();
            if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
                this.getTeacher().setStudent(null);
                this.setTeacher(null);
            }
        } else {
            logger.warning("Units of type: " + newUnitType + " are not available to " + (Object)((Object)this.owner.getPlayerType()) + " player " + this.owner.getName());
        }
    }

    public boolean isArmed() {
        if (musketsEq[0] == null) {
            Specification spec = this.getSpecification();
            Unit.musketsEq[0] = spec.getEquipmentType("model.equipment.muskets");
            Unit.musketsEq[1] = spec.getEquipmentType("model.equipment.indian.muskets");
        }
        for (EquipmentType et : musketsEq) {
            if (this.getEquipmentCount(et) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isMounted() {
        if (horsesEq[0] == null) {
            Specification spec = this.getSpecification();
            Unit.horsesEq[0] = spec.getEquipmentType("model.equipment.horses");
            Unit.horsesEq[1] = spec.getEquipmentType("model.equipment.indian.horses");
        }
        for (EquipmentType et : horsesEq) {
            if (this.getEquipmentCount(et) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public StringTemplate getLabel() {
        Role role;
        StringTemplate result = StringTemplate.label(" ").add(this.getType().getNameKey());
        if (this.name != null) {
            result.addName(this.name);
        }
        if ((role = this.getRole()) != Role.DEFAULT) {
            result = StringTemplate.template("model.unit." + role.getId() + ".name").addAmount("%number%", 1).add("%unit%", this.getType().getNameKey());
        }
        return result;
    }

    public StringTemplate getEquipmentLabel() {
        if (this.equipment.isEmpty()) {
            return null;
        }
        StringTemplate result = StringTemplate.label("/");
        for (Map.Entry<EquipmentType, Integer> entry : this.equipment.getValues().entrySet()) {
            EquipmentType type = entry.getKey();
            int amount = entry.getValue();
            if (!type.needsGoodsToBuild()) {
                result.addStringTemplate(StringTemplate.template("model.goods.goodsAmount").add("%goods%", type.getNameKey()).addName("%amount%", Integer.toString(amount)));
                continue;
            }
            for (AbstractGoods goods : type.getRequiredGoods()) {
                result.addStringTemplate(StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addName("%amount%", Integer.toString(amount * goods.getAmount())));
            }
        }
        return result;
    }

    @Override
    public int getInitialMovesLeft() {
        return (int)FeatureContainer.applyModifierSet(this.unitType.getMovement(), this.getGame().getTurn(), this.getModifierSet("model.modifier.movementBonus"));
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
        if (hitpoints >= this.unitType.getHitPoints()) {
            this.setState(UnitState.ACTIVE);
        }
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isUnderRepair() {
        return this.hitpoints < this.unitType.getHitPoints();
    }

    public boolean isInMission() {
        return this.hasAbility("model.ability.missionary") && (this.getLocation() instanceof IndianSettlement || this.getLocation() == null);
    }

    public String getMovesAsString() {
        String moves = "";
        int quotient = this.getMovesLeft() / 3;
        int remainder = this.getMovesLeft() % 3;
        if (remainder == 0 || quotient > 0) {
            moves = moves + Integer.toString(quotient);
        }
        if (remainder > 0) {
            if (quotient > 0) {
                moves = moves + " ";
            }
            moves = moves + "(" + Integer.toString(remainder) + "/3) ";
        }
        moves = moves + "/" + Integer.toString(this.getInitialMovesLeft() / 3);
        return moves;
    }

    public boolean isNaval() {
        return this.getType().isNaval();
    }

    public UnitState getState() {
        return this.state;
    }

    public String getOccupationKey(boolean owner) {
        return owner ? (this.isUnderRepair() ? "model.unit.occupation.underRepair" : (this.getTradeRoute() != null ? "model.unit.occupation.inTradeRoute" : (this.getDestination() != null ? "model.unit.occupation.goingSomewhere" : (this.getState() == UnitState.IMPROVING && this.getWorkImprovement() != null ? this.getWorkImprovement().getType().getId() + ".occupationString" : (this.getState() == UnitState.ACTIVE && this.getMovesLeft() <= 0 ? "model.unit.occupation.activeNoMovesLeft" : "model.unit.occupation." + this.getState().toString().toLowerCase(Locale.US)))))) : (this.isNaval() ? Integer.toString(this.getVisibleGoodsCount()) : "model.unit.occupation.activeNoMovesLeft");
    }

    public Role getRole() {
        return this.role;
    }

    protected void setRole() {
        Role oldRole = this.role;
        this.role = Role.DEFAULT;
        for (EquipmentType type : this.equipment.keySet()) {
            this.role = this.role.newRole(type.getRole());
        }
        if (this.getState() == UnitState.IMPROVING && !this.hasAbility("model.ability.improveTerrain")) {
            this.setStateUnchecked(UnitState.ACTIVE);
            this.setMovesLeft(0);
        }
        if (!this.role.isCompatibleWith(oldRole)) {
            this.experience = 0;
        }
    }

    public boolean checkSetState(UnitState s) {
        switch (s) {
            case ACTIVE: 
            case SENTRY: {
                return true;
            }
            case IN_COLONY: {
                return !this.isNaval();
            }
            case FORTIFIED: {
                return this.getState() == UnitState.FORTIFYING;
            }
            case IMPROVING: {
                return this.location instanceof Tile && this.getOwner().canAcquireForImprovement(this.location.getTile());
            }
            case SKIPPED: {
                if (this.getState() == UnitState.ACTIVE) {
                    return true;
                }
            }
            case FORTIFYING: {
                return this.getMovesLeft() > 0;
            }
        }
        logger.warning("Invalid unit state: " + (Object)((Object)s));
        return false;
    }

    public int getSailTurns() {
        float base = this.getSpecification().getInteger("model.option.turnsToSail");
        return (int)this.getOwner().applyModifier(base, "model.modifier.sailHighSeas", this.unitType, this.getGame().getTurn());
    }

    public void setState(UnitState s) {
        if (this.state == s) {
            return;
        }
        if (!this.checkSetState(s)) {
            throw new IllegalStateException("Illegal UnitState transition: " + (Object)((Object)this.state) + " -> " + (Object)((Object)s));
        }
        this.setStateUnchecked(s);
    }

    protected void setStateUnchecked(UnitState s) {
        switch (this.state) {
            case IMPROVING: {
                if (this.workImprovement == null || this.getWorkLeft() <= 0) break;
                if (!this.workImprovement.isComplete() && this.workImprovement.getTile() != null && this.workImprovement.getTile().getTileItemContainer() != null) {
                    this.workImprovement.getTile().getTileItemContainer().removeTileItem(this.workImprovement);
                }
                this.setWorkImprovement(null);
                break;
            }
        }
        switch (s) {
            case ACTIVE: {
                this.setWorkLeft(-1);
                break;
            }
            case SENTRY: {
                this.setWorkLeft(-1);
                break;
            }
            case FORTIFIED: {
                this.setWorkLeft(-1);
                this.movesLeft = 0;
                break;
            }
            case FORTIFYING: {
                this.setWorkLeft(1);
                this.movesLeft = 0;
                break;
            }
            case IMPROVING: {
                if (this.workImprovement == null) {
                    this.setWorkLeft(-1);
                } else {
                    this.setWorkLeft(this.workImprovement.getTurnsToComplete() + (this.getMovesLeft() > 0 ? 0 : 1));
                }
                this.movesLeft = 0;
                break;
            }
            case SKIPPED: {
                break;
            }
            default: {
                this.setWorkLeft(-1);
            }
        }
        this.state = s;
    }

    public boolean canMoveToHighSeas() {
        if (this.isInEurope() || this.isAtSea()) {
            return true;
        }
        if (!this.getOwner().canMoveToEurope() || !this.getType().canMoveToHighSeas()) {
            return false;
        }
        return this.getTile().isDirectlyHighSeasConnected();
    }

    public boolean hasHighSeasMove() {
        if (this.canMoveToHighSeas()) {
            return true;
        }
        Tile tile = this.getTile();
        if (tile != null && this.getMovesLeft() > 0) {
            for (Tile t : tile.getSurroundingTiles(1)) {
                if (!t.isDirectlyHighSeasConnected() || !this.getMoveType(t).isLegal()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canBuildColony() {
        return this.unitType.canBuildColony() && this.getMovesLeft() > 0 && this.getTile() != null;
    }

    @Override
    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    public boolean isAtLocation(Location loc) {
        Location ourLoc = this.getLocation();
        if (ourLoc instanceof Unit) {
            ourLoc = ((Unit)ourLoc).getLocation();
        }
        return Map.isSameLocation(ourLoc, loc);
    }

    public int getVisibleGoodsCount() {
        return this.visibleGoodsCount >= 0 ? this.visibleGoodsCount : this.getGoodsSpaceTaken();
    }

    public int getWorkLeft() {
        return this.workLeft;
    }

    public void setWorkLeft(int workLeft) {
        this.workLeft = workLeft;
    }

    public int getWorkTurnsLeft() {
        return this.state == UnitState.IMPROVING && this.unitType.hasAbility("model.ability.expertPioneer") ? (this.getWorkLeft() + 1) / 2 : this.getWorkLeft();
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
        if (entryLocation != null) {
            this.owner.setEntryLocation(entryLocation);
        }
    }

    public Location getEntryLocation() {
        if (this.entryLocation == null) {
            this.entryLocation = this.owner.getEntryLocation();
        }
        return this.entryLocation;
    }

    public Tile getFullEntryLocation() {
        return this.entryLocation != null ? (Tile)this.entryLocation : (this.owner.getEntryLocation() == null ? null : this.owner.getEntryLocation().getTile());
    }

    public Tile getBestEntryTile(Tile tile) {
        return this.getGame().getMap().getBestEntryTile(this, tile, null, null);
    }

    public Location resolveDestination() {
        Tile best;
        Location dst;
        if (!this.isAtSea()) {
            throw new IllegalArgumentException("Not at sea.");
        }
        TradeRoute.Stop stop = this.getStop();
        Location location = dst = stop != null && TradeRoute.isStopValid(this, stop) ? stop.getLocation() : this.getDestination();
        return dst == null ? this.getFullEntryLocation() : (dst instanceof Europe ? dst : (dst.getTile() != null && (best = this.getBestEntryTile(dst.getTile())) != null ? best : this.getFullEntryLocation()));
    }

    public boolean isBeached() {
        return this.isBeached(this.getTile());
    }

    public boolean isBeached(Tile tile) {
        return this.isNaval() && tile != null && tile.isLand() && tile.getSettlement() == null;
    }

    public boolean isDefensiveUnit() {
        return (this.unitType.isDefensive() || this.isArmed() || this.isMounted()) && !this.isNaval();
    }

    public static boolean betterDefender(Unit defender, float defenderPower, Unit other, float otherPower) {
        if (defender == null) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && !defender.isArmed() && other.isArmed()) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && defender.isArmed() && !other.isArmed()) {
            return false;
        }
        if (!defender.isDefensiveUnit() && other.isDefensiveUnit()) {
            return true;
        }
        if (defender.isDefensiveUnit() && !other.isDefensiveUnit()) {
            return false;
        }
        return defenderPower < otherPower;
    }

    public boolean isUndead() {
        return this.hasAbility("model.ability.undead");
    }

    public boolean canCaptureGoods() {
        return this.unitType.hasAbility("model.ability.captureGoods");
    }

    public EquipmentType canCaptureEquipment(EquipmentType equip, Unit loser) {
        if (this.hasAbility("model.ability.captureEquipment")) {
            if (this.getOwner().isIndian() != loser.getOwner().isIndian()) {
                equip = equip.getCaptureEquipment(this.getOwner().isIndian());
            }
            return this.canBeEquippedWith(equip) ? equip : null;
        }
        return null;
    }

    @Override
    public Settlement getSettlement() {
        Location location = this.getLocation();
        return location != null ? location.getSettlement() : null;
    }

    @Override
    public Colony getColony() {
        Location location = this.getLocation();
        return location != null ? location.getColony() : null;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.location != null) {
            this.location.remove(this);
        }
        if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.student != null) {
            this.student.setTeacher(null);
            this.student = null;
        }
        this.setIndianSettlement(null);
        this.getOwner().invalidateCanSeeTiles();
        this.getOwner().removeUnit(this);
        objects.addAll(super.disposeList());
        return objects;
    }

    public int getTurnsForRepair() {
        return this.unitType.getHitPoints() - this.getHitpoints();
    }

    public TypeCountMap<EquipmentType> getAutomaticEquipment() {
        if (this.isArmed()) {
            return null;
        }
        if (!this.getOwner().hasAbility("model.ability.automaticEquipment")) {
            return null;
        }
        Settlement settlement = null;
        if (this.getLocation() instanceof WorkLocation) {
            settlement = this.getColony();
        }
        if (this.getLocation() instanceof IndianSettlement) {
            settlement = (Settlement)this.getLocation();
        }
        if (settlement == null) {
            return null;
        }
        TypeCountMap<EquipmentType> equipmentList = null;
        HashSet<Ability> autoDefence = new HashSet<Ability>();
        autoDefence.addAll(this.getOwner().getAbilitySet("model.ability.automaticEquipment"));
        for (EquipmentType equipment : this.getSpecification().getEquipmentTypeList()) {
            for (Ability ability : autoDefence) {
                if (!ability.appliesTo(equipment) || !this.canBeEquippedWith(equipment)) continue;
                boolean hasReqGoods = true;
                for (AbstractGoods ag : equipment.getRequiredGoods()) {
                    if (settlement.getGoodsCount(ag.getType()) >= ag.getAmount()) continue;
                    hasReqGoods = false;
                    break;
                }
                if (!hasReqGoods) continue;
                if (equipmentList == null) {
                    equipmentList = new TypeCountMap<EquipmentType>();
                }
                equipmentList.incrementCount(equipment, 1);
            }
        }
        return equipmentList;
    }

    public boolean losingEquipmentKillsUnit(EquipmentType lose) {
        if (this.hasAbility("model.ability.disposeOnAllEquipLost")) {
            for (EquipmentType equip : this.getEquipment().keySet()) {
                if (equip == lose) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean losingEquipmentDemotesUnit(EquipmentType lose) {
        if (this.hasAbility("model.ability.demoteOnAllEquipLost")) {
            for (EquipmentType equip : this.getEquipment().keySet()) {
                if (equip == lose) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public float getConvertProbability() {
        Specification spec = this.getSpecification();
        int opt = spec.getInteger("model.option.nativeConvertProbability");
        return 0.01f * FeatureContainer.applyModifierSet(opt, this.getGame().getTurn(), this.getModifierSet("model.modifier.nativeConvertBonus"));
    }

    public float getBurnProbability() {
        Specification spec = this.getSpecification();
        return 0.01f * (float)spec.getInteger("model.option.burnProbability");
    }

    public UnitType getTypeChange(UnitTypeChange.ChangeType change, Player owner) {
        return this.getType().getTargetType(change, owner);
    }

    public EquipmentType getBestCombatEquipmentType(TypeCountMap<EquipmentType> equipment) {
        EquipmentType lose = null;
        if (equipment != null) {
            int priority = -1;
            for (EquipmentType equipmentType : equipment.keySet()) {
                if (equipmentType.getCombatLossPriority() <= priority) continue;
                lose = equipmentType;
                priority = equipmentType.getCombatLossPriority();
            }
        }
        return lose;
    }

    public Tile getNeighbourTile(String directionString) {
        if (this.getTile() == null) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, directionString);
        Tile tile = this.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            throw new IllegalStateException("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.getId());
        }
        return tile;
    }

    public Settlement getAdjacentSettlementSafely(String settlementId) throws IllegalStateException {
        Game game = this.getOwner().getGame();
        Settlement settlement = game.getFreeColGameObject(settlementId, Settlement.class);
        if (settlement == null) {
            throw new IllegalStateException("Not a settlement: " + settlementId);
        }
        if (settlement.getTile() == null) {
            throw new IllegalStateException("Settlement is not on the map: " + settlementId);
        }
        if (this.getTile() == null) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        if (this.getTile().getDistanceTo(settlement.getTile()) > 1) {
            throw new IllegalStateException("Unit " + this.getId() + " is not adjacent to settlement: " + settlementId);
        }
        if (this.getOwner() == settlement.getOwner()) {
            throw new IllegalStateException("Unit: " + this.getId() + " and settlement: " + settlementId + " are both owned by player: " + this.getOwner().getId());
        }
        return settlement;
    }

    public IndianSettlement getAdjacentIndianSettlementSafely(String id) throws IllegalStateException {
        Settlement settlement = this.getAdjacentSettlementSafely(id);
        if (!(settlement instanceof IndianSettlement)) {
            throw new IllegalStateException("Not an indianSettlement: " + id);
        }
        if (!this.getOwner().hasContacted(settlement.getOwner())) {
            throw new IllegalStateException("Player has not contacted the " + settlement.getOwner().getNation());
        }
        return (IndianSettlement)settlement;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.unitType.getConsumedGoods();
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        result.setConsumption(this.getType().getConsumedGoods());
        result.setMaximumConsumption(this.getType().getConsumedGoods());
        return result;
    }

    @Override
    public int getPriority() {
        return this.unitType.getPriority();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        boolean full = showAll || toSavedGame || player == this.getOwner();
        out.writeStartElement(Unit.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (this.name != null) {
            out.writeAttribute("name", this.name);
        }
        out.writeAttribute("unitType", this.unitType.getId());
        out.writeAttribute("movesLeft", Integer.toString(this.movesLeft));
        out.writeAttribute("state", this.state.toString());
        out.writeAttribute("role", this.role.toString());
        if (!full && this.hasAbility("model.ability.piracy")) {
            out.writeAttribute("owner", this.getGame().getUnknownEnemy().getId());
        } else {
            out.writeAttribute("owner", this.getOwner().getId());
            if (this.isPerson()) {
                out.writeAttribute("nationality", this.nationality != null ? this.nationality : this.getOwner().getNationID());
                out.writeAttribute("ethnicity", this.ethnicity != null ? this.ethnicity : this.getOwner().getNationID());
            }
        }
        out.writeAttribute("turnsOfTraining", Integer.toString(this.turnsOfTraining));
        if (this.workType != null) {
            out.writeAttribute("workType", this.workType.getId());
        }
        if (this.experienceType != null) {
            out.writeAttribute("experienceType", this.experienceType.getId());
        }
        out.writeAttribute("experience", Integer.toString(this.experience));
        out.writeAttribute("treasureAmount", Integer.toString(this.treasureAmount));
        out.writeAttribute("hitpoints", Integer.toString(this.hitpoints));
        out.writeAttribute("attrition", Integer.toString(this.attrition));
        this.writeAttribute(out, "student", this.student);
        this.writeAttribute(out, "teacher", this.teacher);
        if (full) {
            this.writeAttribute(out, "indianSettlement", this.indianSettlement);
            out.writeAttribute("workLeft", Integer.toString(this.workLeft));
        } else {
            out.writeAttribute("workLeft", Integer.toString(-1));
        }
        if (this.entryLocation != null) {
            out.writeAttribute("entryLocation", this.entryLocation.getId());
        }
        if (this.location != null) {
            if (full || !(this.location instanceof Building) && !(this.location instanceof ColonyTile)) {
                out.writeAttribute("location", this.location.getId());
            } else {
                out.writeAttribute("location", this.getColony().getId());
            }
        }
        if (this.destination != null) {
            out.writeAttribute("destination", this.destination.getId());
        }
        if (this.tradeRoute != null) {
            out.writeAttribute("tradeRoute", this.tradeRoute.getId());
            out.writeAttribute("currentStop", String.valueOf(this.currentStop));
        }
        if (this.workImprovement != null) {
            this.workImprovement.toXML(out, player, showAll, toSavedGame);
        }
        if (full) {
            super.writeChildren(out, player, showAll, toSavedGame);
        } else if (this.getType().canCarryGoods()) {
            out.writeAttribute("visibleGoodsCount", Integer.toString(this.getVisibleGoodsCount()));
        }
        if (!this.equipment.isEmpty()) {
            for (Map.Entry<EquipmentType, Integer> entry : this.equipment.getValues().entrySet()) {
                out.writeStartElement(EQUIPMENT_TAG);
                out.writeAttribute("id", entry.getKey().getId());
                out.writeAttribute("count", entry.getValue().toString());
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        super.readAttributes(in);
        this.setName(in.getAttributeValue(null, "name"));
        UnitType oldUnitType = this.unitType;
        this.unitType = this.getSpecification().getUnitType(in.getAttributeValue(null, "unitType"));
        this.movesLeft = Integer.parseInt(in.getAttributeValue(null, "movesLeft"));
        this.state = Enum.valueOf(UnitState.class, in.getAttributeValue(null, "state"));
        this.role = Enum.valueOf(Role.class, in.getAttributeValue(null, "role"));
        this.workLeft = Integer.parseInt(in.getAttributeValue(null, "workLeft"));
        this.attrition = this.getAttribute(in, "attrition", 0);
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.nationality = in.getAttributeValue(null, "nationality");
        this.ethnicity = in.getAttributeValue(null, "ethnicity");
        if (oldUnitType == null) {
            this.owner.modifyScore(this.unitType.getScoreValue());
        } else {
            this.owner.modifyScore(this.unitType.getScoreValue() - oldUnitType.getScoreValue());
        }
        this.turnsOfTraining = Integer.parseInt(in.getAttributeValue(null, "turnsOfTraining"));
        this.hitpoints = Integer.parseInt(in.getAttributeValue(null, "hitpoints"));
        this.teacher = this.getFreeColGameObject(in, "teacher", Unit.class);
        this.student = this.getFreeColGameObject(in, "student", Unit.class);
        String indianSettlementStr = in.getAttributeValue(null, "indianSettlement");
        if (indianSettlementStr != null) {
            this.indianSettlement = game.getFreeColGameObject(indianSettlementStr, IndianSettlement.class);
            if (this.indianSettlement == null) {
                this.indianSettlement = new IndianSettlement(game, indianSettlementStr);
            }
        } else {
            this.setIndianSettlement(null);
        }
        this.treasureAmount = this.getAttribute(in, "treasureAmount", 0);
        this.destination = this.newLocation(in.getAttributeValue(null, "destination"));
        this.currentStop = -1;
        this.tradeRoute = null;
        String tradeRouteStr = in.getAttributeValue(null, "tradeRoute");
        if (tradeRouteStr != null) {
            this.tradeRoute = game.getFreeColGameObject(tradeRouteStr, TradeRoute.class);
            String currentStopStr = in.getAttributeValue(null, "currentStop");
            if (currentStopStr != null) {
                this.currentStop = Integer.parseInt(currentStopStr);
            }
        }
        this.workType = this.getSpecification().getType(in, "workType", GoodsType.class, null);
        this.experienceType = this.getSpecification().getType(in, "experienceType", GoodsType.class, null);
        if (this.experienceType == null && this.workType != null) {
            this.experienceType = this.workType;
        }
        try {
            GoodsType grain = this.getSpecification().getGoodsType("model.goods.grain");
            GoodsType food = this.getSpecification().getPrimaryFoodType();
            if (food.equals(this.workType)) {
                this.workType = grain;
            }
            if (food.equals(this.experienceType)) {
                this.experienceType = grain;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Failed to update food to grain.", e);
        }
        this.experience = this.getAttribute(in, "experience", 0);
        this.visibleGoodsCount = this.getAttribute(in, "visibleGoodsCount", -1);
        this.entryLocation = this.newLocation(in.getAttributeValue(null, "entryLocation"));
        this.location = this.newLocation(in.getAttributeValue(null, "location"));
        this.clearUnitList();
        if (this.getGoodsContainer() != null) {
            this.getGoodsContainer().removeAll();
        }
        this.clearEquipment();
        this.setWorkImprovement(null);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals("units")) {
                while (in.nextTag() != 2) {
                    super.readChild(in);
                }
                continue;
            }
            if (in.getLocalName().equals(EQUIPMENT_TAG)) {
                String xLength = in.getAttributeValue(null, "xLength");
                if (xLength == null) {
                    String equipmentId = in.getAttributeValue(null, "id");
                    int count = Integer.parseInt(in.getAttributeValue(null, "count"));
                    this.equipment.incrementCount(this.getSpecification().getEquipmentType(equipmentId), count);
                } else {
                    int length = Integer.parseInt(xLength);
                    for (int index = 0; index < length; ++index) {
                        String equipmentId = in.getAttributeValue(null, "x" + String.valueOf(index));
                        this.equipment.incrementCount(this.getSpecification().getEquipmentType(equipmentId), 1);
                    }
                }
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(TileImprovement.getXMLElementTagName())) {
                this.setWorkImprovement(this.updateFreeColGameObject(in, TileImprovement.class));
                continue;
            }
            super.readChild(in);
        }
        this.setRole();
        this.getOwner().setUnit(this);
        this.getOwner().invalidateCanSeeTiles();
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public String toString(String prefix) {
        String rest = this.isUninitialized() ? "uninitialized" : (this.isDisposed() ? "disposed" : Utils.lastPart(this.owner.getNationID(), ".") + " " + Utils.lastPart(this.getType().getId(), ".") + (this.getRole() == Role.DEFAULT ? "" : "-" + (Object)((Object)this.getRole())) + " " + this.getMovesAsString());
        return "[" + prefix + this.getId() + " " + rest + "]";
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public static String getXMLElementTagName() {
        return "unit";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveType {
        MOVE(null, true),
        MOVE_HIGH_SEAS(null, true),
        EXPLORE_LOST_CITY_RUMOUR(null, true),
        ATTACK_UNIT(null, false),
        ATTACK_SETTLEMENT(null, false),
        EMBARK(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_SCOUT(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY(null, false),
        ENTER_FOREIGN_COLONY_WITH_SCOUT(null, false),
        ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS(null, false),
        MOVE_NO_MOVES("Attempt to move without moves left"),
        MOVE_NO_ACCESS_LAND("Attempt to move a naval unit onto land"),
        MOVE_NO_ACCESS_BEACHED("Attempt to move onto foreign beached ship"),
        MOVE_NO_ACCESS_EMBARK("Attempt to embark onto absent or foreign carrier"),
        MOVE_NO_ACCESS_FULL("Attempt to embark onto full carrier"),
        MOVE_NO_ACCESS_GOODS("Attempt to trade without goods"),
        MOVE_NO_ACCESS_CONTACT("Attempt to interact with natives before contact"),
        MOVE_NO_ACCESS_SETTLEMENT("Attempt to move into foreign settlement"),
        MOVE_NO_ACCESS_SKILL("Attempt to learn skill with incapable unit"),
        MOVE_NO_ACCESS_TRADE("Attempt to trade without authority"),
        MOVE_NO_ACCESS_WAR("Attempt to trade while at war"),
        MOVE_NO_ACCESS_WATER("Attempt to move into a settlement by water"),
        MOVE_NO_ATTACK_CIVILIAN("Attempt to attack with civilian unit"),
        MOVE_NO_ATTACK_MARINE("Attempt to attack from on board ship"),
        MOVE_NO_EUROPE("Attempt to move to Europe by incapable unit"),
        MOVE_NO_REPAIR("Attempt to move a unit that is under repair"),
        MOVE_NO_TILE("Attempt to move when not on a tile"),
        MOVE_ILLEGAL("Unspecified illegal move");

        private String reason;
        private boolean progress;

        private MoveType(String reason) {
            this.reason = reason;
            this.progress = false;
        }

        private MoveType(String reason, boolean progress) {
            this.reason = reason;
            this.progress = progress;
        }

        public boolean isLegal() {
            return this.reason == null;
        }

        public String whyIllegal() {
            return this.reason == null ? "(none)" : this.reason;
        }

        public boolean isProgress() {
            return this.progress;
        }

        public boolean isAttack() {
            return this == ATTACK_UNIT || this == ATTACK_SETTLEMENT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        DEFAULT,
        PIONEER,
        MISSIONARY,
        SOLDIER,
        SCOUT,
        DRAGOON;

        private static final HashMap<Role, List<EquipmentType>> roleEquipment;

        private void initializeRoleEquipment(Specification spec) {
            if (!roleEquipment.isEmpty()) {
                return;
            }
            UnitType defaultUnit = spec.getDefaultUnitType();
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                Role r = e.getRole();
                if (r == null) continue;
                List<EquipmentType> eq = roleEquipment.get((Object)r);
                if (eq == null) {
                    eq = new ArrayList<EquipmentType>();
                    roleEquipment.put(r, eq);
                }
                eq.add(e);
            }
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                if (!e.isMilitaryEquipment()) continue;
                List<EquipmentType> eq = roleEquipment.get((Object)DRAGOON);
                if (eq == null) {
                    eq = new ArrayList<EquipmentType>();
                    roleEquipment.put(DRAGOON, eq);
                }
                if (eq.contains(e)) continue;
                eq.add(e);
            }
            for (Role r : Role.values()) {
                List<EquipmentType> e = roleEquipment.get((Object)r);
                if (e != null) continue;
                e = new ArrayList<EquipmentType>();
                roleEquipment.put(r, e);
            }
        }

        public List<EquipmentType> getRoleEquipment(Specification spec) {
            this.initializeRoleEquipment(spec);
            return new ArrayList<EquipmentType>((Collection)roleEquipment.get((Object)this));
        }

        public boolean isCompatibleWith(Role oldRole) {
            return this == oldRole || this == SOLDIER && oldRole == DRAGOON || this == DRAGOON && oldRole == SOLDIER;
        }

        public Role newRole(Role role) {
            if (this == SOLDIER && role == SCOUT) {
                return DRAGOON;
            }
            if (this == SCOUT && role == SOLDIER) {
                return DRAGOON;
            }
            return role;
        }

        public String getId() {
            return this.toString().toLowerCase(Locale.US);
        }

        static {
            roleEquipment = new HashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitState {
        ACTIVE,
        FORTIFIED,
        SENTRY,
        IN_COLONY,
        IMPROVING,
        TO_EUROPE,
        TO_AMERICA,
        FORTIFYING,
        SKIPPED;

    }
}

