/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import net.sf.freecol.common.model.mission.MissionManager;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundMission
extends AbstractMission {
    private List<Mission> missions;
    private int index;

    public CompoundMission(Game game) {
        super(game);
    }

    public CompoundMission(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public CompoundMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public CompoundMission(Game game, String id) {
        super(game, id);
    }

    public final List<Mission> getMissions() {
        return this.missions;
    }

    public final void setMissions(List<Mission> newMissions) {
        this.missions = newMissions;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int newIndex) {
        this.index = newIndex;
    }

    @Override
    public boolean isValid() {
        if (super.isValid() && !this.missions.isEmpty()) {
            for (Mission mission : this.missions) {
                if (mission.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Mission.MissionState doMission() {
        Mission.MissionState state = this.missions.get(this.index).doMission();
        if (state == Mission.MissionState.COMPLETED) {
            ++this.index;
            if (this.index == this.missions.size()) {
                this.setRepeatCount(this.getRepeatCount() - 1);
                if (this.getRepeatCount() > 0) {
                    this.index = 0;
                } else {
                    return Mission.MissionState.COMPLETED;
                }
            }
            if (this.getUnit().getMovesLeft() > 0) {
                return this.doMission();
            }
        }
        return state;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("index", Integer.toString(this.index));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (Mission mission : this.missions) {
            mission.toXML(out);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.index = this.getAttribute(in, "index", 0);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.missions.clear();
        while (in.nextTag() != 2) {
            Mission mission = MissionManager.getMission(this.getGame(), in);
            if (mission == null) continue;
            this.missions.add(mission);
        }
    }
}

