/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.BaseCostDecider;
import net.sf.freecol.common.model.pathfinding.CostDecider;

public final class CostDeciders {
    private static final CostDecider avoidIllegalCostDecider = new BaseCostDecider();
    private static final CostDecider trivialCostDecider = new CostDecider(){

        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            return newLocation == null ? -1 : (newLocation instanceof Europe ? 1 : (newLocation.getTile() == null ? -1 : 1));
        }

        public int getMovesLeft() {
            return 0;
        }

        public int getNewTurns() {
            return 0;
        }
    };
    private static final CostDecider tileCostDecider = new CostDecider(){

        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            return newLocation == null ? -1 : (newLocation instanceof Europe ? 1 : (newLocation.getTile() == null ? -1 : (unit.isTileAccessible(newLocation.getTile()) ? 1 : -1)));
        }

        public int getMovesLeft() {
            return 0;
        }

        public int getNewTurns() {
            return 1;
        }
    };
    private static final CostDecider serverAvoidIllegalCostDecider = new ServerBaseCostDecider();
    private static final AvoidSettlementsCostDecider avoidSettlementsCostDecider = new AvoidSettlementsCostDecider();
    private static final AvoidSettlementsAndBlockingUnitsCostDecider avoidSettlementsAndBlockingUnitsCostDecider = new AvoidSettlementsAndBlockingUnitsCostDecider();

    public static CostDecider defaultCostDeciderFor(Unit unit) {
        return unit == null || !unit.isOffensiveUnit() ? CostDeciders.avoidSettlementsAndBlockingUnits() : CostDeciders.avoidSettlements();
    }

    public static CostDecider numberOfTiles() {
        return trivialCostDecider;
    }

    public static CostDecider numberOfLegalTiles() {
        return tileCostDecider;
    }

    public static CostDecider avoidIllegal() {
        return avoidIllegalCostDecider;
    }

    public static CostDecider serverAvoidIllegal() {
        return serverAvoidIllegalCostDecider;
    }

    public static CostDecider avoidSettlements() {
        return avoidSettlementsCostDecider;
    }

    public static CostDecider avoidSettlementsAndBlockingUnits() {
        return avoidSettlementsAndBlockingUnitsCostDecider;
    }

    private static class AvoidSettlementsAndBlockingUnitsCostDecider
    extends AvoidSettlementsCostDecider {
        private AvoidSettlementsAndBlockingUnitsCostDecider() {
        }

        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            Tile tile = newLocation.getTile();
            if (cost != -1 && cost != Integer.MAX_VALUE && tile != null) {
                Unit defender = tile.getFirstUnit();
                if (defender != null && defender.getOwner() != unit.getOwner()) {
                    return -1;
                }
                if (unit.getTradeRoute() != null && unit.getMoveType(tile) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR) {
                    return -1;
                }
            }
            return cost;
        }
    }

    private static class AvoidSettlementsCostDecider
    extends BaseCostDecider {
        private AvoidSettlementsCostDecider() {
        }

        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            Settlement settlement;
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            if (cost != -1 && cost != Integer.MAX_VALUE && (settlement = newLocation.getSettlement()) != null && settlement.getOwner() != unit.getOwner()) {
                return -1;
            }
            return cost;
        }
    }

    private static class ServerBaseCostDecider
    extends BaseCostDecider {
        private ServerBaseCostDecider() {
        }

        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            if (cost != -1 && cost != Integer.MAX_VALUE && !(newLocation instanceof Europe) && !newLocation.getTile().isExploredBy(unit.getOwner())) {
                return -1;
            }
            return cost;
        }
    }
}

