/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AbandonColonyMessage
extends DOMMessage {
    String colonyId;

    public AbandonColonyMessage(Colony colony) {
        this.colonyId = colony.getId();
    }

    public AbandonColonyMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            colony = player.getFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (colony.getUnitCount() != 0) {
            return DOMMessage.clientError("Attempt to abandon colony " + this.colonyId + " with non-zero unit count " + Integer.toString(colony.getUnitCount()));
        }
        return server.getInGameController().abandonSettlement(serverPlayer, colony);
    }

    public Element toXMLElement() {
        return AbandonColonyMessage.createMessage(AbandonColonyMessage.getXMLElementTagName(), "colony", this.colonyId);
    }

    public static String getXMLElementTagName() {
        return "abandonColony";
    }
}

