/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MoveMessage
extends DOMMessage {
    private String unitId;
    private String directionString;

    public MoveMessage(Unit unit, Map.Direction direction) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public MoveMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Unit.MoveType moveType = unit.getMoveType(tile);
        if (!moveType.isProgress()) {
            return DOMMessage.clientError("Illegal move for: " + this.unitId + " type: " + (Object)((Object)moveType) + " from: " + unit.getLocation().getId() + " to: " + tile.getId());
        }
        return server.getInGameController().move(serverPlayer, unit, tile);
    }

    public Element toXMLElement() {
        return MoveMessage.createMessage(MoveMessage.getXMLElementTagName(), "unit", this.unitId, "direction", this.directionString);
    }

    public static String getXMLElementTagName() {
        return "move";
    }
}

