/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AbandonColonyMessage;
import net.sf.freecol.common.networking.AskSkillMessage;
import net.sf.freecol.common.networking.AssignTeacherMessage;
import net.sf.freecol.common.networking.AssignTradeRouteMessage;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.BuyGoodsMessage;
import net.sf.freecol.common.networking.BuyMessage;
import net.sf.freecol.common.networking.BuyPropositionMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.Client;
import net.sf.freecol.common.networking.CloseTransactionMessage;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DeclareIndependenceMessage;
import net.sf.freecol.common.networking.DeclineMoundsMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DemandTributeMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.DisbandUnitMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipUnitMessage;
import net.sf.freecol.common.networking.GetNationSummaryMessage;
import net.sf.freecol.common.networking.GetTransactionMessage;
import net.sf.freecol.common.networking.GoodsForSaleMessage;
import net.sf.freecol.common.networking.InciteMessage;
import net.sf.freecol.common.networking.JoinColonyMessage;
import net.sf.freecol.common.networking.LearnSkillMessage;
import net.sf.freecol.common.networking.LoadCargoMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.networking.PayArrearsMessage;
import net.sf.freecol.common.networking.PayForBuildingMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.RenameMessage;
import net.sf.freecol.common.networking.ScoutIndianSettlementMessage;
import net.sf.freecol.common.networking.SellGoodsMessage;
import net.sf.freecol.common.networking.SellMessage;
import net.sf.freecol.common.networking.SellPropositionMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.SetDestinationMessage;
import net.sf.freecol.common.networking.SetGoodsLevelsMessage;
import net.sf.freecol.common.networking.SetTradeRoutesMessage;
import net.sf.freecol.common.networking.SpySettlementMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.UnloadCargoMessage;
import net.sf.freecol.common.networking.UpdateCurrentStopMessage;
import net.sf.freecol.common.networking.UpdateTradeRouteMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.common.option.OptionGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerAPI {
    private static final Logger logger = Logger.getLogger(ServerAPI.class.getName());
    private Client client;

    public boolean abandonColony(Colony colony) {
        return this.askHandling(new AbandonColonyMessage(colony), null, null);
    }

    public boolean answerMonarch(Monarch.MonarchAction action, boolean accept) {
        return this.askHandling(new TrivialMessage("monarchAction", "action", action.toString(), "accepted", Boolean.toString(accept)), null, null);
    }

    public boolean askSkill(Unit unit, Map.Direction direction) {
        return this.askHandling(new AskSkillMessage(unit, direction), null, null);
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        return this.askHandling(new AssignTeacherMessage(student, teacher), null, null);
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        return this.askHandling(new AssignTradeRouteMessage(unit, tradeRoute), null, null);
    }

    public boolean attack(Unit unit, Map.Direction direction) {
        return this.askHandling(new AttackMessage(unit, direction), null, null);
    }

    public boolean buildColony(String name, Unit unit) {
        return this.askHandling(new BuildColonyMessage(name, unit), null, null);
    }

    public boolean buyFromSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        return this.askHandling(new BuyMessage(unit, settlement, goods, gold), null, null);
    }

    public boolean buyGoods(Unit carrier, GoodsType type, int amount) {
        return this.askHandling(new BuyGoodsMessage(carrier, type, amount), null, null);
    }

    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (this.askHandling(new BuyPropositionMessage(unit, settlement, goods, gold), null, results)) {
            try {
                return Integer.parseInt(results.get("gold"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean cashInTreasureTrain(Unit unit) {
        return this.askHandling(new CashInTreasureTrainMessage(unit), null, null);
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        return this.askHandling(new ChangeStateMessage(unit, state), null, null);
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType type) {
        return this.askHandling(new ChangeWorkImprovementTypeMessage(unit, type), null, null);
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        return this.askHandling(new ChangeWorkTypeMessage(unit, workType), null, null);
    }

    public boolean chat(Player player, String chat) {
        return this.send(new ChatMessage(player, chat, false));
    }

    public boolean checkHighScore() {
        HashMap<String, String> results = this.loadMap("highScore");
        return this.askHandling(new TrivialMessage("checkHighScore", new String[0]), null, results) && results.get("highScore") != null ? Boolean.parseBoolean(results.get("highScore")) : false;
    }

    public boolean claimLand(Tile tile, FreeColGameObject claimant, int price) {
        return this.askHandling(new ClaimLandMessage(tile, claimant, price), null, null);
    }

    public boolean clearSpeciality(Unit unit) {
        return this.askHandling(new ClearSpecialityMessage(unit), null, null);
    }

    public boolean closeTransactionSession(Unit unit, Settlement settlement) {
        return this.askHandling(new CloseTransactionMessage(unit, settlement), null, null);
    }

    public void continuePlaying() {
        this.client.send(DOMMessage.createMessage("continuePlaying", new String[0]));
    }

    public boolean declareIndependence(String nation, String country) {
        return this.askHandling(new DeclareIndependenceMessage(nation, country), null, null);
    }

    public boolean declineMounds(Unit unit, Map.Direction direction) {
        return this.askHandling(new DeclineMoundsMessage(unit, direction), null, null);
    }

    public boolean deliverGiftToSettlement(Unit unit, Settlement settlement, Goods goods) {
        return this.askHandling(new DeliverGiftMessage(unit, settlement, goods), null, null);
    }

    public boolean demandTribute(Unit unit, Map.Direction direction) {
        return this.askHandling(new DemandTributeMessage(unit, direction), null, null);
    }

    public DiplomaticTrade diplomacy(Game game, Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        Element reply = this.askExpecting(new DiplomacyMessage(unit, settlement, agreement), null, null);
        if (reply == null) {
            return null;
        }
        if (DiplomacyMessage.getXMLElementTagName().equals(reply.getTagName())) {
            return new DiplomacyMessage(game, reply).getAgreement();
        }
        this.client.handleReply(reply);
        return null;
    }

    public boolean disbandUnit(Unit unit) {
        return this.askHandling(new DisbandUnitMessage(unit), null, null);
    }

    public boolean disembark(Unit unit) {
        return this.askHandling(new DisembarkMessage(unit), null, null);
    }

    public boolean embark(Unit unit, Unit carrier, Map.Direction direction) {
        return this.askHandling(new EmbarkMessage(unit, carrier, direction), null, null);
    }

    public boolean emigrate(int slot) {
        return this.askHandling(new EmigrateUnitMessage(slot), null, null);
    }

    public boolean endTurn() {
        return this.askHandling(new TrivialMessage("endTurn", new String[0]), null, null);
    }

    public boolean enterRevengeMode() {
        return this.askHandling(new TrivialMessage("enterRevengeMode", new String[0]), null, null);
    }

    public boolean equipUnit(Unit unit, EquipmentType type, int amount) {
        return this.askHandling(new EquipUnitMessage(unit, type, amount), null, null);
    }

    public Client getClient() {
        return this.client;
    }

    public List<Goods> getGoodsForSaleInSettlement(Game game, Unit unit, Settlement settlement) {
        GoodsForSaleMessage message = new GoodsForSaleMessage(unit, settlement, null);
        Element reply = this.askExpecting(message, GoodsForSaleMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        ArrayList<Goods> goodsOffered = new ArrayList<Goods>();
        NodeList childNodes = reply.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            goodsOffered.add(new Goods(game, (Element)childNodes.item(i)));
        }
        return goodsOffered;
    }

    public List<HighScore> getHighScores() {
        Element reply = this.askExpecting(new TrivialMessage("getHighScores", new String[0]), null, null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<HighScore> result = new ArrayList<HighScore>();
        NodeList childElements = reply.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            try {
                HighScore score = new HighScore((Element)childElements.item(i));
                result.add(score);
                continue;
            }
            catch (XMLStreamException e) {
                logger.warning("Unable to read score element: " + e.getMessage());
            }
        }
        return result;
    }

    public NationSummary getNationSummary(Player player) {
        GetNationSummaryMessage message = new GetNationSummaryMessage(player);
        Element reply = this.askExpecting(message, GetNationSummaryMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        return new GetNationSummaryMessage(reply).getNationSummary();
    }

    public boolean getNewTradeRoute() {
        return this.askHandling(new TrivialMessage("getNewTradeRoute", new String[0]), null, null);
    }

    public List<AbstractUnit> getREFUnits() {
        Element reply = this.askExpecting(new TrivialMessage("getREFUnits", new String[0]), null, null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        NodeList childElements = reply.getChildNodes();
        for (int index = 0; index < childElements.getLength(); ++index) {
            AbstractUnit unit = new AbstractUnit();
            unit.readFromXMLElement((Element)childElements.item(index));
            result.add(unit);
        }
        return result;
    }

    public Map<String, String> getStatistics() {
        HashMap<String, String> results = this.loadMap("*");
        return this.askExpecting(new TrivialMessage("getStatistics", new String[0]), "statistics", results) == null ? null : results;
    }

    public int incite(Unit unit, Map.Direction direction, Player enemy, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (!this.askHandling(new InciteMessage(unit, direction, enemy, gold), null, results)) {
            return -1;
        }
        try {
            return Integer.parseInt(results.get("gold"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean joinColony(Unit unit, Colony colony) {
        return this.askHandling(new JoinColonyMessage(colony, unit), null, null);
    }

    public boolean learnSkill(Unit unit, Map.Direction direction) {
        return this.askHandling(new LearnSkillMessage(unit, direction), null, null);
    }

    public boolean loadCargo(Goods goods, Unit carrier) {
        return this.askHandling(new LoadCargoMessage(goods, carrier), null, null);
    }

    public LoginMessage login(String username, String version) {
        Element reply = this.askExpecting(new TrivialMessage("login", "userName", username, "version", version), "login", null);
        return reply == null ? null : new LoginMessage(null, reply);
    }

    public boolean loot(Unit winner, String defenderId, List<Goods> goods) {
        return this.askHandling(new LootCargoMessage(winner, defenderId, goods), null, null);
    }

    public boolean missionary(Unit unit, Map.Direction direction, boolean denounce) {
        return this.askHandling(new MissionaryMessage(unit, direction, denounce), null, null);
    }

    public boolean move(Unit unit, Map.Direction direction) {
        return this.askHandling(new MoveMessage(unit, direction), null, null);
    }

    public boolean moveTo(Unit unit, Location destination) {
        return this.askHandling(new MoveToMessage(unit, destination), null, null);
    }

    public boolean newLandName(Unit unit, String name, Player welcomer, boolean accept) {
        return this.askHandling(new NewLandNameMessage(unit, name, welcomer, -1, accept), null, null);
    }

    public boolean newRegionName(Region region, Tile tile, String name) {
        return this.askHandling(new NewRegionNameMessage(region, tile, name), null, null);
    }

    public boolean[] openTransactionSession(Unit unit, Settlement settlement) {
        HashMap<String, String> results = this.loadMap("canBuy", "canSell", "canGift");
        if (this.askExpecting(new GetTransactionMessage(unit, settlement), null, results) == null || results.get("canBuy") == null || results.get("canSell") == null || results.get("canGift") == null) {
            return null;
        }
        return new boolean[]{Boolean.parseBoolean(results.get("canBuy")), Boolean.parseBoolean(results.get("canSell")), Boolean.parseBoolean(results.get("canGift"))};
    }

    public boolean payArrears(GoodsType type) {
        return this.askHandling(new PayArrearsMessage(type), null, null);
    }

    public boolean payForBuilding(Colony colony) {
        return this.askHandling(new PayForBuildingMessage(colony), null, null);
    }

    public boolean putOutsideColony(Unit unit) {
        return this.askHandling(new PutOutsideColonyMessage(unit), null, null);
    }

    public boolean rename(FreeColGameObject object, String name) {
        return this.askHandling(new RenameMessage(object, name), null, null);
    }

    public void requestLaunch() {
        this.client.send(DOMMessage.createMessage("requestLaunch", new String[0]));
    }

    public boolean retire() {
        return this.askHandling(new TrivialMessage("retire", new String[0]), null, null);
    }

    public String scoutSpeak(Unit unit, Map.Direction direction) {
        HashMap<String, String> results = this.loadMap("result");
        return this.askHandling(new ScoutIndianSettlementMessage(unit, direction), null, results) ? results.get("result") : null;
    }

    public boolean sellGoods(Goods goods, Unit carrier) {
        return this.askHandling(new SellGoodsMessage(goods, carrier), null, null);
    }

    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (this.askHandling(new SellPropositionMessage(unit, settlement, goods, gold), null, results)) {
            try {
                return Integer.parseInt(results.get("gold"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean sellToSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        return this.askHandling(new SellMessage(unit, settlement, goods, gold), null, null);
    }

    public void setAvailable(Nation nation, NationOptions.NationState state) {
        this.client.sendAndWait(DOMMessage.createMessage("setAvailable", "nation", nation.getId(), "state", state.toString()));
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        return this.askHandling(new SetBuildQueueMessage(colony, buildQueue), null, null);
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public boolean setDestination(Unit unit, Location destination) {
        return this.askHandling(new SetDestinationMessage(unit, destination), null, null);
    }

    public boolean setGoodsLevels(Colony colony, ExportData data) {
        return this.askHandling(new SetGoodsLevelsMessage(colony, data), null, null);
    }

    public void setNation(Nation nation) {
        this.client.sendAndWait(DOMMessage.createMessage("setNation", "value", nation.getId()));
    }

    public void setNationType(NationType nationType) {
        this.client.sendAndWait(DOMMessage.createMessage("setNationType", "value", nationType.getId()));
    }

    public void setReady(boolean ready) {
        this.client.send(DOMMessage.createMessage("ready", "value", Boolean.toString(ready)));
    }

    public boolean setTradeRoutes(List<TradeRoute> routes) {
        return this.askHandling(new SetTradeRoutesMessage(routes), null, null);
    }

    public boolean spy(Unit unit, Map.Direction direction) {
        return this.askHandling(new SpySettlementMessage(unit, direction), null, null);
    }

    public boolean startSkipping() {
        return this.send(new TrivialMessage("endTurn", new String[0]));
    }

    public boolean trainUnitInEurope(UnitType type) {
        return this.askHandling(new TrainUnitInEuropeMessage(type), null, null);
    }

    public boolean unloadCargo(Goods goods) {
        return this.askHandling(new UnloadCargoMessage(goods), null, null);
    }

    public boolean updateCurrentStop(Unit unit) {
        return this.askHandling(new UpdateCurrentStopMessage(unit), null, null);
    }

    public void updateGameOptions(OptionGroup gameOptions) {
        Element up = DOMMessage.createMessage("updateGameOptions", new String[0]);
        up.appendChild(gameOptions.toXMLElement(up.getOwnerDocument()));
        this.client.send(up);
    }

    public void updateMapGeneratorOption(OptionGroup mapOptions) {
        Element up = DOMMessage.createMessage("updateMapGeneratorOptions", new String[0]);
        up.appendChild(mapOptions.toXMLElement(up.getOwnerDocument()));
        this.client.send(up);
    }

    public boolean updateTradeRoute(TradeRoute route) {
        return this.askHandling(new UpdateTradeRouteMessage(route), null, null);
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        return this.askHandling(new WorkMessage(unit, workLocation), null, null);
    }

    protected abstract void doClientProcessingFor(Element var1);

    protected abstract void doRaiseErrorMessage(String var1);

    private Element askExpecting(DOMMessage message, String tag, HashMap<String, String> results) {
        Element reply = this.client.ask(message.toXMLElement());
        if (reply == null) {
            return null;
        }
        if ("error".equals(reply.getTagName())) {
            String messageId = reply.getAttribute("messageID");
            String messageText = reply.getAttribute("message");
            if (messageId != null && messageText != null && FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS)) {
                reply.removeAttribute("messageID");
            }
            if (messageId == null && messageText == null) {
                logger.warning("Received null error response");
            } else {
                logger.warning("Received error response: " + (messageId != null ? messageId : "") + "/" + (messageText != null ? messageText : ""));
                this.client.handleReply(reply);
            }
            return null;
        }
        if (tag == null || tag.equals(reply.getTagName())) {
            this.doClientProcessingFor(reply);
            if (results != null) {
                if (results.containsKey("*")) {
                    results.remove("*");
                    int len = reply.getAttributes().getLength();
                    for (int i = 0; i < len; ++i) {
                        Node n = reply.getAttributes().item(i);
                        results.put(n.getNodeName(), n.getNodeValue());
                    }
                } else {
                    for (String k : results.keySet()) {
                        if (!reply.hasAttribute(k)) continue;
                        results.put(k, reply.getAttribute(k));
                    }
                }
            }
            return reply;
        }
        String complaint = "Received reply with tag " + reply.getTagName() + " which should have been " + tag + " to message " + message;
        logger.warning(complaint);
        this.doRaiseErrorMessage(complaint);
        return null;
    }

    private boolean askHandling(DOMMessage message, String tag, HashMap<String, String> results) {
        Element reply = this.askExpecting(message, tag, results);
        if (reply == null) {
            return false;
        }
        this.client.handleReply(reply);
        return true;
    }

    private HashMap<String, String> loadMap(String ... queries) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String q : queries) {
            result.put(q, null);
        }
        return result;
    }

    private boolean send(DOMMessage message) {
        this.client.send(message.toXMLElement());
        return true;
    }

    public void logout() {
        this.client.sendAndWait(DOMMessage.createMessage("logout", "reason", "User has quit the client."));
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void connect(String threadName, String host, int port, MessageHandler messageHandler) throws ConnectException, IOException {
        int tries;
        if (port < 0) {
            port = FreeCol.getDefaultPort();
            tries = 10;
        } else {
            tries = 1;
        }
        for (int i = tries; i > 0; --i) {
            try {
                this.client = new Client(host, port, messageHandler, threadName);
                if (this.client == null) continue;
                break;
            }
            catch (ConnectException e) {
                if (i != 1) continue;
                throw e;
            }
            catch (IOException e) {
                if (i != 1) continue;
                throw e;
            }
        }
    }

    public void reset() {
        this.client = null;
    }

    public void registerMessageHandler(MessageHandler messageHandler) {
        this.client.setMessageHandler(messageHandler);
    }

    private class TrivialMessage
    extends DOMMessage {
        private String tag;
        private String[] attributes;

        public TrivialMessage(String tag, String ... attributes) {
            this.tag = tag;
            this.attributes = attributes;
        }

        public Element toXMLElement() {
            return DOMMessage.createMessage(this.tag, this.attributes);
        }
    }
}

