/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SetGoodsLevelsMessage
extends DOMMessage {
    private String colonyId;
    private ExportData data;

    public SetGoodsLevelsMessage(Colony colony, ExportData data) {
        this.colonyId = colony.getId();
        this.data = data;
    }

    public SetGoodsLevelsMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
        this.data = new ExportData();
        this.data.readFromXMLElement((Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            colony = player.getFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().setGoodsLevels(serverPlayer, colony, this.data);
    }

    public Element toXMLElement() {
        Element result = SetGoodsLevelsMessage.createMessage(SetGoodsLevelsMessage.getXMLElementTagName(), "colony", this.colonyId);
        result.appendChild(this.data.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "setGoodsLevels";
    }
}

