/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuropeanAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(EuropeanAIPlayer.class.getName());
    private static final int buildingRange = 5;
    private static final int cashInRange = 20;
    private static final int missionaryRange = 20;
    private static final int pioneeringRange = 10;
    private static final int scoutingRange = 20;
    private static final Comparator<AIUnit> builderComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            int base;
            Unit unit;
            if (a == null || (unit = a.getUnit()) == null || BuildColonyMission.invalidReason(a) != null) {
                return -1000;
            }
            int n = !unit.getEquipment().isEmpty() ? 0 : (base = unit.getSkillLevel() > 0 ? 100 : 500 + 100 * unit.getSkillLevel());
            if (unit.getTile() != null) {
                base += 50;
            }
            return base;
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    private static final Comparator<AIUnit> scoutComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            int base;
            Unit unit;
            if (a == null || (unit = a.getUnit()) == null || unit.getLocation() == null || !unit.isColonist()) {
                return -1000;
            }
            if (unit.hasAbility("model.ability.scoutIndianSettlement")) {
                return 900 + (unit.getTile() != null ? 100 : 0);
            }
            if (unit.hasAbility("model.ability.expertScout")) {
                return 600;
            }
            int n = unit.isInEurope() ? 500 : (base = unit.getLocation().getColony() != null && unit.getLocation().getColony().canProvideEquipment(Unit.Role.SCOUT.getRoleEquipment(unit.getSpecification())) ? 400 : -1000);
            if (!unit.getEquipment().isEmpty()) {
                base -= 400;
            } else if (unit.getSkillLevel() > 0) {
                base -= 200;
            }
            return base;
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    private static final Comparator<AIUnit> pioneerComparator = new Comparator<AIUnit>(){

        private int score(AIUnit a) {
            int base;
            Unit unit;
            if (a == null || (unit = a.getUnit()) == null || unit.getLocation() == null || !unit.isColonist()) {
                return -1000;
            }
            if (unit.hasAbility("model.ability.improveTerrain")) {
                return 900 + (unit.getTile() != null ? 100 : 0);
            }
            if (unit.hasAbility("model.ability.expertPioneer")) {
                return 600;
            }
            int n = unit.isInEurope() ? 500 : (base = unit.getLocation().getColony() != null && unit.getLocation().getColony().canProvideEquipment(Unit.Role.PIONEER.getRoleEquipment(unit.getSpecification())) ? 400 : -1000);
            base = !unit.getEquipment().isEmpty() ? (base -= 400) : (unit.getSkillLevel() > 0 ? (base -= 200) : (base += unit.getSkillLevel() * 150));
            return base;
        }

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            return this.score(a2) - this.score(a1);
        }
    };
    private final java.util.Map<Tile, TileImprovementPlan> tipMap = new HashMap<Tile, TileImprovementPlan>();
    private final java.util.Map<Location, List<Wish>> transportDemand = new HashMap<Location, List<Wish>>();
    private final java.util.Map<Location, List<Transportable>> transportSupply = new HashMap<Location, List<Transportable>>();
    private final java.util.Map<GoodsType, List<GoodsWish>> goodsWishes = new HashMap<GoodsType, List<GoodsWish>>();
    private final java.util.Map<UnitType, List<WorkerWish>> workerWishes = new HashMap<UnitType, List<WorkerWish>>();
    private final java.util.Map<Integer, Integer> wagonsNeeded = new HashMap<Integer, Integer>();
    private final java.util.Map<String, Integer> sessionRegister = new HashMap<String, Integer>();
    private final java.util.Map<Unit, String> reasons = new HashMap<Unit, String>();
    private int nBuilders = 0;
    private int nPioneers = 0;
    private int nScouts = 0;
    private int nNavalCarrier = 0;

    public EuropeanAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public EuropeanAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getPlayer() == null;
    }

    public void buildTipMap() {
        this.tipMap.clear();
        for (AIColony aic : this.getAIColonies()) {
            for (TileImprovementPlan tip : aic.getTileImprovementPlans()) {
                if (tip == null || tip.isComplete()) {
                    aic.removeTileImprovementPlan(tip);
                    continue;
                }
                if (tip.getPioneer() != null) continue;
                if (!tip.validate()) {
                    aic.removeTileImprovementPlan(tip);
                    tip.dispose();
                    continue;
                }
                TileImprovementPlan other = this.tipMap.get(tip.getTarget());
                if (other != null && other.getValue() >= tip.getValue()) continue;
                this.tipMap.put(tip.getTarget(), tip);
            }
        }
    }

    public TileImprovementPlan getBestPlan(Tile tile) {
        return this.tipMap == null ? null : this.tipMap.get(tile);
    }

    public Tile getBestPlanTile(Colony colony) {
        TileImprovementPlan best = null;
        int bestValue = Integer.MIN_VALUE;
        for (Tile t : colony.getOwnedTiles()) {
            TileImprovementPlan tip = this.tipMap.get(t);
            if (tip == null || tip.getValue() <= bestValue) continue;
            bestValue = tip.getValue();
            best = tip;
        }
        return best == null ? null : best.getTarget();
    }

    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        for (AIColony aic : this.getAIColonies()) {
            if (aic.removeTileImprovementPlan(plan)) break;
        }
    }

    private boolean requestsTransport(Transportable t) {
        return t.getTransport() == null && t.getTransportDestination() != null && t.getTransportSource() != null && !(t.getTransportLocatable().getLocation() instanceof Unit);
    }

    private boolean checkTransport(Transportable t) {
        AIUnit aiCarrier = t.getTransport();
        if (aiCarrier != null) {
            Mission m = aiCarrier.getMission();
            if (m instanceof TransportMission) {
                if (((TransportMission)m).isTransporting(t)) {
                    return true;
                }
                t.setTransport(null, "mission dropped");
                return false;
            }
            t.setTransport(null, "no carrier transport mission");
            return false;
        }
        return true;
    }

    public int getNeededWagons(Tile tile) {
        Integer i;
        int contig;
        if (tile != null && (contig = tile.getContiguity()) > 0 && (i = this.wagonsNeeded.get(contig)) != null) {
            return i;
        }
        return 0;
    }

    private void changeNeedWagon(Tile tile, int amount) {
        if (tile == null) {
            return;
        }
        int contig = tile.getContiguity();
        if (contig > 0) {
            Integer i = this.wagonsNeeded.get(contig);
            if (i == null) {
                if (amount == 0) {
                    this.wagonsNeeded.put(contig, new Integer(0));
                }
            } else {
                this.wagonsNeeded.put(contig, new Integer(i + amount));
            }
        }
    }

    private void buildTransportMaps() {
        Colony colony;
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.nNavalCarrier = 0;
        for (AIColony aic : this.getAIColonies()) {
            colony = aic.getColony();
            if (!colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 0);
        }
        for (AIUnit aiu : this.getAIUnits()) {
            Unit u = aiu.getUnit();
            if (u.isCarrier()) {
                if (u.isNaval()) {
                    --this.nNavalCarrier;
                    continue;
                }
                this.changeNeedWagon(u.getTile(), -1);
                continue;
            }
            this.checkTransport(aiu);
            if (!this.requestsTransport(aiu)) continue;
            Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aiu.getTransportSource()), aiu);
            aiu.increaseTransportPriority();
            ++this.nNavalCarrier;
        }
        for (AIColony aic : this.getAIColonies()) {
            for (AIGoods aig : aic.getAIGoods()) {
                Location dst;
                this.checkTransport(aig);
                if (!this.requestsTransport(aig)) continue;
                Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aig.getTransportSource()), aig);
                aig.increaseTransportPriority();
                Location src = aig.getTransportSource();
                if (Map.isSameContiguity(src, dst = aig.getTransportDestination())) continue;
                ++this.nNavalCarrier;
            }
            colony = aic.getColony();
            if (colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 1);
        }
        for (Wish w : this.getWishes()) {
            Transportable t = w.getTransportable();
            if (t == null || t.getTransport() != null || t.getTransportDestination() == null) continue;
            Location loc = EuropeanAIPlayer.upLoc(t.getTransportDestination());
            Utils.appendToMapList(this.transportDemand, loc, w);
        }
        if (logger.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder("Supply:");
            for (Location ls : this.transportSupply.keySet()) {
                sb.append(" ");
                sb.append(((FreeColGameObject)((Object)ls)).toString());
                sb.append("[");
                for (Transportable t : this.transportSupply.get(ls)) {
                    sb.append(" ");
                    sb.append(t.toString());
                }
                sb.append(" ]");
            }
            sb.append("\nDemand:");
            for (Location ld : this.transportDemand.keySet()) {
                sb.append(" ");
                sb.append(((FreeColGameObject)((Object)ld)).toString());
                sb.append("[");
                for (Wish w : this.transportDemand.get(ld)) {
                    sb.append(" ");
                    sb.append(w.toString());
                }
                sb.append(" ]");
            }
            logger.finest(sb.toString());
        }
    }

    public List<Transportable> getUrgentTransportables() {
        ArrayList<Transportable> urgent = new ArrayList<Transportable>();
        for (Location l : this.transportSupply.keySet()) {
            urgent.addAll((Collection)this.transportSupply.get(l));
        }
        Collections.sort(urgent, Transportable.transportableComparator);
        int urge = urgent.size();
        urge = Math.max(2, (urge + 5) / 10);
        while (urgent.size() > urge) {
            urgent.remove(urge);
        }
        return urgent;
    }

    public List<Transportable> getTransportablesAt(Location loc) {
        ArrayList supply = this.transportSupply.get(EuropeanAIPlayer.upLoc(loc));
        return supply == null ? supply : new ArrayList(supply);
    }

    public boolean claimTransportable(Transportable t) {
        return this.claimTransportable(t, EuropeanAIPlayer.upLoc(t.getTransportSource()));
    }

    public boolean claimTransportable(Transportable t, Location loc) {
        List<Transportable> tl = this.transportSupply.get(EuropeanAIPlayer.upLoc(loc));
        return tl != null && tl.remove(t);
    }

    private WorkerWish getBestWorkerWish(AIUnit aiUnit, List<WorkerWish> wishes) {
        if (wishes == null) {
            return null;
        }
        Unit carrier = aiUnit.getUnit();
        WorkerWish nonTransported = null;
        WorkerWish transported = null;
        float bestNonTransportedValue = -1.0f;
        float bestTransportedValue = -1.0f;
        for (WorkerWish w : wishes) {
            int turns;
            try {
                turns = carrier.getTurnsToReach(w.getDestination());
            }
            catch (Exception e) {
                logger.warning("Bogus wish destination: " + w.getDestination() + " for wish: " + w.toString());
                continue;
            }
            if (turns == Integer.MAX_VALUE) {
                if (!(bestTransportedValue < (float)w.getValue())) continue;
                bestTransportedValue = w.getValue();
                transported = w;
                continue;
            }
            if (!(bestNonTransportedValue < (float)w.getValue() / (float)turns)) continue;
            bestNonTransportedValue = (float)w.getValue() / (float)turns;
            nonTransported = w;
        }
        return nonTransported != null ? nonTransported : (transported != null ? transported : null);
    }

    private GoodsWish getBestGoodsWish(AIUnit aiUnit, Location start, List<GoodsWish> wishes) {
        if (wishes == null) {
            return null;
        }
        Unit carrier = aiUnit.getUnit();
        float bestValue = 0.0f;
        GoodsWish best = null;
        for (GoodsWish w : wishes) {
            float value;
            int turns = carrier.getTurnsToReach(start, w.getDestination());
            if (turns == Integer.MAX_VALUE || !(bestValue > (value = (float)w.getValue() / (float)turns))) continue;
            bestValue = value;
            best = w;
        }
        return best;
    }

    public boolean retargetCargo(Transportable t, AIUnit aiCarrier, List<TransportMission.Cargo> cargoes) {
        Unit u;
        Unit carrier = aiCarrier.getUnit();
        AIUnit aiu = t instanceof AIUnit ? (AIUnit)t : null;
        AIGoods aig = t instanceof AIGoods ? (AIGoods)t : null;
        Location dst = t.getTransportDestination();
        Unit unit = u = t instanceof AIUnit ? aiu.getUnit() : null;
        if (dst != null && (u == null ? carrier.getTurnsToReach(dst) : u.getTurnsToReach(u.getLocation(), dst, carrier, null)) != Integer.MAX_VALUE) {
            return true;
        }
        for (TransportMission.Cargo cargo : cargoes) {
            Location loc = cargo.getTarget();
            List<Wish> wl = this.transportDemand.get(loc);
            if (wl == null) continue;
            Wish found = null;
            for (Wish w : wl) {
                if (aiu != null && w instanceof WorkerWish) {
                    WorkerWish ww = (WorkerWish)w;
                    if (aiu.getUnit().getType() != ww.getUnitType()) continue;
                    aiu.setMission(this.consumeWorkerWish(aiu, ww));
                    logger.finest("RetargetCargo succeeded on course: " + aiu.getMission());
                    found = w;
                    break;
                }
                if (aig == null || !(w instanceof GoodsWish)) continue;
                GoodsWish gw = (GoodsWish)w;
                if (aig.getGoods().getType() != gw.getGoodsType()) continue;
                aig.setTransportDestination(loc);
                int a = aig.getGoods().getAmount();
                if (a >= gw.getGoodsAmount()) {
                    this.goodsWishes.get(gw.getGoodsType()).remove(gw);
                } else {
                    gw.setGoodsAmount(gw.getGoodsAmount() - a);
                }
                logger.finest("RetargetCargo succeeded on course: " + aig);
                found = w;
                break;
            }
            if (found == null) continue;
            this.transportDemand.get(loc).remove(found);
            return true;
        }
        if (t instanceof AIUnit) {
            Mission m = null;
            if (this.nBuilders > 0 && (m = this.getBuildColonyMission(aiu)) != null) {
                --this.nBuilders;
            } else if (this.nPioneers > 0 && (m = this.getPioneeringMission(aiu)) != null) {
                --this.nPioneers;
            } else if (this.nScouts > 0 && (m = this.getScoutingMission(aiu)) != null) {
                --this.nScouts;
            } else {
                m = this.getSimpleMission(aiu);
                if (m != null && m.getTransportDestination() == null) {
                    m = null;
                }
            }
            if (m != null) {
                aiu.setMission(m);
                logger.finest("RetargetCargo succeeded with new mission: " + aiu.getMission());
                return true;
            }
        } else if (t instanceof AIGoods) {
            List<GoodsWish> wishList = this.goodsWishes.get(aig.getGoodsType());
            GoodsWish gw = this.getBestGoodsWish(aiCarrier, carrier.getLocation(), wishList);
            if (gw != null) {
                wishList.remove(gw);
                aig.setTransportDestination(gw.getDestination());
                logger.finest("RetargetCargo succeeded with new destination: " + aig);
                return true;
            }
            UnitLocation best = null;
            int bestValue = Integer.MAX_VALUE;
            for (AIColony aic : this.getAIColonies()) {
                int value;
                Colony colony = aic.getColony();
                if (colony.getImportAmount(aig.getGoodsType()) < aig.getGoodsAmount() || bestValue <= (value = carrier.getTurnsToReach(colony))) continue;
                bestValue = value;
                best = colony;
            }
            Europe europe = this.getPlayer().getEurope();
            if (europe != null && this.getPlayer().canTrade(aig.getGoodsType()) && carrier.getTurnsToReach(europe) < bestValue) {
                best = europe;
            }
            if (best != null) {
                aig.setTransportDestination(best);
                logger.finest("RetargetCargo reluctantly unloading: " + aig);
                return true;
            }
        }
        return false;
    }

    private void buildWishMaps() {
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            List<WorkerWish> wl = this.workerWishes.get(unitType);
            if (wl == null) {
                this.workerWishes.put(unitType, new ArrayList());
                continue;
            }
            wl.clear();
        }
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            List<GoodsWish> gl = this.goodsWishes.get(goodsType);
            if (gl == null) {
                this.goodsWishes.put(goodsType, new ArrayList());
                continue;
            }
            gl.clear();
        }
        for (Wish w : this.getWishes()) {
            GoodsWish gw;
            if (w instanceof WorkerWish) {
                WorkerWish ww = (WorkerWish)w;
                if (ww.getTransportable() != null) continue;
                Utils.appendToMapList(this.workerWishes, ww.getUnitType(), ww);
                continue;
            }
            if (!(w instanceof GoodsWish) || !((gw = (GoodsWish)w).getDestination() instanceof Colony)) continue;
            Utils.appendToMapList(this.goodsWishes, gw.getGoodsType(), gw);
        }
        if (logger.isLoggable(Level.FINEST)) {
            String logMe = "Wishes (workers) ";
            for (UnitType ut : this.workerWishes.keySet()) {
                List<WorkerWish> wl = this.workerWishes.get(ut);
                if (wl.isEmpty()) continue;
                logMe = logMe + "[";
                for (WorkerWish ww : wl) {
                    logMe = logMe + " " + ww.toString();
                }
                logMe = logMe + " ]";
            }
            logMe = logMe + " (goods) ";
            for (GoodsType gt : this.goodsWishes.keySet()) {
                List<GoodsWish> gl = this.goodsWishes.get(gt);
                if (gl.isEmpty()) continue;
                logMe = logMe + "[";
                for (GoodsWish gw : gl) {
                    logMe = logMe + " " + gw.toString();
                }
                logMe = logMe + " ]";
            }
            logger.finest(logMe);
        }
    }

    public void completeWish(Wish w) {
        if (w instanceof WorkerWish) {
            WorkerWish ww = (WorkerWish)w;
            List<WorkerWish> wl = this.workerWishes.get(ww.getUnitType());
            if (wl != null) {
                wl.remove(ww);
            }
        } else if (w instanceof GoodsWish) {
            GoodsWish gw = (GoodsWish)w;
            List<GoodsWish> gl = this.goodsWishes.get(gw.getGoodsType());
            if (gl != null) {
                gl.remove(gw);
            }
        } else {
            throw new IllegalStateException("Bogus wish: " + w);
        }
    }

    private int buildersNeeded() {
        Player player = this.getPlayer();
        if (!player.canBuildColonies()) {
            return 0;
        }
        int nColonies = 0;
        int nPorts = 0;
        int nWorkers = 0;
        for (Settlement settlement : player.getSettlements()) {
            ++nColonies;
            if (settlement.isConnectedPort()) {
                ++nPorts;
            }
            for (Unit u : settlement.getUnitList()) {
                if (!u.isPerson()) continue;
                ++nWorkers;
            }
        }
        int result = nColonies == 0 || nPorts == 0 ? 2 : (nPorts == 1 && nWorkers >= 3 ? 1 : ((double)nWorkers / (double)nColonies > Math.E ? 1 : 0));
        return result;
    }

    public int pioneersNeeded() {
        return this.tipMap.size() / 2;
    }

    public int scoutsNeeded() {
        return this.getGame().getTurn().getAge() <= 1 ? 3 : 1;
    }

    public AIUnit recruitAIUnitInEurope(int index) {
        int slot;
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        int n = europe.getUnitCount();
        String selectAbility = "model.ability.selectRecruit";
        int n2 = slot = index >= 0 && index < 3 && this.getPlayer().hasAbility("model.ability.selectRecruit") ? index + 1 : 0;
        if (AIMessage.askEmigrate(this, slot) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        return aiUnit;
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        int n = europe.getUnitCount();
        if (AIMessage.askTrainUnitInEurope(this, unitType) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        return aiUnit;
    }

    public List<Wish> getWishes() {
        ArrayList<Wish> wishes = new ArrayList<Wish>();
        for (AIColony aic : this.getAIColonies()) {
            wishes.addAll(aic.getWishes());
        }
        Collections.sort(wishes);
        return wishes;
    }

    private float getNavalStrengthRatio() {
        Player player = this.getPlayer();
        float navalAverage = 0.0f;
        float navalStrength = 0.0f;
        int nPlayers = 0;
        for (Player p : this.getGame().getLiveEuropeanPlayers()) {
            String str;
            if (p.isREF()) continue;
            if (p == player) {
                str = AIMessage.askGetNationSummary(this, p).getNavalStrength();
                try {
                    navalStrength = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            str = AIMessage.askGetNationSummary(this, p).getNavalStrength();
            try {
                navalAverage = Integer.parseInt(str);
                ++nPlayers;
            }
            catch (NumberFormatException e) {}
        }
        if (nPlayers <= 0) {
            return -1.0f;
        }
        return navalStrength / (navalAverage /= (float)nPlayers);
    }

    private void cheat() {
        int nCarrier;
        float naval;
        Specification spec = this.getSpecification();
        Player player = this.getPlayer();
        Market market = player.getMarket();
        Europe europe = player.getEurope();
        Random air = this.getAIRandom();
        int liftBoycottCheatPercent = spec.getInteger("model.option.liftBoycottCheat");
        int equipScoutCheatPercent = spec.getInteger("model.option.equipScoutCheat");
        int landUnitCheatPercent = spec.getInteger("model.option.landUnitCheat");
        int offensiveNavalUnitCheatPercent = spec.getInteger("model.option.offensiveNavalUnitCheat");
        int transportNavalUnitCheatPercent = spec.getInteger("model.option.transportNavalUnitCheat");
        block0: for (GoodsType goodsType : spec.getGoodsTypeList()) {
            if (market.getArrears(goodsType) <= 0 || Utils.randomInt(logger, "Lift Boycott?", air, 100) >= liftBoycottCheatPercent) continue;
            market.setArrears(goodsType, 0);
            for (Colony c : player.getColonies()) {
                for (FreeColObject m : c.getModifiers()) {
                    if (!"model.modifier.colonyGoodsParty".equals(m.getSource())) continue;
                    c.removeModifier((Modifier)m);
                    player.logCheat("lift-boycott at " + c.getName());
                    continue block0;
                }
            }
        }
        if (!this.getAIMain().getFreeColServer().isSinglePlayer() || player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return;
        }
        if (!europe.isEmpty() && this.scoutsNeeded() > 0 && Utils.randomInt(logger, "Equip Scout?", air, 100) < equipScoutCheatPercent) {
            for (Unit u : europe.getUnitList()) {
                if (u.getRole() != Unit.Role.DEFAULT || !u.isPerson() || !this.getAIUnit(u).equipForRole(Unit.Role.SCOUT, true)) continue;
                player.logCheat("equipped scout " + u);
                break;
            }
        }
        if (Utils.randomInt(logger, "Recruit Land Unit?", air, 100) < landUnitCheatPercent) {
            int cost;
            UnitType unitType;
            WorkerWish bestWish = null;
            int bestValue = Integer.MIN_VALUE;
            for (UnitType ut : this.workerWishes.keySet()) {
                WorkerWish ww;
                List<WorkerWish> wl = this.workerWishes.get(ut);
                if (wl.isEmpty() || !ut.isAvailableTo(player) || europe.getUnitPrice(ut) == Integer.MIN_VALUE || bestValue >= (ww = wl.get(0)).getValue()) continue;
                bestValue = ww.getValue();
                bestWish = ww;
            }
            if (bestWish != null) {
                unitType = bestWish.getUnitType();
                cost = europe.getUnitPrice(unitType);
            } else if (player.getImmigration() < player.getImmigrationRequired() / 2) {
                unitType = null;
                cost = player.getRecruitPrice();
            } else {
                unitType = null;
                cost = Integer.MAX_VALUE;
                for (UnitType ut : spec.getUnitTypesTrainedInEurope()) {
                    int price = europe.getUnitPrice(ut);
                    if (cost <= price) continue;
                    cost = price;
                    unitType = ut;
                }
            }
            if (cost != Integer.MAX_VALUE) {
                AIUnit aiUnit;
                if (cost > 0 && !player.checkGold(cost)) {
                    player.modifyGold(cost);
                }
                AIUnit aIUnit = aiUnit = unitType == null ? this.recruitAIUnitInEurope(-1) : this.trainAIUnitInEurope(unitType);
                if (aiUnit != null) {
                    if (bestWish != null) {
                        aiUnit.setMission(this.consumeWorkerWish(aiUnit, bestWish));
                    } else {
                        FreeColObject m;
                        m = this.getSimpleMission(aiUnit);
                        if (m != null) {
                            aiUnit.setMission((Mission)m);
                        }
                    }
                    player.logCheat(unitType == null ? " recruit " + aiUnit.getUnit().getType().toString() : " train " + unitType.toString());
                }
            }
        }
        int nNaval = (naval = this.getNavalStrengthRatio()) == 0.0f ? 100 : (0.0f < naval && naval < 0.5f ? (int)(naval * (float)offensiveNavalUnitCheatPercent) : -1);
        ArrayList<RandomChoice<UnitType>> rc = new ArrayList<RandomChoice<UnitType>>();
        if (Utils.randomInt(logger, "Build Offensive Naval Unit?", air, 100) < nNaval) {
            rc.clear();
            ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
            for (UnitType unitType : spec.getUnitTypeList()) {
                if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(player) || !unitType.hasPrice() || !unitType.isOffensive()) continue;
                navalUnits.add(unitType);
                int weight = unitType.getOffence() * 100000 / europe.getUnitPrice(unitType);
                rc.add(new RandomChoice<UnitType>(unitType, weight));
            }
            this.cheatUnit(rc);
        }
        int n = nCarrier = this.nNavalCarrier > 0 ? transportNavalUnitCheatPercent : -1;
        if (Utils.randomInt(logger, "Build Transport Naval Unit?", air, 100) < nCarrier) {
            rc.clear();
            ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
            for (UnitType unitType : spec.getUnitTypeList()) {
                if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(player) || !unitType.hasPrice() || unitType.getSpace() <= 0) continue;
                navalUnits.add(unitType);
                int weight = unitType.getSpace() * 100000 / europe.getUnitPrice(unitType);
                rc.add(new RandomChoice<UnitType>(unitType, weight));
            }
            this.cheatUnit(rc);
        }
    }

    private void cheatUnit(List<RandomChoice<UnitType>> rc) {
        AIUnit aiUnit;
        Random air;
        UnitType unitToPurchase;
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        int cost = europe.getUnitPrice(unitToPurchase = (UnitType)RandomChoice.getWeightedRandom(logger, "Cheat which unit", air = this.getAIRandom(), rc));
        if (cost > 0 && !player.checkGold(cost)) {
            player.modifyGold(cost);
        }
        if ((aiUnit = this.trainAIUnitInEurope(unitToPurchase)) != null) {
            player.logCheat("build " + unitToPurchase);
        }
    }

    protected void giveNormalMissions() {
        Mission m;
        AIUnit aiUnit;
        TransportMission tm;
        Mission m2;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        int turnNumber = this.getGame().getTurn().getNumber();
        this.reasons.clear();
        ArrayList<TransportMission> transportMissions = new ArrayList<TransportMission>();
        this.nBuilders = this.buildersNeeded();
        this.nPioneers = this.pioneersNeeded();
        this.nScouts = this.scoutsNeeded();
        List<AIUnit> aiUnits = this.getAIUnits();
        ArrayList<AIUnit> navalUnits = new ArrayList<AIUnit>();
        int allUnits = aiUnits.size();
        int i = 0;
        while (i < aiUnits.size()) {
            AIUnit aiUnit2 = aiUnits.get(i);
            Unit unit = aiUnit2.getUnit();
            m2 = aiUnit2.getMission();
            if (unit.isUninitialized() || unit.isDisposed()) {
                this.putReason(aiUnit2, "Invalid");
            } else if (unit.getState() == Unit.UnitState.IN_COLONY && unit.getColony().getUnitCount() <= 1) {
                if (!(aiUnit2.getMission() instanceof WorkInsideColonyMission)) {
                    logger.warning(aiUnit2 + " should WorkInsideColony at " + unit.getColony().getName());
                    m2 = new WorkInsideColonyMission(aiMain, aiUnit2, aiMain.getAIColony(unit.getColony()));
                }
                this.putReason(aiUnit2, "Vital-to-" + unit.getSettlement().getName());
            } else if (unit.isInMission()) {
                this.putReason(aiUnit2, "In-Mission");
            } else if (m2 != null && m2.isValid() && !m2.isOneTime()) {
                if (m2 instanceof BuildColonyMission) {
                    --this.nBuilders;
                } else if (m2 instanceof PioneeringMission) {
                    --this.nPioneers;
                } else if (m2 instanceof ScoutingMission) {
                    --this.nScouts;
                } else if (m2 instanceof TransportMission && (tm = (TransportMission)m2).destinationCapacity() > 0) {
                    transportMissions.add(tm);
                }
                this.putReason(aiUnit2, "Valid");
            } else if (unit.isAtSea()) {
                this.putReason(aiUnit2, "At-Sea");
            } else if (unit.isNaval()) {
                navalUnits.add(aiUnit2);
            } else {
                String reason;
                if (m2 != null && (reason = m2.invalidReason()) != null) {
                    aiUnit2.abortMission(reason);
                }
                ++i;
                continue;
            }
            aiUnits.remove(i);
        }
        String report = Utils.lastPart(this.getPlayer().getNationID(), ".") + ".giveNormalMissions(turn=" + turnNumber + " colonies=" + this.getPlayer().getNumberOfSettlements() + " all-units=" + allUnits + " free-land-units=" + aiUnits.size() + " free-naval-units=" + navalUnits.size() + " builders=" + this.nBuilders + " pioneers=" + this.nPioneers + " scouts=" + this.nScouts + " naval-carriers=" + this.nNavalCarrier + ")";
        if (this.nBuilders > 0) {
            Collections.sort(aiUnits, builderComparator);
            while (!aiUnits.isEmpty() && (m2 = this.getBuildColonyMission(aiUnit = aiUnits.get(0))) != null) {
                aiUnits.remove(0);
                aiUnit.setMission(m2);
                if (this.requestsTransport(aiUnit)) {
                    Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aiUnit.getTransportSource()), aiUnit);
                }
                this.putReason(aiUnit, "New");
                if (--this.nBuilders > 0) continue;
                break;
            }
        }
        if (this.nScouts > 0) {
            Collections.sort(aiUnits, scoutComparator);
            while (!aiUnits.isEmpty() && (m2 = this.getScoutingMission(aiUnit = aiUnits.get(0))) != null) {
                aiUnits.remove(0);
                aiUnit.setMission(m2);
                if (this.requestsTransport(aiUnit)) {
                    Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aiUnit.getTransportSource()), aiUnit);
                }
                this.putReason(aiUnit, "New");
                if (--this.nScouts > 0) continue;
                break;
            }
        }
        if (this.nPioneers > 0) {
            Collections.sort(aiUnits, pioneerComparator);
            while (!aiUnits.isEmpty() && (m2 = this.getPioneeringMission(aiUnit = aiUnits.get(0))) != null) {
                aiUnits.remove(0);
                aiUnit.setMission(m2);
                if (this.requestsTransport(aiUnit)) {
                    Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aiUnit.getTransportSource()), aiUnit);
                }
                this.putReason(aiUnit, "New");
                if (--this.nPioneers > 0) continue;
                break;
            }
        }
        i = 0;
        while (i < aiUnits.size()) {
            aiUnit = aiUnits.get(i);
            Unit unit = aiUnit.getUnit();
            m = this.getSimpleMission(aiUnit);
            if (m != null) {
                aiUnit.setMission(m);
                if (this.requestsTransport(aiUnit)) {
                    Utils.appendToMapList(this.transportSupply, EuropeanAIPlayer.upLoc(aiUnit.getTransportSource()), aiUnit);
                }
                this.putReason(aiUnit, "New");
                aiUnits.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < navalUnits.size()) {
            aiUnit = (AIUnit)navalUnits.get(i);
            m2 = this.getSimpleMission(aiUnit);
            if (m2 != null) {
                aiUnit.setMission(m2);
                this.putReason(aiUnit, "New");
                navalUnits.remove(i);
                if (!(m2 instanceof TransportMission)) continue;
                tm = (TransportMission)m2;
                if (tm.destinationCapacity() > 0) {
                    transportMissions.add(tm);
                }
                for (Unit u : aiUnit.getUnit().getUnitList()) {
                    AIUnit aiu = this.getAIUnit(u);
                    Mission um = aiu.getMission();
                    if (um == null || !um.isValid() || !aiUnits.contains(aiu)) continue;
                    aiUnits.remove(aiu);
                    this.putReason(aiu, "New");
                }
                continue;
            }
            ++i;
        }
        this.allocateTransportables(transportMissions);
        aiUnits.addAll(navalUnits);
        for (AIUnit aiUnit3 : aiUnits) {
            m = aiUnit3.getMission();
            if (m != null && m.isValid() && !m.isOneTime()) continue;
            if (aiUnit3.getMission() instanceof IdleAtSettlementMission) {
                m = aiUnit3.getMission();
            } else {
                m = new IdleAtSettlementMission(aiMain, aiUnit3);
                aiUnit3.setMission(m);
            }
            this.putReason(aiUnit3, "UNUSED");
        }
        if (logger.isLoggable(Level.FINE)) {
            for (AIUnit aiu : this.getAIUnits()) {
                Unit u = aiu.getUnit();
                String reason = this.reasons.get(u);
                if (reason == null) {
                    reason = "OMITTED";
                }
                Mission m3 = aiu.getMission();
                report = report + "\n  " + u.getLocation() + " " + reason + "-" + (m3 == null ? "NoMission" : (m3 instanceof TransportMission ? ((TransportMission)m3).toFullString() : m3.toString()));
            }
            logger.fine(report);
        }
    }

    private void putReason(AIUnit aiUnit, String reason) {
        Unit unit = aiUnit.getUnit();
        Mission mission = aiUnit.getMission();
        this.reasons.put(unit, reason);
    }

    private Mission getSimpleMission(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        if (unit.isNaval()) {
            Mission m = this.getPrivateerMission(aiUnit);
            if (m != null || (m = this.getTransportMission(aiUnit)) != null || (m = this.getSeekAndDestroyMission(aiUnit, 8)) != null || (m = this.getWanderHostileMission(aiUnit)) != null) {
                return m;
            }
        } else {
            if (unit.isCarrier()) {
                return this.getTransportMission(aiUnit);
            }
            Mission m = this.getCashInTreasureTrainMission(aiUnit);
            if (m != null || unit.isDefensiveUnit() && (m = this.getDefendSettlementMission(aiUnit, false)) != null || unit.isColonist() && unit.getSkillLevel() > 0 && (m = this.getWishRealizationMission(aiUnit)) != null || unit.isOffensiveUnit() && (m = this.getSeekAndDestroyMission(aiUnit, 8)) != null || (m = this.getMissionaryMission(aiUnit)) != null || (m = this.getWishRealizationMission(aiUnit)) != null || unit.isDefensiveUnit() && (m = this.getDefendSettlementMission(aiUnit, true)) != null || unit.isOffensiveUnit() && (m = this.getSeekAndDestroyMission(aiUnit, 16)) != null || unit.isOffensiveUnit() && (m = this.getWanderHostileMission(aiUnit)) != null) {
                return m;
            }
        }
        return null;
    }

    public Transportable getBestTransportable(Unit carrier) {
        Location src = carrier.isAtSea() ? carrier.resolveDestination() : carrier.getLocation();
        Transportable best = null;
        float bestValue = 0.0f;
        boolean present = false;
        block0: for (Location loc : this.transportSupply.keySet()) {
            List<Transportable> tl = this.transportSupply.get(loc);
            if (tl.isEmpty()) continue;
            Collections.sort(tl, Transportable.transportableComparator);
            for (Transportable t : tl) {
                float value;
                if (EuropeanAIPlayer.upLoc(t.getTransportSource()) != loc) {
                    logger.warning("Transportable " + t + " should have been claimed from " + loc + " now at " + t.getTransportLocatable().getLocation());
                    continue;
                }
                if (!t.carriableBy(carrier)) continue;
                if (Map.isSameLocation(src, loc)) {
                    best = t;
                    continue block0;
                }
                int turns = t instanceof AIUnit ? ((AIUnit)t).getUnit().getTurnsToReach(src, loc, carrier, null) : carrier.getTurnsToReach(src, loc);
                if (turns == Integer.MAX_VALUE || !(bestValue < (value = (float)(t.getTransportPriority() / (turns + 1))))) continue block0;
                bestValue = value;
                best = t;
                continue block0;
            }
        }
        return best;
    }

    private void allocateTransportables(List<TransportMission> missions) {
        List<Transportable> urgent = this.getUrgentTransportables();
        String logMe = "allocateTransportables(" + missions.size() + "):";
        for (Transportable t : urgent) {
            logMe = logMe + " " + t.toString();
        }
        logger.info(logMe);
        for (Transportable t : urgent) {
            if (missions.isEmpty()) break;
            TransportMission best = null;
            float bestValue = 0.0f;
            boolean present = false;
            for (TransportMission tm : missions) {
                float value;
                TransportMission.Cargo cargo = tm.makeCargo(t);
                if (cargo == null || !tm.spaceAvailable(cargo)) continue;
                int turns = cargo.getTurns();
                if (turns == 0) {
                    value = tm.destinationCapacity();
                    if (!present) {
                        bestValue = 0.0f;
                        present = true;
                    }
                } else {
                    if (present) continue;
                    value = (float)t.getTransportPriority() / (float)turns;
                }
                if (!(bestValue < value)) continue;
                bestValue = value;
                best = tm;
            }
            if (best == null) continue;
            if (best.queueTransportable(t, false)) {
                logger.finest("Queued " + t + " to " + best);
                this.claimTransportable(t);
                if (best.destinationCapacity() > 0) continue;
                missions.remove(best);
                continue;
            }
            logger.warning("Failed to queue " + t + " to " + best);
            missions.remove(best);
        }
    }

    private Mission getBuildColonyMission(AIUnit aiUnit) {
        String reason = BuildColonyMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = BuildColonyMission.findTarget(aiUnit, 5, unit.isInEurope());
        return loc == null ? null : new BuildColonyMission(this.getAIMain(), aiUnit, loc);
    }

    private Mission getCashInTreasureTrainMission(AIUnit aiUnit) {
        String reason = CashInTreasureTrainMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = CashInTreasureTrainMission.findTarget(aiUnit, 20, unit.isInEurope());
        return loc == null ? null : new CashInTreasureTrainMission(this.getAIMain(), aiUnit, loc);
    }

    private Mission getDefendSettlementMission(AIUnit aiUnit, boolean relaxed) {
        String reason = DefendSettlementMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = unit.getLocation();
        double worstValue = 1000000.0;
        Colony worstColony = null;
        for (AIColony aic : this.getAIColonies()) {
            Colony colony = aic.getColony();
            if (!aic.isBadlyDefended()) continue;
            if (unit.isAtLocation(colony.getTile())) {
                worstColony = colony;
                break;
            }
            double d = (double)colony.getDefenceRatio() * 100.0;
            Tile tile = colony.getTile();
            Unit unit2 = unit.getCarrier();
            CostDecider costDecider = relaxed ? CostDeciders.numberOfTiles() : null;
            double value = d / (double)unit.getTurnsToReach(loc, tile, unit2, costDecider);
            if (!(worstValue > value)) continue;
            worstValue = value;
            worstColony = colony;
        }
        if (worstColony == null) {
            return null;
        }
        return new DefendSettlementMission(this.getAIMain(), aiUnit, worstColony);
    }

    public Mission getMissionaryMission(AIUnit aiUnit) {
        String reason = MissionaryMission.prepare(aiUnit);
        if (reason != null) {
            return null;
        }
        Location loc = MissionaryMission.findTarget(aiUnit, 20, true);
        return loc == null ? null : new MissionaryMission(this.getAIMain(), aiUnit);
    }

    public Mission getPioneeringMission(AIUnit aiUnit) {
        String reason = PioneeringMission.prepare(aiUnit);
        if (reason != null) {
            return null;
        }
        Location loc = PioneeringMission.findTarget(aiUnit, 10, true);
        return loc == null ? null : new PioneeringMission(this.getAIMain(), aiUnit, loc);
    }

    private Mission getPrivateerMission(AIUnit aiUnit) {
        String reason = PrivateerMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        return new PrivateerMission(this.getAIMain(), aiUnit);
    }

    public Mission getScoutingMission(AIUnit aiUnit) {
        String reason = ScoutingMission.prepare(aiUnit);
        if (reason != null) {
            return null;
        }
        Location loc = ScoutingMission.findTarget(aiUnit, 20, true);
        return loc == null ? null : new ScoutingMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getSeekAndDestroyMission(AIUnit aiUnit, int range) {
        String reason = UnitSeekAndDestroyMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Location loc = UnitSeekAndDestroyMission.findTarget(aiUnit, range, false);
        return loc == null ? null : new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, loc);
    }

    private Mission getTransportMission(AIUnit aiUnit) {
        String reason = TransportMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        return new TransportMission(this.getAIMain(), aiUnit);
    }

    private Mission getWanderHostileMission(AIUnit aiUnit) {
        String reason = UnitWanderHostileMission.invalidReason(aiUnit);
        if (reason != null) {
            return null;
        }
        return new UnitWanderHostileMission(this.getAIMain(), aiUnit);
    }

    private Mission getWishRealizationMission(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        List<WorkerWish> wwL = this.workerWishes.get(unit.getType());
        WorkerWish best = this.getBestWorkerWish(aiUnit, wwL);
        return best == null ? null : this.consumeWorkerWish(aiUnit, best);
    }

    private Mission consumeWorkerWish(AIUnit aiUnit, WorkerWish ww) {
        Unit unit = aiUnit.getUnit();
        List<WorkerWish> wwL = this.workerWishes.get(unit.getType());
        wwL.remove(ww);
        List<Wish> wl = this.transportDemand.get(ww.getDestination());
        if (wl != null) {
            wl.remove(ww);
        }
        ww.setTransportable(aiUnit);
        return new WishRealizationMission(this.getAIMain(), aiUnit, ww);
    }

    private void bringGifts() {
    }

    private void demandTribute() {
    }

    private void initializeMissions() {
        List<AIUnit> aiUnits = this.getAIUnits();
        AIMain aiMain = this.getAIMain();
        ArrayList carriers = new ArrayList();
        block0: for (AIUnit aiCarrier : aiUnits) {
            Unit carrier;
            if (aiCarrier.hasMission() || !(carrier = aiCarrier.getUnit()).isNaval()) continue;
            Location target = null;
            for (Unit u : carrier.getUnitList()) {
                AIUnit aiu = aiMain.getAIUnit(u);
                if (target == null && (target = BuildColonyMission.findTarget(aiu, 15, false)) == null) continue block0;
                aiu.setMission(new BuildColonyMission(aiMain, aiu, target));
            }
            if (target == null) continue;
            aiCarrier.setMission(new TransportMission(aiMain, aiCarrier));
        }
        for (AIUnit aiu : aiUnits) {
            Mission m;
            if (aiu.hasMission() || (m = this.getSimpleMission(aiu)) == null) continue;
            aiu.setMission(m);
        }
    }

    @Override
    public void startWorking() {
        Turn turn = this.getGame().getTurn();
        logger.finest(this.getClass().getName() + " in " + turn + ": " + Utils.lastPart(this.getPlayer().getNationID(), "."));
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.determineStances();
        if (turn.isFirstTurn()) {
            this.initializeMissions();
        }
        this.buildTipMap();
        for (AIColony aic : this.getAIColonies()) {
            aic.rearrangeWorkers();
            aic.updateAIGoods();
        }
        this.buildTransportMaps();
        this.buildWishMaps();
        this.cheat();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.doMissions();
        for (AIColony aic : this.getAIColonies()) {
            aic.rearrangeWorkers();
        }
        this.buildTransportMaps();
        this.buildWishMaps();
        this.giveNormalMissions();
        this.doMissions();
        for (AIColony aic : this.getAIColonies()) {
            aic.rearrangeWorkers();
        }
        this.clearAIUnits();
        this.tipMap.clear();
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.goodsWishes.clear();
        this.workerWishes.clear();
    }

    @Override
    protected void doMissions() {
        List<AIUnit> aiUnits = this.getAIUnits();
        for (AIUnit aiu : aiUnits) {
            if (aiu.getMission() instanceof TransportMission) continue;
            try {
                aiu.doMission();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
        }
        for (AIUnit aiu : aiUnits) {
            if (!(aiu.getMission() instanceof TransportMission)) continue;
            try {
                aiu.doMission();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
        }
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0 && type == DefendSettlementMission.class) {
            Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
            if (!(loc instanceof Colony)) {
                throw new IllegalStateException("European players defend colonies: " + loc);
            }
            Colony colony = (Colony)loc;
            int defenders = this.getSettlementDefenders(colony);
            value -= 25 * defenders;
            if (colony.hasStockade()) {
                value = defenders > colony.getStockade().getLevel() + 1 ? (value -= 100 * colony.getStockade().getLevel()) : (value -= 20 * colony.getStockade().getLevel());
            }
        }
        return value;
    }

    @Override
    public boolean indianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return !"conquest".equals(this.getAIAdvantage());
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        boolean validOffer = true;
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                switch (stance) {
                    case UNCONTACTED: {
                        validOffer = false;
                        break;
                    }
                    case WAR: {
                        break;
                    }
                    case CEASE_FIRE: {
                        value -= 500;
                        break;
                    }
                    case PEACE: {
                        if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace")) break;
                        value -= 1000;
                        break;
                    }
                    case ALLIANCE: {
                        value -= 2000;
                    }
                }
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        if (validOffer) {
            logger.info("Trade value is " + value + ", accept if >=0");
        } else {
            logger.info("Trade offer is considered invalid!");
        }
        return value >= 0 && validOffer;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Player buyer = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = ((IndianSettlement)settlement).getPriceToSell(goods) + this.getPlayer().getTension(buyer).getValue();
            Unit missionary = ((IndianSettlement)settlement).getMissionary(buyer);
            Specification spec = this.getSpecification();
            if (missionary != null && spec.getBoolean("model.option.enhancedMissionaries")) {
                int bonus = missionary.hasAbility("model.ability.expertMissionary") ? 8 : 9;
                price = price * bonus / 10;
            }
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (Utils.randomInt(logger, "Buy gold", this.getAIRandom(), 3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -2;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method sellProposition");
        Colony colony = (Colony)settlement;
        Player otherPlayer = unit.getOwner();
        int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
        amount = Math.min(amount, goods.getAmount());
        Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
        int percentage = (9 - tensionLevel.ordinal()) * 10;
        int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
        int price = netProfits * percentage / 100;
        return price;
    }

    @Override
    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = this.getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    @Override
    public boolean acceptMercenaries() {
        return this.getPlayer().isAtWar() || "conquest".equals(this.getAIAdvantage());
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = Integer.MIN_VALUE;
        for (FoundingFather father : foundingFathers) {
            if (father == null) continue;
            if (father.hasAbility("model.ability.buildCustomHouse")) {
                bestFather = father;
                break;
            }
            int weight = father.getWeight(age);
            if (weight <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }
}

