/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private static final String tag = "AI colony builder";
    private Location target = null;
    private int colonyValue = -1;

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        logger.finest("AI colony builder starts with target " + target + " and value " + this.colonyValue + ": " + this);
        this.uninitialized = false;
    }

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Tile tile = loc.getTile();
        Colony colony = loc.getColony();
        return BuildColonyMission.invalidReason(aiUnit, tile) == null ? tile : (BuildColonyMission.invalidReason(aiUnit, colony) == null ? colony : null);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        if (path == null || !((loc = BuildColonyMission.extractTarget(aiUnit, path)) instanceof Tile)) {
            return Integer.MIN_VALUE;
        }
        Tile tile = (Tile)loc;
        Player player = aiUnit.getUnit().getOwner();
        float steal = 1.0f;
        switch (player.canClaimToFoundSettlementReason(tile)) {
            case NONE: {
                break;
            }
            case NATIVES: {
                int price = player.getLandPrice(tile);
                if (price <= 0 || player.checkGold(price)) break;
                steal = 0.2f;
                break;
            }
            default: {
                return Integer.MIN_VALUE;
            }
        }
        return (int)((float)player.getColonyValue(tile) * steal / (float)(path.getTotalTurns() + 1));
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value;
                Location loc = BuildColonyMission.extractTarget(aiUnit, path);
                if (loc instanceof Tile && this.bestValue < (value = BuildColonyMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (BuildColonyMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        Unit carrier = unit.getCarrier();
        GoalDecider gd = BuildColonyMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(startTile, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = BuildColonyMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? BuildColonyMission.extractTarget(aiUnit, path) : BuildColonyMission.upLoc(BuildColonyMission.findCircleTarget(aiUnit, BuildColonyMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Tile) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            int n = this.colonyValue = target instanceof Tile ? this.getAIUnit().getUnit().getOwner().getColonyValue((Tile)target) : -1;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return BuildColonyMission.findTarget(this.getAIUnit(), 5, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = BuildColonyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().getOwner().canBuildColonies() ? "player-not-a-colony-founder" : (!aiUnit.getUnit().getType().canBuildColony() ? "unit-not-a-colony-founder" : null));
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return BuildColonyMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        Player.NoClaimReason reason = aiUnit.getUnit().getOwner().canClaimToFoundSettlementReason(tile);
        switch (reason) {
            case NONE: 
            case NATIVES: {
                return null;
            }
        }
        return "target-" + reason.toString();
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = BuildColonyMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? BuildColonyMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof Tile ? BuildColonyMission.invalidTileReason(aiUnit, (Tile)loc) : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return BuildColonyMission.invalidMissionReason(aiUnit);
    }

    public String invalidReason() {
        return BuildColonyMission.invalidReason(this.getAIUnit(), this.target);
    }

    public void doMission() {
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        String reason = this.invalidReason();
        if (!this.isTargetReason(reason)) {
            if (reason != null) {
                logger.finest("AI colony builder broken(" + reason + "): " + this);
                return;
            }
            if (this.target instanceof Tile && player.getColonyValue((Tile)this.target) < this.colonyValue) {
                reason = "target tile " + this.target + " value fell";
            }
        }
        if (reason != null && !this.retargetMission(tag, reason)) {
            return;
        }
        if (this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits()) != Unit.MoveType.MOVE) {
            return;
        }
        if (this.getTarget() instanceof Colony) {
            String name = ((Colony)this.getTarget()).getName();
            Location newTarget = BuildColonyMission.findTarget(aiUnit, 5, false);
            if (newTarget != null) {
                this.setTarget(newTarget);
                logger.finest("AI colony builder arrived at " + name + ", retargeting " + newTarget + ": " + this);
            } else {
                logger.finest("AI colony builder gives up and joins " + name + ": " + this);
                aiUnit.setMission(new WorkInsideColonyMission(aiMain, aiUnit, aiMain.getAIColony((Colony)this.getTarget())));
            }
            return;
        }
        if (this.getTarget() instanceof Tile) {
            Tile tile = (Tile)this.getTarget();
            if (tile.getOwner() != null) {
                if (player.owns(tile)) {
                    Colony colony = (Colony)tile.getOwningSettlement();
                    if (colony != null && colony.getColonyTile(tile) != null) {
                        colony.getColonyTile(tile).relocateWorkers();
                    }
                } else {
                    boolean fail;
                    int price = player.getLandPrice(tile);
                    boolean bl = fail = price < 0;
                    if (price > 0 && !player.checkGold(price) && Utils.randomInt(logger, "Land gold?", this.getAIRandom(), 4) == 0) {
                        player.modifyGold(price);
                        player.logCheat("minted " + price + " gold to buy " + tile);
                    }
                    if (price >= 0) {
                        boolean bl2 = fail = !AIMessage.askClaimLand(tile, aiUnit, price == 0 ? 0 : (player.checkGold(price) ? price : -1)) || !player.owns(tile);
                    }
                    if (fail) {
                        logger.finest("AI colony builder failed to claim land at " + tile + ": " + this);
                        this.setTarget(null);
                        return;
                    }
                }
            }
            if (unit.getMovesLeft() <= 0) {
                logger.finest("AI colony builder waiting to build at " + tile + ": " + this);
                return;
            }
            if (AIMessage.askBuildColony(aiUnit, "") && tile.getColony() != null) {
                Colony colony = tile.getColony();
                logger.finest("AI colony builder completed " + colony.getName() + ": " + this);
                aiUnit.setMission(new WorkInsideColonyMission(aiMain, aiUnit, aiMain.getAIColony(colony)));
            } else {
                logger.warning("AI colony builder unexpected failure at " + tile + ": " + this);
                this.setTarget(null);
            }
        } else {
            throw new IllegalStateException("Bogus target: " + this.getTarget());
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, BuildColonyMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "target", (FreeColGameObject)((Object)this.target));
            if (this.colonyValue > 0) {
                out.writeAttribute("value", Integer.toString(this.colonyValue));
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = this.getGame().getFreeColLocation(str);
        this.colonyValue = this.getAttribute(in, "value", -1);
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }
}

