/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;

public class UnitSeekAndDestroyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitSeekAndDestroyMission.class.getName());
    private static final String tag = "AI seek+destroyer";
    private Location target;

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit) {
        this(aiMain, aiUnit, UnitSeekAndDestroyMission.findTarget(aiUnit, 4, false));
    }

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        logger.finest("AI seek+destroyer begins with target " + target + ": " + this);
        this.uninitialized = false;
    }

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Unit u;
        Tile t;
        Location loc;
        Location location = loc = path == null ? null : path.getLastNode().getLocation();
        return loc == null || aiUnit == null || aiUnit.getUnit() == null ? null : (UnitSeekAndDestroyMission.invalidReason(aiUnit, loc.getSettlement()) == null ? loc.getSettlement() : ((t = loc.getTile()) != null && UnitSeekAndDestroyMission.invalidReason(aiUnit, u = t.getDefendingUnit(aiUnit.getUnit())) == null ? u : null));
    }

    private static int scoreSettlementPath(AIUnit aiUnit, PathNode path, Settlement settlement) {
        IndianSettlement is;
        Tension tension;
        if (UnitSeekAndDestroyMission.invalidSettlementReason(aiUnit, settlement) != null) {
            return Integer.MIN_VALUE;
        }
        Unit unit = aiUnit.getUnit();
        CombatModel combatModel = unit.getGame().getCombatModel();
        int value = 1020;
        value -= path.getTotalTurns() * 100;
        float off = combatModel.getOffencePower(unit, settlement);
        value = (int)((float)value + off * 50.0f);
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            value += 50 * colony.getUnitCount();
            if (colony.hasStockade()) {
                value -= 200 * colony.getStockade().getLevel();
            }
        } else if (settlement instanceof IndianSettlement && (tension = (is = (IndianSettlement)settlement).getAlarm(unit.getOwner())) != null) {
            value += tension.getValue() / 2;
        }
        return aiUnit.getAIOwner().adjustMission(aiUnit, path, UnitSeekAndDestroyMission.class, value);
    }

    private static int scoreUnitPath(AIUnit aiUnit, PathNode path, Unit defender) {
        if (UnitSeekAndDestroyMission.invalidUnitReason(aiUnit, defender) != null) {
            return Integer.MIN_VALUE;
        }
        Unit unit = aiUnit.getUnit();
        Tile tile = path.getLastNode().getTile();
        int turns = path.getTotalTurns();
        CombatModel combatModel = unit.getGame().getCombatModel();
        float off = combatModel.getOffencePower(unit, defender);
        float def = combatModel.getDefencePower(unit, defender);
        if (tile == null || off <= 0.0f) {
            return Integer.MIN_VALUE;
        }
        int value = 1020 - turns * 100;
        value = (int)((float)value + 100.0f * (off - def));
        for (Unit u : tile.getUnitList()) {
            if (!u.canCarryTreasure() || u.getTreasureAmount() <= 0) continue;
            value += 1000;
            break;
        }
        if (defender.isNaval()) {
            if (tile.isLand()) {
                value += 500;
            }
        } else if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
            value += 100;
        }
        return aiUnit.getAIOwner().adjustMission(aiUnit, path, UnitSeekAndDestroyMission.class, value);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
        return loc instanceof Settlement ? UnitSeekAndDestroyMission.scoreSettlementPath(aiUnit, path, (Settlement)loc) : (loc instanceof Unit ? UnitSeekAndDestroyMission.scoreUnitPath(aiUnit, path, (Unit)loc) : Integer.MIN_VALUE);
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value = UnitSeekAndDestroyMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (UnitSeekAndDestroyMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        return unit.search(startTile, UnitSeekAndDestroyMission.getGoalDecider(aiUnit, false), CostDeciders.avoidIllegal(), range, unit.getCarrier());
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = UnitSeekAndDestroyMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? UnitSeekAndDestroyMission.extractTarget(aiUnit, path) : null;
    }

    public Location getTransportDestination() {
        Location loc = this.getTarget();
        return loc == null ? null : (this.getUnit().shouldTakeTransportTo(loc.getTile()) ? loc.getTile() : null);
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Unit || target instanceof Settlement) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return UnitSeekAndDestroyMission.findTarget(this.getAIUnit(), 4, false);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = UnitSeekAndDestroyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isOffensiveUnit() ? "unit-not-offensive" : (aiUnit.getUnit().hasAbility("model.ability.scoutIndianSettlement") ? "scouts-should-not-seek-and-destroy" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        String reason = UnitSeekAndDestroyMission.invalidTargetReason(settlement);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return unit.isNaval() ? "unit-is-naval" : (settlement.getOwner() == unit.getOwner() ? "target-ownership" : UnitSeekAndDestroyMission.invalidAttackReason(aiUnit, settlement.getOwner()));
    }

    private static String invalidUnitReason(AIUnit aiUnit, Unit unit) {
        String reason = UnitSeekAndDestroyMission.invalidTargetReason(unit);
        if (reason != null) {
            return reason;
        }
        Tile tile = unit.getTile();
        return tile == null ? "target-not-on-map" : (aiUnit.getUnit().getOwner() == unit.getOwner() ? "target-ownership" : (tile.getSettlement() != null ? "target-in-settlement" : (!aiUnit.getUnit().isTileAccessible(tile) ? "target-incompatible" : UnitSeekAndDestroyMission.invalidAttackReason(aiUnit, unit.getOwner()))));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return UnitSeekAndDestroyMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = UnitSeekAndDestroyMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? UnitSeekAndDestroyMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Unit ? UnitSeekAndDestroyMission.invalidUnitReason(aiUnit, (Unit)loc) : "target-invalid"));
    }

    public String invalidReason() {
        return UnitSeekAndDestroyMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest("AI seek+destroyer broken(" + reason + "): " + this);
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Location nearbyTarget = UnitSeekAndDestroyMission.findTarget(aiUnit, 1, false);
        if (nearbyTarget != null) {
            if (this.getTarget() == null) {
                logger.finest("AI seek+destroyer retargeted " + nearbyTarget + ": " + this);
                this.setTarget(nearbyTarget);
                nearbyTarget = null;
            } else if (nearbyTarget == this.getTarget()) {
                nearbyTarget = null;
            } else {
                logger.finest("AI seek+destroyer found target-of-opportunity " + nearbyTarget + ": " + this);
            }
        } else if (reason != null) {
            logger.finest("AI seek+destroyer " + reason + ": " + this);
            return;
        }
        Location currentTarget = nearbyTarget != null ? nearbyTarget : this.getTarget();
        Unit.MoveType mt = this.travelToTarget(tag, currentTarget, CostDeciders.avoidSettlementsAndBlockingUnits());
        switch (mt) {
            case MOVE_NO_MOVES: 
            case MOVE_ILLEGAL: {
                break;
            }
            case ATTACK_UNIT: 
            case ATTACK_SETTLEMENT: {
                Tile unitTile = unit.getTile();
                Settlement settlement = unitTile.getSettlement();
                if (settlement != null && settlement.getUnitCount() < 2) {
                    aiUnit.setMission(new DefendSettlementMission(this.getAIMain(), aiUnit, settlement));
                    return;
                }
                Map.Direction dirn = unitTile.getDirection(currentTarget.getTile());
                if (dirn == null) {
                    throw new IllegalStateException("No direction " + unitTile + " to " + currentTarget.getTile());
                }
                logger.finest("AI seek+destroyer attacking " + currentTarget + ": " + this);
                AIMessage.askAttack(aiUnit, dirn);
                break;
            }
            default: {
                logger.finest("AI seek+destroyer unexpected move type: " + (Object)((Object)mt) + ": " + this);
            }
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, UnitSeekAndDestroyMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "target", (FreeColGameObject)((Object)this.target));
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = str == null ? null : this.getGame().getFreeColLocation(str);
    }

    public static String getXMLElementTagName() {
        return "unitSeekAndDestroyMission";
    }
}

