/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ComboProperty
extends PropertyBean
implements PropertyControl {
    String description;
    String label;
    JComboBox mComboBox = new JComboBox();
    private Vector possibleValues;

    public ComboProperty(String description, String label, String[] possibles, TextTranslator pTranslator) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        Vector<String> possibleTranslations = new Vector<String>();
        Iterator i = this.possibleValues.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            possibleTranslations.add(pTranslator.getText(key));
        }
        this.mComboBox.setModel(new DefaultComboBoxModel(possibleTranslations));
        this.mComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                ComboProperty.this.firePropertyChangeEvent();
            }
        });
    }

    public ComboProperty(String description, String label, String[] possibles, List possibleTranslations) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
    }

    public ComboProperty(String description, String label, List possibles, List possibleTranslations) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
    }

    private void fillPossibleValues(String[] possibles) {
        this.fillPossibleValues(Arrays.asList(possibles));
    }

    private void fillPossibleValues(List possibles) {
        this.possibleValues = new Vector();
        this.possibleValues.addAll(possibles);
    }

    public void updateComboBoxEntries(List possibles, List possibleTranslations) {
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
        this.fillPossibleValues(possibles);
        if (possibles.size() > 0) {
            this.mComboBox.setSelectedIndex(0);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValue(String value) {
        if (this.possibleValues.contains(value)) {
            this.mComboBox.setSelectedIndex(this.possibleValues.indexOf(value));
        } else {
            System.err.println("Can't set the value:" + value + " into the combo box " + this.getLabel() + "/" + this.getDescription());
            if (this.mComboBox.getModel().getSize() > 0) {
                this.mComboBox.setSelectedIndex(0);
            }
        }
    }

    public String getValue() {
        return (String)this.possibleValues.get(this.mComboBox.getSelectedIndex());
    }

    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mComboBox);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    public void setEnabled(boolean pEnabled) {
        this.mComboBox.setEnabled(pEnabled);
    }
}

