/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.main.FreeMindMain;
import freemind.modes.MindIcon;
import freemind.modes.common.dialogs.IconSelectionPopupDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;

public class IconProperty
extends PropertyBean
implements PropertyControl,
ActionListener {
    String description;
    String label;
    JButton mButton;
    private final FreeMindMain mFreeMindMain;
    private final Vector mIcons;
    private MindIcon mActualIcon = null;

    public IconProperty(String description, String label, FreeMindMain frame, Vector icons) {
        this.description = description;
        this.label = label;
        this.mFreeMindMain = frame;
        this.mIcons = icons;
        this.mButton = new JButton();
        this.mButton.addActionListener(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValue(String value) {
        Iterator iter = this.mIcons.iterator();
        while (iter.hasNext()) {
            MindIcon icon = (MindIcon)iter.next();
            if (!icon.getName().equals(value)) continue;
            this.mActualIcon = icon;
            this.setIcon(this.mActualIcon);
        }
    }

    private void setIcon(MindIcon actualIcon) {
        this.mButton.setIcon(actualIcon.getIcon());
        this.mButton.setToolTipText(actualIcon.getDescription());
    }

    public String getValue() {
        return this.mActualIcon.getName();
    }

    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mButton);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    public void actionPerformed(ActionEvent arg0) {
        Vector<MindIcon> icons = new Vector<MindIcon>();
        Vector<String> descriptions = new Vector<String>();
        Iterator iter = this.mIcons.iterator();
        while (iter.hasNext()) {
            MindIcon icon = (MindIcon)iter.next();
            icons.add(icon);
            descriptions.add(icon.getDescription());
        }
        IconSelectionPopupDialog dialog = new IconSelectionPopupDialog(this.mFreeMindMain.getJFrame(), icons, this.mFreeMindMain);
        dialog.setLocationRelativeTo(this.mFreeMindMain.getJFrame());
        dialog.setModal(true);
        dialog.setVisible(true);
        int result = dialog.getResult();
        if (result >= 0) {
            MindIcon icon = (MindIcon)this.mIcons.get(result);
            this.setValue(icon.getName());
            this.firePropertyChangeEvent();
        }
    }

    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }
}

