/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.printpreview;

import freemind.controller.printpreview.BrowseAction;
import freemind.controller.printpreview.Preview;
import freemind.controller.printpreview.ZoomAction;
import freemind.main.Tools;
import freemind.view.mindmapview.MapView;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PreviewDialog
extends JDialog
implements ActionListener {
    private static final double DEFAULT_ZOOM_FACTOR_STEP = 0.1;
    private JLabel pageNumber;
    protected MapView view;

    public PreviewDialog(String title, MapView view) {
        super(JOptionPane.getFrameForComponent(view), title, true);
        this.view = view;
        Preview preview = new Preview(view, 1.0);
        JScrollPane scrollPane = new JScrollPane(preview);
        this.getContentPane().add((Component)scrollPane, "Center");
        JToolBar toolbar = new JToolBar();
        this.getContentPane().add((Component)toolbar, "North");
        this.pageNumber = new JLabel("- 1 -");
        JButton button = this.getButton("Back24.gif", new BrowseAction(preview, this.pageNumber, -1));
        toolbar.add(button);
        this.pageNumber.setPreferredSize(button.getPreferredSize());
        this.pageNumber.setHorizontalAlignment(0);
        toolbar.add(this.pageNumber);
        toolbar.add(this.getButton("Forward24.gif", new BrowseAction(preview, this.pageNumber, 1)));
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.getButton("ZoomIn24.gif", new ZoomAction(preview, 0.1)));
        toolbar.add(this.getButton("ZoomOut24.gif", new ZoomAction(preview, -0.1)));
        toolbar.add(new JToolBar.Separator());
        JPanel dialog = new JPanel();
        dialog.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        dialog.add(ok);
        this.getContentPane().add((Component)dialog, "South");
        Tools.addEscapeActionToDialog(this);
    }

    private JButton getButton(String iconName) {
        return this.getButton(null, iconName, null);
    }

    private JButton getButton(String iconName, AbstractAction action) {
        return this.getButton(null, iconName, action);
    }

    private JButton getButton(String name, String iconName, AbstractAction action) {
        JButton result = null;
        ImageIcon icon = null;
        URL imageURL = this.getClass().getClassLoader().getResource("images/" + iconName);
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        }
        if (action != null) {
            if (icon != null) {
                action.putValue("SmallIcon", new ImageIcon(imageURL));
            }
            if (name != null) {
                action.putValue("Name", name);
            }
            result = new JButton(action);
        } else {
            result = new JButton(name, icon);
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

