/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Point;

public class MindMapArrowLinkModel
extends ArrowLinkAdapter {
    public MindMapArrowLinkModel(MindMapNode source, MindMapNode target, FreeMindMain frame) {
        super(source, target, frame);
    }

    public Object clone() {
        return super.clone();
    }

    public String toString() {
        return "Source=" + this.getSource() + ", target=" + this.getTarget() + ", " + this.save().toString();
    }

    public void changeInclination(MapView map, int originX, int originY, int deltaX, int deltaY) {
        Point changedInclination;
        double distSqToTarget = 0.0;
        double distSqToSource = 0.0;
        NodeView targetView = map.getNodeView(this.getTarget());
        NodeView sourceView = map.getNodeView(this.getSource());
        if (targetView != null && sourceView != null) {
            Point targetLinkPoint = targetView.getLinkPoint(this.getEndInclination());
            Point sourceLinkPoint = sourceView.getLinkPoint(this.getStartInclination());
            distSqToTarget = targetLinkPoint.distanceSq(originX, originY);
            distSqToSource = sourceLinkPoint.distanceSq(originX, originY);
        }
        if ((targetView == null || sourceView != null) && distSqToSource < distSqToTarget * 2.25) {
            changedInclination = this.getStartInclination();
            this.changeInclination(deltaX, deltaY, sourceView, changedInclination);
            this.setStartInclination(changedInclination);
        }
        if ((sourceView == null || targetView != null) && distSqToTarget < distSqToSource * 2.25) {
            changedInclination = this.getEndInclination();
            this.changeInclination(deltaX, deltaY, targetView, changedInclination);
            this.setEndInclination(changedInclination);
        }
    }

    private void changeInclination(int deltaX, int deltaY, NodeView linkedNodeView, Point changedInclination) {
        double k;
        if (linkedNodeView.isLeft()) {
            deltaX = -deltaX;
        }
        changedInclination.translate(deltaX, deltaY);
        if (changedInclination.x != 0 && Math.abs((double)changedInclination.y / (double)changedInclination.x) < 0.015) {
            changedInclination.y = 0;
        }
        if ((k = changedInclination.distance(0.0, 0.0)) < 10.0) {
            if (k > 0.0) {
                changedInclination.x = (int)((double)(changedInclination.x * 10) / k);
                changedInclination.y = (int)((double)(changedInclination.y * 10) / k);
            } else {
                changedInclination.x = 10;
            }
        }
    }
}

